/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.examples.mortgage.client;

import javax.swing.JOptionPane;
import org.drools.KnowledgeBase;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentFactory;
import org.drools.definition.type.FactType;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;

public class MortgageClientExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        JOptionPane.showMessageDialog(null, "This example makes a few assumptions:\n- Start the app server on localhost on port 8080.\n- Rename the guvnor war to guvnor.war and deploy it to the app server.\n- Surf to Guvnor and log in.\n- In the menu Administration, Import/Export, import /exported-repositories/mortgage-sample-repository.xml\n- Refresh the browser, open menu Package, click Rebuild all packages.\nClick OK when this is done.", "Preparation", 1);
        StatefulKnowledgeSession ksession = null;
        try {
            KnowledgeBase kbase = MortgageClientExample.readKnowledgeBase();
            FactType appType = kbase.getFactType("mortgages", "LoanApplication");
            Object application = appType.newInstance();
            appType.set(application, "amount", (Object)25000);
            appType.set(application, "deposit", (Object)1500);
            appType.set(application, "lengthYears", (Object)20);
            FactType incomeType = kbase.getFactType("mortgages", "IncomeSource");
            Object income = incomeType.newInstance();
            incomeType.set(income, "type", (Object)"Job");
            incomeType.set(income, "amount", (Object)65000);
            ksession = kbase.newStatefulKnowledgeSession();
            ksession.insert(application);
            ksession.insert(income);
            ksession.fireAllRules();
            String message = "The loan application is now:\n" + application;
            System.out.println(message);
            JOptionPane.showMessageDialog(null, message, "Result", 1);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        finally {
            if (ksession != null) {
                ksession.dispose();
            }
        }
    }

    private static KnowledgeBase readKnowledgeBase() {
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"MortgageAgent");
        Resource changeset = ResourceFactory.newClassPathResource((String)"org/drools/guvnor/examples/mortgage/mortgage-changeset.xml");
        kagent.applyChangeSet(changeset);
        KnowledgeBase kbase = kagent.getKnowledgeBase();
        kagent.dispose();
        return kbase;
    }
}

