/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.Collection;
import org.drools.repository.IFramePerspectiveConfigurationItem;
import org.drools.repository.RepositoryTestCase;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PerspectivesConfigurationItemTest
extends RepositoryTestCase {
    private RulesRepository rulesRepository;

    @Before
    public void setUp() throws Exception {
        this.rulesRepository = this.getRepo();
    }

    @Test
    public void testCreateConfiguration() throws Exception {
        IFramePerspectiveConfigurationItem createdPerspectiveConfigurationItem = this.createTestItem("test name", "http://jboss.org/drools");
        this.assertConfigurationItem("test name", "http://jboss.org/drools", createdPerspectiveConfigurationItem);
    }

    @Test
    public void testLoad() throws Exception {
        IFramePerspectiveConfigurationItem createdPerspectiveConfigurationItem = this.createTestItem("test name", "http://jboss.org/drools");
        IFramePerspectiveConfigurationItem loadedPerspectiveConfigurationItem = this.rulesRepository.loadPerspectivesConfiguration(createdPerspectiveConfigurationItem.getUuid());
        this.assertConfigurationItem("test name", "http://jboss.org/drools", loadedPerspectiveConfigurationItem);
    }

    @Test
    public void testRemove() throws Exception {
        IFramePerspectiveConfigurationItem createdPerspectiveConfigurationItem = this.createTestItem("test name", "http://jboss.org/drools");
        createdPerspectiveConfigurationItem.remove();
        try {
            this.rulesRepository.loadPerspectivesConfiguration(createdPerspectiveConfigurationItem.getUuid());
            Assert.fail((String)"Item should not be in the repository.");
        }
        catch (RulesRepositoryException rulesRepositoryException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadListWhenThereIsNoPerspectivesSaved() throws Exception {
        Collection perspectiveConfigurationItems = this.rulesRepository.listPerspectiveConfigurations();
        Assert.assertNotNull((Object)perspectiveConfigurationItems);
        Assert.assertEquals((long)0L, (long)perspectiveConfigurationItems.size());
    }

    @Test
    public void testLoadList() throws Exception {
        this.createTestItem("test name", "http://jboss.org/drools");
        this.createTestItem("Runtime", "http://localhost/runtime");
        this.createTestItem("Manual", "http://localhost/manual");
        Collection perspectiveConfigurationItems = this.rulesRepository.listPerspectiveConfigurations();
        Assert.assertEquals((long)3L, (long)perspectiveConfigurationItems.size());
    }

    @Test(expected=RulesRepositoryException.class)
    public void testLoadingSomethingThatDoesNotExist() throws Exception {
        this.rulesRepository.loadPerspectivesConfiguration("does-not-exist");
    }

    private IFramePerspectiveConfigurationItem createTestItem(String name, String url) {
        return this.rulesRepository.createPerspectivesConfiguration(name, url);
    }

    private void assertConfigurationItem(String name, String url, IFramePerspectiveConfigurationItem loadedPerspectiveConfigurationItem) {
        Assert.assertNotNull((Object)loadedPerspectiveConfigurationItem.getUuid());
        Assert.assertEquals((Object)name, (Object)loadedPerspectiveConfigurationItem.getName());
        Assert.assertEquals((Object)url, (Object)loadedPerspectiveConfigurationItem.getUrl());
    }
}

