/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.ItemVersionIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.RepositoryTestCase;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.junit.Assert;
import org.junit.Test;

public class ShareableAssetItemTest
extends RepositoryTestCase {
    private PackageItem loadGlobalArea() {
        return this.getRepo().loadGlobalArea();
    }

    @Test
    public void testCreateShareableAsset() throws Exception {
        Calendar now = Calendar.getInstance();
        Thread.sleep(500L);
        AssetItem ruleItem = this.loadGlobalArea().addAsset("testCreateShareableAssetAsset", "desc");
        ruleItem.updateContent("la");
        ruleItem.checkin("initial");
        AssetItem linkedRuleItem = this.getDefaultPackage().addAssetImportedFromGlobalArea(ruleItem.getName());
        linkedRuleItem.updateContent("laa");
        linkedRuleItem.checkin("second");
        Assert.assertEquals((Object)"testCreateShareableAssetAsset", (Object)linkedRuleItem.getName());
        Assert.assertEquals((Object)"testCreateShareableAssetAsset", (Object)ruleItem.getName());
        Assert.assertNotNull((Object)ruleItem.getCreatedDate());
        Assert.assertNotNull((Object)linkedRuleItem.getCreatedDate());
        Assert.assertTrue((boolean)now.before(ruleItem.getCreatedDate()));
        Assert.assertTrue((boolean)now.before(linkedRuleItem.getCreatedDate()));
        Assert.assertEquals((Object)"globalArea", (Object)ruleItem.getPackageName());
        Assert.assertEquals((Object)"globalArea", (Object)linkedRuleItem.getPackageName());
        Assert.assertEquals((Object)this.loadGlobalArea().getUUID(), (Object)ruleItem.getPackage().getUUID());
        Assert.assertEquals((Object)"laa", (Object)linkedRuleItem.getContent());
        Assert.assertEquals((Object)"laa", (Object)ruleItem.getContent());
        Assert.assertNotNull((Object)ruleItem.getUUID());
        Assert.assertNotNull((Object)linkedRuleItem.getUUID());
        Assert.assertTrue((boolean)linkedRuleItem.getUUID().equals(linkedRuleItem.getUUID()));
    }

    @Test
    public void testRemoveShareableAsset() throws Exception {
        AssetItem asset = this.loadGlobalArea().addAsset("testRemoveShareableAssetAsset", "desc");
        asset.updateContent("la");
        asset.checkin("initial");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.updateContent("laa");
        linkedAsset.checkin("second");
        linkedAsset.remove();
        try {
            AssetItem linkedAsset1 = this.getDefaultPackage().loadAsset("testRemoveShareableAssetAsset");
            Assert.fail((String)"Did not get expected exception");
        }
        catch (RulesRepositoryException e) {
            // empty catch block
        }
        AssetItem asset1 = this.loadGlobalArea().loadAsset("testRemoveShareableAssetAsset");
        Assert.assertTrue((boolean)asset.getUUID().equals(asset1.getUUID()));
    }

    @Test
    public void testGetContentLengthForShareableAsset() throws Exception {
        AssetItem ruleItem = this.loadGlobalArea().addAsset("testGetContentLengthForShareableAsset", "desc");
        ruleItem.checkin("initial");
        AssetItem linkedRuleItem = this.getDefaultPackage().addAssetImportedFromGlobalArea(ruleItem.getName());
        Assert.assertEquals((long)0L, (long)ruleItem.getContentLength());
        Assert.assertEquals((long)0L, (long)linkedRuleItem.getContentLength());
        ruleItem.updateContent("boo");
        ruleItem.checkin("");
        Assert.assertEquals((long)"boo".getBytes().length, (long)ruleItem.getContentLength());
        Assert.assertEquals((long)"boo".getBytes().length, (long)linkedRuleItem.getContentLength());
        linkedRuleItem.updateContent("booo");
        linkedRuleItem.checkin("");
        Assert.assertEquals((long)"booo".getBytes().length, (long)ruleItem.getContentLength());
        Assert.assertEquals((long)"booo".getBytes().length, (long)linkedRuleItem.getContentLength());
        ruleItem = this.loadGlobalArea().addAsset("testGetContentLengthForShareableAsset2", "");
        ruleItem.checkin("initial");
        linkedRuleItem = this.getDefaultPackage().addAssetImportedFromGlobalArea(ruleItem.getName());
        Assert.assertEquals((long)0L, (long)ruleItem.getContentLength());
        Assert.assertEquals((long)0L, (long)linkedRuleItem.getContentLength());
        linkedRuleItem.updateBinaryContentAttachment((InputStream)new ByteArrayInputStream("foobar".getBytes()));
        linkedRuleItem.checkin("");
        Assert.assertEquals((long)"foobar".getBytes().length, (long)ruleItem.getContentLength());
        Assert.assertEquals((long)"foobar".getBytes().length, (long)linkedRuleItem.getContentLength());
        ruleItem.updateBinaryContentAttachment((InputStream)new ByteArrayInputStream("foobarr".getBytes()));
        ruleItem.checkin("");
        Assert.assertEquals((long)"foobarr".getBytes().length, (long)ruleItem.getContentLength());
        Assert.assertEquals((long)"foobarr".getBytes().length, (long)linkedRuleItem.getContentLength());
    }

    @Test
    public void testUpdateStringPropertyForShareableAsset() throws Exception {
        AssetItem asset = this.loadGlobalArea().addAsset("testUpdateStringPropertyForShareableAsset", "desc");
        asset.checkin("initial");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.updateContent("new content");
        linkedAsset.checkin("");
        linkedAsset.updateStringProperty("Anything", "AField");
        Assert.assertEquals((Object)"Anything", (Object)linkedAsset.getStringProperty("AField"));
        Assert.assertEquals((Object)"Anything", (Object)asset.getStringProperty("AField"));
        asset.updateStringProperty("More", "AField", false);
        asset.updateContent("more content");
        asset.checkin("");
        asset = this.getRepo().loadAssetByUUID(asset.getUUID());
        Assert.assertEquals((Object)"More", (Object)asset.getStringProperty("AField"));
        Assert.assertEquals((Object)"more content", (Object)asset.getContent());
        linkedAsset = this.getRepo().loadAssetByUUID(linkedAsset.getUUID());
        Assert.assertEquals((Object)"More", (Object)linkedAsset.getStringProperty("AField"));
        Assert.assertEquals((Object)"more content", (Object)asset.getContent());
    }

    @Test
    public void testSimpleGetPackageItemHistoricalForShareableAsset() throws Exception {
        Node node = this.getRepo().getSession().getNode("/drools:repository/drools:package_area/globalArea/");
        Node assetNode = node.getNode("assets").addNode("testKurt", "drools:assetNodeType");
        assetNode.setProperty("drools:packageName", "one");
        assetNode.setProperty("drools:title", "title");
        assetNode.setProperty("drools:format", "format");
        assetNode.setProperty("drools:description", "description");
        Calendar lastModified = Calendar.getInstance();
        assetNode.setProperty("drools:lastModified", lastModified);
        this.getRepo().getSession().save();
        assetNode.checkin();
        this.findAndPrintNodeName(assetNode);
        assetNode.checkout();
        assetNode.addMixin("mix:shareable");
        this.getRepo().getSession().save();
        assetNode.checkin();
        Workspace workspace = this.getRepo().getSession().getWorkspace();
        String srcPath = "/drools:repository/drools:package_area/globalArea/assets/testKurt";
        String path = "/drools:repository/drools:package_area/defaultPackage/assets/testKurt";
        workspace.clone(workspace.getName(), srcPath, path, false);
        this.findAndPrintNodeName(assetNode);
        String packageName = this.getDefaultPackage().getName();
        try {
            Node snaps = this.getRepo().getAreaNode("drools:packagesnapshot_area");
            if (!snaps.hasNode(packageName)) {
                snaps.addNode(packageName, "nt:folder");
                this.getRepo().save();
            }
            String source = "/drools:repository/drools:package_area/defaultPackage";
            String newName = "/drools:repository/drools:packagesnapshot_area/defaultPackage/SNAP";
            this.getRepo().getSession().getWorkspace().copy(source, newName);
        }
        catch (Exception e) {
            Assert.fail();
        }
        this.findAndPrintNodeName(assetNode);
    }

    private void findAndPrintNodeName(Node node) throws ValueFormatException, PathNotFoundException, RepositoryException {
        String UUID = node.getProperty("jcr:baseVersion").getString();
        Node nodeFound = this.getRepo().getSession().getNodeByUUID(UUID);
        System.out.println("Node:" + nodeFound.getName());
    }

    @Test
    public void testGetPackageItemHistoricalForShareableAsset() throws Exception {
        AssetItem asset = this.loadGlobalArea().addAsset("testGetPackageItemHistoricalForShareableAsset", "test content");
        asset.checkin("initial");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        String name = this.getDefaultPackage().getName();
        this.getRepo().createPackageSnapshot(this.getDefaultPackage().getName(), "SNAP");
        PackageItem pkgSnap = this.getRepo().loadPackageSnapshot(this.getDefaultPackage().getName(), "SNAP");
        AssetItem assetSnap = pkgSnap.loadAsset("testGetPackageItemHistoricalForShareableAsset");
        PackageItem pkgSnap1 = assetSnap.getPackage();
        Assert.assertTrue((boolean)pkgSnap1.isSnapshot());
        Assert.assertTrue((boolean)pkgSnap.isSnapshot());
        Assert.assertFalse((boolean)this.getDefaultPackage().isSnapshot());
        Assert.assertEquals((Object)this.getDefaultPackage().getName(), (Object)pkgSnap1.getName());
        AssetItem linkedAsset1 = this.getDefaultPackage().loadAsset("testGetPackageItemHistoricalForShareableAsset");
        PackageItem linkedPkg = linkedAsset1.getPackage();
        Assert.assertFalse((boolean)linkedPkg.isSnapshot());
        Assert.assertFalse((boolean)this.getDefaultPackage().isSnapshot());
        Assert.assertEquals((Object)this.getDefaultPackage().getName(), (Object)linkedPkg.getName());
        linkedAsset.updateDescription("yeah !");
        linkedAsset.checkin("new");
        linkedAsset = this.getDefaultPackage().loadAsset("testGetPackageItemHistoricalForShareableAsset");
        Assert.assertNotNull((Object)linkedAsset.getPackage());
        AssetHistoryIterator linkedIt = linkedAsset.getHistory();
        Assert.assertEquals((long)4L, (long)this.iteratorToList((Iterator)linkedIt).size());
        asset = this.getDefaultPackage().loadAsset("testGetPackageItemHistoricalForShareableAsset");
        AssetHistoryIterator it = asset.getHistory();
        Assert.assertEquals((long)4L, (long)this.iteratorToList((Iterator)it).size());
    }

    private List iteratorToList(Iterator it) {
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Test
    public void testGetContentForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetContentForShareableAsset", "test content");
        AssetItem linkedAsset = this.getRepo().loadDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.updateContent("test content");
        linkedAsset.updateFormat("drl");
        Assert.assertNotNull((Object)linkedAsset.getNode());
        Assert.assertEquals((Object)"test content", (Object)linkedAsset.getContent());
        Assert.assertEquals((Object)"test content", (Object)asset.getContent());
        Assert.assertFalse((boolean)linkedAsset.isBinary());
        Assert.assertFalse((boolean)asset.isBinary());
        Assert.assertNotNull((Object)linkedAsset.getBinaryContentAsBytes());
        Assert.assertNotNull((Object)linkedAsset.getBinaryContentAttachment());
        String content = new String(linkedAsset.getBinaryContentAsBytes());
        Assert.assertNotNull((Object)content);
        content = new String(asset.getBinaryContentAsBytes());
        Assert.assertNotNull((Object)content);
    }

    @Test
    public void testUpdateContentForShareableAsset() throws Exception {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testUpdateContentForShareableAsset", "test content");
        AssetItem linkedAsset = this.getRepo().loadDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        Assert.assertFalse((boolean)asset.getCreator().equals(""));
        Assert.assertFalse((boolean)linkedAsset.getCreator().equals(""));
        linkedAsset.updateContent("test content");
        linkedAsset.checkin("yeah");
        Assert.assertFalse((boolean)linkedAsset.getLastContributor().equals(""));
        Assert.assertFalse((boolean)asset.getLastContributor().equals(""));
        linkedAsset.updateContent("new rule content");
        Assert.assertEquals((Object)"new rule content", (Object)linkedAsset.getContent());
        Assert.assertTrue((boolean)linkedAsset.getNode().getSession().hasPendingChanges());
        Assert.assertTrue((boolean)asset.getNode().getSession().hasPendingChanges());
        asset.checkin("yeah !");
        Assert.assertFalse((boolean)asset.getNode().getSession().hasPendingChanges());
        Assert.assertEquals((Object)"yeah !", (Object)asset.getCheckinComment());
        try {
            linkedAsset.checkin("yeah linked !");
            Assert.fail((String)"Did not get expected exception: Unable to checkin");
        }
        catch (RulesRepositoryException e) {
            // empty catch block
        }
        AssetItem prev = (AssetItem)asset.getPrecedingVersion();
        Assert.assertEquals((Object)"test content", (Object)prev.getContent());
        Assert.assertFalse((boolean)"yeah !".equals(prev.getCheckinComment()));
        asset = this.getDefaultPackage().loadAsset("testUpdateContentForShareableAsset");
        VersionIterator it = asset.getNode().getVersionHistory().getAllVersions();
        Assert.assertTrue((boolean)it.hasNext());
        while (it.hasNext()) {
            Version n = it.nextVersion();
            AssetItem item = new AssetItem(asset.getRulesRepository(), (Node)n);
            Assert.assertNotNull((Object)item);
        }
    }

    @Test
    public void testCategoriesForShareableAsset() {
        this.getRepo().loadCategory("/").addCategory("testCategoriesTag", "description");
        this.getRepo().loadCategory("/").addCategory("testCategoriesTag2", "description");
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testCategoriesForShareableAsset", "desc");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.addCategory("testCategoriesTag");
        List tags = linkedAsset.getCategories();
        Assert.assertEquals((long)1L, (long)tags.size());
        Assert.assertEquals((Object)"testCategoriesTag", (Object)((CategoryItem)tags.get(0)).getName());
        linkedAsset.addCategory("testCategoriesTag2");
        tags = linkedAsset.getCategories();
        Assert.assertEquals((long)2L, (long)tags.size());
        linkedAsset.checkin("woot");
        List result = this.getRepo().findAssetsByCategory((String)"testCategoriesTag", (int)0, (int)-1).assets;
        Assert.assertEquals((long)1L, (long)result.size());
        AssetItem retItem = (AssetItem)result.get(0);
        Assert.assertEquals((Object)"testCategoriesForShareableAsset", (Object)retItem.getName());
        asset.updateContent("foo");
        asset.checkin("latest");
        Assert.assertTrue((asset.getCategories().size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)asset.getCategorySummary());
        Assert.assertEquals((Object)"testCategoriesTag testCategoriesTag2 ", (Object)asset.getCategorySummary());
        result = this.getRepo().findAssetsByCategory((String)"testCategoriesTag2", (int)0, (int)-1).assets;
        Assert.assertEquals((long)1L, (long)result.size());
        asset = (AssetItem)result.get(0);
        Assert.assertEquals((long)2L, (long)asset.getCategories().size());
    }

    @Test
    public void testUpdateCategoriesForShareableAsset() {
        this.getRepo().loadCategory("/").addCategory("testUpdateCategoriesForShareableAssetTag1", "la");
        this.getRepo().loadCategory("/").addCategory("testUpdateCategoriesForShareableAssetTag2", "la");
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testUpdateCategoriesForShareableAsset", "desc");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        String[] cats = new String[]{"testUpdateCategoriesForShareableAssetTag1", "testUpdateCategoriesForShareableAssetTag2"};
        linkedAsset.updateCategoryList(cats);
        linkedAsset.checkin("aaa");
        asset = this.getRepo().loadGlobalArea().loadAsset("testUpdateCategoriesForShareableAsset");
        Assert.assertEquals((long)2L, (long)asset.getCategories().size());
        for (CategoryItem cat : asset.getCategories()) {
            Assert.assertTrue((boolean)cat.getName().startsWith("testUpdateCategoriesForShareableAssetTag"));
        }
    }

    @Test
    public void testRemoveTagForShareableAsset() {
        this.getRepo().loadCategory("/").addCategory("testRemoveTagForShareableAssetTag1", "la");
        this.getRepo().loadCategory("/").addCategory("testRemoveTagForShareableAssetTag2", "description");
        this.getRepo().loadCategory("/").addCategory("testRemoveTagForShareableAssetTag3", "description");
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testRemoveTagForShareableAsset", "desc");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.addCategory("testRemoveTagForShareableAssetTag1");
        List tags = linkedAsset.getCategories();
        Assert.assertEquals((long)1L, (long)tags.size());
        linkedAsset.removeCategory("testRemoveTagForShareableAssetTag1");
        tags = linkedAsset.getCategories();
        Assert.assertEquals((long)0L, (long)tags.size());
        linkedAsset.addCategory("testRemoveTagForShareableAssetTag2");
        linkedAsset.addCategory("testRemoveTagForShareableAssetTag3");
        linkedAsset.checkin("aaa");
        linkedAsset.removeCategory("testRemoveTagForShareableAssetTag3");
        linkedAsset.checkin("aaa");
        this.getRepo().save();
        tags = linkedAsset.getCategories();
        Assert.assertEquals((long)1L, (long)tags.size());
        Assert.assertEquals((Object)"testRemoveTagForShareableAssetTag2", (Object)((CategoryItem)tags.get(0)).getName());
        try {
            this.getRepo().loadCategory("testRemoveTagForShareableAssetTag2").remove();
            Assert.fail((String)"should not be able to remove");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testStatusStufftestRemoveTagForShareableAsset() {
        this.getRepo().createState("testStatusStufftestRemoveTagForShareableAssetStatus");
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testStatusStufftestRemoveTagForShareableAsset", "desc");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        StateItem stateItem1 = linkedAsset.getState();
        Assert.assertEquals((Object)"Draft", (Object)stateItem1.getName());
        Assert.assertEquals((Object)this.getRepo().getState("Draft"), (Object)linkedAsset.getState());
        Assert.assertEquals((Object)"Draft", (Object)linkedAsset.getStateDescription());
        linkedAsset.updateState("testStatusStufftestRemoveTagForShareableAssetStatus");
        Assert.assertEquals((Object)"testStatusStufftestRemoveTagForShareableAssetStatus", (Object)linkedAsset.getState().getName());
    }

    @Test
    public void testGetDateEffectiveForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetDateEffectiveForShareableAsset", "desc");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        Assert.assertTrue((linkedAsset.getDateEffective() == null ? 1 : 0) != 0);
        Calendar cal = Calendar.getInstance();
        linkedAsset.updateDateEffective(cal);
        Calendar cal2 = linkedAsset.getDateEffective();
        Assert.assertEquals((Object)cal, (Object)cal2);
    }

    @Test
    public void testGetDateExpiredForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetDateExpiredForShareableAsset", "desc");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        Assert.assertTrue((linkedAsset.getDateExpired() == null ? 1 : 0) != 0);
        Calendar cal = Calendar.getInstance();
        linkedAsset.updateDateExpired(cal);
        Calendar cal2 = linkedAsset.getDateExpired();
        Assert.assertEquals((Object)cal, (Object)cal2);
    }

    @Test
    public void testSaveAndCheckinDescriptionAndTitleForShareableAsset() throws Exception {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testSaveAndCheckinDescriptionAndTitleForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        Assert.assertEquals((Object)"desc", (Object)linkedAsset.getDescription());
        linkedAsset.updateDescription("test description");
        Assert.assertEquals((Object)"test description", (Object)linkedAsset.getDescription());
        Assert.assertTrue((boolean)this.getRepo().getSession().hasPendingChanges());
        linkedAsset.updateTitle("This is a title");
        Assert.assertTrue((boolean)this.getRepo().getSession().hasPendingChanges());
        linkedAsset.checkin("ya");
        this.getRepo().getSession().save();
        Assert.assertFalse((boolean)this.getRepo().getSession().hasPendingChanges());
        try {
            linkedAsset.getPrecedingVersion().updateTitle("baaad");
            Assert.fail((String)"should not be able to do this");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testGetPrecedingVersionAndRestoreForShareableAsset() throws Exception {
        this.getRepo().loadCategory("/").addCategory("testGetPrecedingVersionAndRestoreCat", "ka");
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetPrecedingVersionAndRestoreForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        Assert.assertNotNull((Object)asset.getPrecedingVersion());
        Assert.assertNotNull((Object)linkedAsset.getPrecedingVersion());
        linkedAsset.addCategory("testGetPrecedingVersionAndRestoreCat");
        linkedAsset.updateContent("test content");
        linkedAsset.updateDescription("descr2");
        Thread.sleep(100L);
        linkedAsset.checkin("boo");
        AssetItem predecessorRuleItem = (AssetItem)linkedAsset.getPrecedingVersion();
        Assert.assertNotNull((Object)predecessorRuleItem);
        Assert.assertNotNull((Object)predecessorRuleItem.getVersionSnapshotUUID());
        Assert.assertFalse((boolean)predecessorRuleItem.getVersionSnapshotUUID().equals(asset.getUUID()));
        Assert.assertEquals((Object)asset.getState().getName(), (Object)predecessorRuleItem.getState().getName());
        AssetItem loadedHistorical = this.getRepo().loadAssetByUUID(predecessorRuleItem.getVersionSnapshotUUID());
        Assert.assertTrue((boolean)loadedHistorical.isHistoricalVersion());
        Assert.assertFalse((asset.getVersionNumber() == loadedHistorical.getVersionNumber() ? 1 : 0) != 0);
        linkedAsset.updateContent("new content");
        linkedAsset.checkin("two changes");
        predecessorRuleItem = (AssetItem)linkedAsset.getPrecedingVersion();
        Assert.assertNotNull((Object)predecessorRuleItem);
        Assert.assertEquals((long)1L, (long)predecessorRuleItem.getCategories().size());
        CategoryItem cat = (CategoryItem)predecessorRuleItem.getCategories().get(0);
        Assert.assertEquals((Object)"testGetPrecedingVersionAndRestoreCat", (Object)cat.getName());
        Assert.assertEquals((Object)"test content", (Object)predecessorRuleItem.getContent());
        Assert.assertEquals((Object)this.getRepo().loadGlobalArea().getName(), (Object)predecessorRuleItem.getPackageName());
        linkedAsset.updateContent("newer lhs");
        linkedAsset.checkin("another");
        predecessorRuleItem = (AssetItem)linkedAsset.getPrecedingVersion();
        Assert.assertNotNull((Object)predecessorRuleItem);
        Assert.assertEquals((Object)"new content", (Object)predecessorRuleItem.getContent());
        predecessorRuleItem = (AssetItem)predecessorRuleItem.getPrecedingVersion();
        Assert.assertNotNull((Object)predecessorRuleItem);
        Assert.assertEquals((Object)"test content", (Object)predecessorRuleItem.getContent());
        long oldVersionNumber = asset.getVersionNumber();
        AssetItem toRestore = this.getRepo().loadAssetByUUID(predecessorRuleItem.getVersionSnapshotUUID());
        this.getRepo().restoreHistoricalAsset(toRestore, linkedAsset, "cause I want to");
        AssetItem restored = this.getRepo().loadDefaultPackage().loadAsset("testGetPrecedingVersionAndRestoreForShareableAsset");
        Assert.assertEquals((Object)predecessorRuleItem.getDescription(), (Object)restored.getDescription());
        Assert.assertEquals((Object)"cause I want to", (Object)restored.getCheckinComment());
        Assert.assertEquals((long)6L, (long)restored.getVersionNumber());
        Assert.assertFalse((oldVersionNumber == restored.getVersionNumber() ? 1 : 0) != 0);
    }

    @Test
    public void testGetSucceedingVersionForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetSucceedingVersionForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        Assert.assertEquals((long)2L, (long)asset.getVersionNumber());
        linkedAsset.updateContent("new content1");
        linkedAsset.checkin("la");
        AssetItem succeedingRuleItem = (AssetItem)linkedAsset.getSucceedingVersion();
        Assert.assertTrue((succeedingRuleItem == null ? 1 : 0) != 0);
        linkedAsset.updateContent("new content2");
        linkedAsset.checkin("la");
        Assert.assertEquals((long)4L, (long)linkedAsset.getVersionNumber());
        AssetItem predecessorRuleItem = (AssetItem)linkedAsset.getPrecedingVersion();
        Assert.assertEquals((Object)"new content1", (Object)predecessorRuleItem.getContent());
        succeedingRuleItem = (AssetItem)predecessorRuleItem.getSucceedingVersion();
        Assert.assertNotNull((Object)succeedingRuleItem);
        Assert.assertEquals((Object)linkedAsset.getContent(), (Object)succeedingRuleItem.getContent());
    }

    @Test
    public void testGetSuccessorVersionsIteratorForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetSuccessorVersionsIteratorForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        ItemVersionIterator iterator = linkedAsset.getSuccessorVersionsIterator();
        Assert.assertNotNull((Object)iterator);
        Assert.assertFalse((boolean)iterator.hasNext());
        linkedAsset.updateContent("new content").checkin("ya");
        iterator = linkedAsset.getSuccessorVersionsIterator();
        Assert.assertNotNull((Object)iterator);
        Assert.assertFalse((boolean)iterator.hasNext());
        AssetItem predecessorRuleItem = (AssetItem)linkedAsset.getPrecedingVersion();
        iterator = predecessorRuleItem.getSuccessorVersionsIterator();
        Assert.assertNotNull((Object)iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        AssetItem nextRuleItem = (AssetItem)iterator.next();
        Assert.assertEquals((Object)"new content", (Object)nextRuleItem.getContent());
        Assert.assertFalse((boolean)iterator.hasNext());
        linkedAsset.updateContent("newer content");
        linkedAsset.checkin("boo");
        iterator = predecessorRuleItem.getSuccessorVersionsIterator();
        Assert.assertNotNull((Object)iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        nextRuleItem = (AssetItem)iterator.next();
        Assert.assertEquals((Object)"new content", (Object)nextRuleItem.getContent());
        Assert.assertTrue((boolean)iterator.hasNext());
        nextRuleItem = (AssetItem)iterator.next();
        Assert.assertEquals((Object)"newer content", (Object)nextRuleItem.getContent());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testGetPredecessorVersionsIteratorForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetPredecessorVersionsIteratorForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.updateContent("test content");
        linkedAsset.checkin("lalalalala");
        ItemVersionIterator iterator = linkedAsset.getPredecessorVersionsIterator();
        Assert.assertNotNull((Object)iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        asset.updateContent("new content");
        asset.checkin("boo");
        iterator = linkedAsset.getPredecessorVersionsIterator();
        Assert.assertNotNull((Object)iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        AssetItem nextRuleItem = (AssetItem)iterator.next();
        Assert.assertEquals((Object)"test content", (Object)nextRuleItem.getContent());
        asset.updateContent("newer content");
        asset.checkin("wee");
        iterator = linkedAsset.getPredecessorVersionsIterator();
        Assert.assertNotNull((Object)iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        nextRuleItem = (AssetItem)iterator.next();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"new content", (Object)nextRuleItem.getContent());
        nextRuleItem = (AssetItem)iterator.next();
        Assert.assertEquals((Object)"test content", (Object)nextRuleItem.getContent());
        Assert.assertEquals((Object)"", (Object)((AssetItem)iterator.next()).getContent());
    }

    @Test
    public void testHistoryIteratorForShareableAsset() throws Exception {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testHistoryIteratorForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset = this.getRepo().loadAssetByUUID(linkedAsset.getUUID());
        linkedAsset.updateContent("wo");
        linkedAsset.checkin("version2");
        asset = this.getRepo().loadAssetByUUID(asset.getUUID());
        asset.updateContent("ya");
        asset.checkin("version3");
        AssetHistoryIterator it = asset.getHistory();
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)it.hasNext());
            it.next();
        }
    }

    @Test
    public void testGetTitleForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetTitleForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        Assert.assertEquals((Object)"testGetTitleForShareableAsset", (Object)linkedAsset.getName());
        Assert.assertEquals((Object)"testGetTitleForShareableAsset", (Object)asset.getName());
        Assert.assertEquals((Object)"testGetTitleForShareableAsset", (Object)linkedAsset.getTitle());
        Assert.assertEquals((Object)"testGetTitleForShareableAsset", (Object)asset.getTitle());
    }

    @Test
    public void testDublinCorePropertiesForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testDublinCorePropertiesForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.updateCoverage("b");
        Assert.assertEquals((Object)"b", (Object)linkedAsset.getCoverage());
        linkedAsset.checkin("woo");
        linkedAsset = this.getDefaultPackage().loadAsset("testDublinCorePropertiesForShareableAsset");
        Assert.assertEquals((Object)"b", (Object)linkedAsset.getCoverage());
        Assert.assertEquals((Object)"", (Object)linkedAsset.getExternalRelation());
        Assert.assertEquals((Object)"", (Object)linkedAsset.getExternalSource());
        linkedAsset = this.getRepo().loadGlobalArea().loadAsset("testDublinCorePropertiesForShareableAsset");
        Assert.assertEquals((Object)"b", (Object)linkedAsset.getCoverage());
        Assert.assertEquals((Object)"", (Object)linkedAsset.getExternalRelation());
        Assert.assertEquals((Object)"", (Object)linkedAsset.getExternalSource());
    }

    @Test
    public void testGetFormatForShareableAsset() throws Exception {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testGetFormatForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.updateContent("la");
        Assert.assertEquals((Object)"txt", (Object)linkedAsset.getFormat());
        Assert.assertTrue((boolean)linkedAsset.getNode().hasProperty("drools:content"));
        Assert.assertFalse((boolean)linkedAsset.getNode().hasProperty("drools:binaryContent"));
        linkedAsset.updateFormat("blah");
        Assert.assertEquals((Object)"blah", (Object)linkedAsset.getFormat());
    }

    @Test
    public void testAnonymousPropertiesForShareableAsset() {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testAnonymousPropertiesForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        linkedAsset.updateUserProperty("fooBar", "value");
        Assert.assertEquals((Object)"value", (Object)linkedAsset.getUserProperty("fooBar"));
        linkedAsset.checkin("lalalala");
        try {
            linkedAsset.updateUserProperty("drools:content", "whee");
            Assert.fail((String)"should not be able to set built in properties this way.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testBinaryAssetForShareableAsset() throws Exception {
        AssetItem asset = this.getRepo().loadGlobalArea().addAsset("testBinaryAssetForShareableAsset", "desc");
        asset.checkin("version0");
        AssetItem linkedAsset = this.getDefaultPackage().addAssetImportedFromGlobalArea(asset.getName());
        String data = "abc 123";
        ByteArrayInputStream in = new ByteArrayInputStream(data.getBytes());
        linkedAsset.updateBinaryContentAttachment((InputStream)in);
        linkedAsset.updateBinaryContentAttachmentFileName("x.x");
        in.close();
        Assert.assertEquals((Object)data, (Object)linkedAsset.getContent());
        Assert.assertFalse((boolean)linkedAsset.getNode().hasProperty("drools:content"));
        Assert.assertTrue((boolean)linkedAsset.getNode().hasProperty("drools:binaryContent"));
        linkedAsset.checkin("lalalala");
        Assert.assertTrue((boolean)linkedAsset.isBinary());
        asset = this.getRepo().loadGlobalArea().loadAsset("testBinaryAssetForShareableAsset");
        InputStream in2 = asset.getBinaryContentAttachment();
        Assert.assertNotNull((Object)in2);
        byte[] data2 = asset.getBinaryContentAsBytes();
        Assert.assertEquals((Object)data, (Object)new String(data2));
        Assert.assertEquals((Object)"x.x", (Object)asset.getBinaryContentAttachmentFileName());
        Assert.assertTrue((boolean)asset.isBinary());
        linkedAsset.updateContent("qed");
        linkedAsset.checkin("");
        linkedAsset = this.getRepo().loadAssetByUUID(linkedAsset.getUUID());
        Assert.assertEquals((Object)"qed", (Object)linkedAsset.getContent());
    }
}

