/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.VersionableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetHistoryIterator
implements Iterator<AssetItem> {
    private Node head;
    private VersionIterator versionIterator;
    private RulesRepository repo;

    public AssetHistoryIterator(RulesRepository repo, Node head) {
        this.head = head;
        this.repo = repo;
        try {
            this.versionIterator = VersionableItem.getVersionManager(head).getVersionHistory(head.getPath()).getAllVersions();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.versionIterator.hasNext();
    }

    @Override
    public AssetItem next() {
        return new AssetItem(this.repo, (Node)((Version)this.versionIterator.next()));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void skip(int i) {
        this.versionIterator.skip((long)i);
    }
}

