/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RepositoryTestCase;
import org.drools.repository.RulesRepository;
import org.junit.Assert;
import org.junit.Test;

public class ArchiveItemTest
extends RepositoryTestCase {
    @Test
    public void testFindArchivedAssets() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.loadDefaultPackage().addAsset("testFindArchivedAssets1", "X");
        repo.loadDefaultPackage().addAsset("testFindArchivedAssets2", "X");
        repo.loadDefaultPackage().addAsset("testFindArchivedAssets3", "X");
        repo.loadDefaultPackage().addAsset("testFindArchivedAssets4", "X");
        AssetItem item = repo.loadDefaultPackage().loadAsset("testFindArchivedAssets1");
        Assert.assertFalse((boolean)item.isArchived());
        item.archiveItem(true);
        item.checkin("archiving item 1");
        item = repo.loadDefaultPackage().loadAsset("testFindArchivedAssets1");
        Assert.assertTrue((boolean)item.isArchived());
        item = repo.loadDefaultPackage().loadAsset("testFindArchivedAssets2");
        Assert.assertFalse((boolean)item.isArchived());
        item.archiveItem(true);
        item.checkin("archiving item 1");
        item = repo.loadDefaultPackage().loadAsset("testFindArchivedAssets2");
        Assert.assertTrue((boolean)item.isArchived());
        item = repo.loadDefaultPackage().loadAsset("testFindArchivedAssets3");
        Assert.assertFalse((boolean)item.isArchived());
        item.archiveItem(true);
        item.checkin("archiving item 1");
        item = repo.loadDefaultPackage().loadAsset("testFindArchivedAssets3");
        Assert.assertTrue((boolean)item.isArchived());
    }

    @Test
    public void testArchiveBooleanFlag() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        AssetItem item = repo.loadDefaultPackage().addAsset("testArchiveBooleanFlag", "yeah");
        Assert.assertFalse((boolean)item.isArchived());
        item.archiveItem(true);
        Assert.assertFalse((boolean)item.getNode().hasProperty("drools:content"));
        Assert.assertTrue((boolean)item.getNode().hasProperty("drools:archive"));
        Assert.assertTrue((boolean)item.isArchived());
        item.checkin("lalalala");
    }

    @Test
    public void testLoadArchivedAsset() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        AssetItem itemAdd = repo.loadDefaultPackage().addAsset("testArchiveBooleanFlag", "yeah");
        itemAdd.archiveItem(true);
        AssetItem item = repo.loadDefaultPackage().loadAsset("testArchiveBooleanFlag");
        System.out.println(item);
        Assert.assertTrue((boolean)item.isArchived());
    }

    @Test
    public void testFindArchivedAssetsByCategory() {
        this.getRepo().loadCategory("/").addCategory("testFindRulesByCatArchive", "yeah");
        AssetItem as1 = this.getDefaultPackage().addAsset("testFindRulesByCategoryArch", "ya", "testFindRulesByCatArchive", "drl");
        this.getDefaultPackage().addAsset("testFindRulesByCategoryArch2", "ya", "testFindRulesByCatArchive", "txt").checkin("version0");
        as1.archiveItem(true);
        as1.checkin("version0");
        Assert.assertEquals((Object)"drl", (Object)as1.getFormat());
        List rules = this.getRepo().findAssetsByCategory((String)"testFindRulesByCatArchive", (int)0, (int)-1).assets;
        Assert.assertEquals((long)1L, (long)rules.size());
        List rules1 = this.getRepo().findAssetsByCategory((String)"testFindRulesByCatArchive", (boolean)true, (int)0, (int)-1).assets;
        Assert.assertEquals((long)2L, (long)rules1.size());
    }

    private List iteratorToList(Iterator it) {
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Test
    public void testLoadPackages() {
        RulesRepository repo = this.getRepo();
        PackageItem item = repo.createPackage("testListPackagesblah", "lalalala");
        Assert.assertNotNull((Object)item.getCreator());
        Assert.assertFalse((boolean)item.getCreator().equals(""));
        List list = this.iteratorToList((Iterator)repo.listPackages());
        int prevSize = list.size();
        repo.createPackage("testListPackages2blah", "abc");
        repo.loadPackage("testListPackages2blah").archiveItem(true);
        repo.createPackage("testListPackages2blah1", "abc");
        repo.createPackage("testListPackages2blah3", "abc");
        repo.createPackage("testListPackages2blah7", "abc");
        PackageIterator localIterator = repo.listPackages();
        list = this.iteratorToList((Iterator)localIterator);
        Assert.assertEquals((long)(prevSize + 3), (long)list.size());
        localIterator = repo.listPackages();
        localIterator.setArchivedIterator(true);
        list = this.iteratorToList((Iterator)localIterator);
        Assert.assertEquals((long)(prevSize + 4), (long)list.size());
    }

    @Test
    public void testFindRulesByNameArchived() throws Exception {
        RulesRepository repo = RepositorySessionUtil.getRepository();
        repo.loadDefaultPackage().addAsset("findRulesByNameArchived1", "X");
        repo.loadDefaultPackage().addAsset("findRulesByNameArchived2", "X");
        repo.save();
        AssetItem item2 = repo.loadDefaultPackage().loadAsset("findRulesByNameArchived1");
        Assert.assertFalse((boolean)item2.isArchived());
        item2.archiveItem(true);
        List list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived1"));
        Assert.assertEquals((long)1L, (long)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived1", true));
        Assert.assertEquals((long)1L, (long)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived2"));
        Assert.assertEquals((long)1L, (long)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived%"));
        Assert.assertEquals((long)2L, (long)list.size());
        repo.createPackageSnapshot("defaultPackage", "testFindRulesByName2");
        repo.save();
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived2"));
        AssetItem item = (AssetItem)list.get(0);
        Assert.assertEquals((Object)"findRulesByNameArchived2", (Object)item.getName());
        Assert.assertEquals((Object)"X", (Object)item.getDescription());
        Assert.assertEquals((long)1L, (long)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived1", true));
        Assert.assertEquals((long)1L, (long)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived1"));
        Assert.assertEquals((long)0L, (long)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived%"));
        Assert.assertEquals((long)1L, (long)list.size());
        list = this.iteratorToList((Iterator)repo.findAssetsByName("findRulesByNameArchived%", true));
        Assert.assertEquals((long)2L, (long)list.size());
    }
}

