/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.drools.repository.AssetHistoryIterator;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemPageResult;
import org.drools.repository.CategoryItem;
import org.drools.repository.ItemVersionIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.RepositoryTestCase;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.VersionableItem;
import org.junit.Assert;
import org.junit.Test;

public class AssetItemTest
extends RepositoryTestCase {
    @Test
    public void testAssetItemCreation() throws Exception {
        Calendar now = Calendar.getInstance();
        Thread.sleep(500L);
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testRuleItem", "test content");
        Assert.assertNotNull((Object)ruleItem1);
        Assert.assertNotNull((Object)ruleItem1.getNode());
        Assert.assertEquals((Object)"testRuleItem", (Object)ruleItem1.getName());
        Assert.assertNotNull((Object)ruleItem1.getCreatedDate());
        Assert.assertTrue((boolean)now.before(ruleItem1.getCreatedDate()));
        String packName = this.getDefaultPackage().getName();
        Assert.assertEquals((Object)packName, (Object)ruleItem1.getPackageName());
        Assert.assertNotNull((Object)ruleItem1.getUUID());
        try {
            PackageItem pitem = this.getRepo().loadDefaultPackage();
            new AssetItem(this.getRepo(), pitem.getNode());
            Assert.fail((String)"Exception not thrown for node of wrong type");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)("Caught unexpected exception: " + e));
        }
    }

    @Test
    public void testGetContentLength() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem pkg = repo.loadDefaultPackage();
        AssetItem asset = pkg.addAsset("testGetContentLength", "");
        Assert.assertEquals((long)0L, (long)asset.getContentLength());
        asset.updateContent("boo");
        asset.checkin("");
        Assert.assertEquals((long)"boo".getBytes().length, (long)asset.getContentLength());
        asset = pkg.addAsset("testGetContentLength2", "");
        Assert.assertEquals((long)0L, (long)asset.getContentLength());
        asset.updateBinaryContentAttachment((InputStream)new ByteArrayInputStream("foobar".getBytes()));
        asset.checkin("");
        Assert.assertEquals((long)"foobar".getBytes().length, (long)asset.getContentLength());
    }

    @Test
    public void testGetPackageItem() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem def = repo.loadDefaultPackage();
        AssetItem asset = repo.loadDefaultPackage().addAsset("testPackageItem", "test content");
        PackageItem pkg = asset.getPackage();
        Assert.assertEquals((Object)def.getName(), (Object)pkg.getName());
        Assert.assertEquals((Object)def.getUUID(), (Object)pkg.getUUID());
    }

    @Test
    public void testUpdateStringProperty() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem def = repo.loadDefaultPackage();
        AssetItem asset = repo.loadDefaultPackage().addAsset("testUpdateStringProperty", "test content");
        asset.updateContent("new content");
        asset.checkin("");
        Calendar lm = asset.getLastModified();
        Thread.sleep(100L);
        asset.updateStringProperty("Anything", "AField");
        Assert.assertEquals((Object)"Anything", (Object)asset.getStringProperty("AField"));
        Calendar lm_ = asset.getLastModified();
        Assert.assertTrue((lm_.getTimeInMillis() > lm.getTimeInMillis() ? 1 : 0) != 0);
        Thread.sleep(100L);
        asset.updateStringProperty("More", "AField", false);
        Assert.assertEquals((long)lm_.getTimeInMillis(), (long)asset.getLastModified().getTimeInMillis());
        asset.updateContent("more content");
        asset.checkin("");
        asset = repo.loadAssetByUUID(asset.getUUID());
        Assert.assertEquals((Object)"More", (Object)asset.getStringProperty("AField"));
    }

    @Test
    public void testGetPackageItemHistorical() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem pkg = repo.createPackage("testGetPackageItemHistorical", "");
        AssetItem asset = pkg.addAsset("whee", "");
        asset.checkin("");
        Assert.assertNotNull((Object)asset.getPackage());
        repo.createPackageSnapshot(pkg.getName(), "SNAP");
        PackageItem pkg_ = repo.loadPackageSnapshot(pkg.getName(), "SNAP");
        AssetItem asset_ = pkg_.loadAsset("whee");
        PackageItem pkg__ = asset_.getPackage();
        Assert.assertTrue((boolean)pkg__.isSnapshot());
        Assert.assertTrue((boolean)pkg_.isSnapshot());
        Assert.assertFalse((boolean)pkg.isSnapshot());
        Assert.assertEquals((Object)pkg.getName(), (Object)pkg__.getName());
        asset.updateDescription("yeah !");
        asset.checkin("new");
        asset = pkg.loadAsset("whee");
        Assert.assertNotNull((Object)asset.getPackage());
        AssetHistoryIterator it = asset.getHistory();
        while (it.hasNext()) {
            AssetItem as = it.next();
            if (as.getVersionNumber() <= 0L) continue;
            System.err.println(as.getVersionNumber());
            System.err.println(as.getPackageName());
            Assert.assertNotNull((Object)as.getPackage());
            Assert.assertEquals((Object)pkg.getName(), (Object)as.getPackage().getName());
        }
    }

    @Test
    public void testGetAssetNameFromFileName() {
        String[] asset = AssetItem.getAssetNameFromFileName((String)"foo.bar");
        Assert.assertEquals((Object)"foo", (Object)asset[0]);
        Assert.assertEquals((Object)"bar", (Object)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"Rule 261.3 Something foo.drl");
        Assert.assertEquals((Object)"Rule 261.3 Something foo", (Object)asset[0]);
        Assert.assertEquals((Object)"drl", (Object)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"Rule_261.3_Something_foo.drl");
        Assert.assertEquals((Object)"Rule_261.3_Something_foo", (Object)asset[0]);
        Assert.assertEquals((Object)"drl", (Object)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"Rule 261.3 Something foo.model.drl");
        Assert.assertEquals((Object)"Rule 261.3 Something foo", (Object)asset[0]);
        Assert.assertEquals((Object)"model.drl", (Object)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"Rule_261.3_Something_foo.model.drl");
        Assert.assertEquals((Object)"Rule_261.3_Something_foo", (Object)asset[0]);
        Assert.assertEquals((Object)"model.drl", (Object)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"application-model-1.0.0.jar");
        Assert.assertEquals((Object)"application-model-1.0.0", (Object)asset[0]);
        Assert.assertEquals((Object)"jar", (Object)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"something-1.0.0.drl");
        Assert.assertEquals((Object)"something-1.0.0", (Object)asset[0]);
        Assert.assertEquals((Object)"drl", (Object)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"foo.bpel.jar");
        Assert.assertEquals((Object)"foo", (Object)asset[0]);
        Assert.assertEquals((Object)"bpel.jar", (Object)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"SubmitApplication.rf");
        Assert.assertEquals((Object)"SubmitApplication", (Object)asset[0]);
        Assert.assertEquals((Object)"rf", (Object)asset[1]);
        asset = AssetItem.getAssetNameFromFileName((String)"Submit.rf");
        Assert.assertEquals((Object)"Submit", (Object)asset[0]);
        Assert.assertEquals((Object)"rf", (Object)asset[1]);
    }

    @Test
    public void testGetContent() {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetContent", "test content");
        ruleItem1.updateContent("test content");
        ruleItem1.updateFormat("drl");
        Assert.assertNotNull((Object)ruleItem1);
        Assert.assertNotNull((Object)ruleItem1.getNode());
        Assert.assertEquals((Object)"test content", (Object)ruleItem1.getContent());
        Assert.assertFalse((boolean)ruleItem1.isBinary());
        Assert.assertNotNull((Object)ruleItem1.getBinaryContentAsBytes());
        Assert.assertNotNull((Object)ruleItem1.getBinaryContentAttachment());
        String content = new String(ruleItem1.getBinaryContentAsBytes());
        Assert.assertNotNull((Object)content);
    }

    @Test
    public void testUpdateContent() throws Exception {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testUpdateContent", "test description");
        Assert.assertFalse((boolean)ruleItem1.getCreator().equals(""));
        ruleItem1.updateContent("test content");
        ruleItem1.checkin("yeah");
        Assert.assertFalse((boolean)ruleItem1.getLastContributor().equals(""));
        ruleItem1.updateContent("new rule content");
        Assert.assertEquals((Object)"new rule content", (Object)ruleItem1.getContent());
        Assert.assertTrue((boolean)ruleItem1.getNode().getSession().hasPendingChanges());
        ruleItem1.checkin("yeah !");
        Assert.assertFalse((boolean)ruleItem1.getNode().getSession().hasPendingChanges());
        Assert.assertEquals((Object)"yeah !", (Object)ruleItem1.getCheckinComment());
        AssetItem prev = (AssetItem)ruleItem1.getPrecedingVersion();
        Assert.assertEquals((Object)"test content", (Object)prev.getContent());
        Assert.assertFalse((boolean)"yeah !".equals(prev.getCheckinComment()));
        Assert.assertEquals((Object)prev, (Object)ruleItem1.getPrecedingVersion());
        ruleItem1 = this.getDefaultPackage().loadAsset("testUpdateContent");
        VersionIterator it = VersionableItem.getVersionManager((Node)ruleItem1.getNode()).getVersionHistory(ruleItem1.getNode().getPath()).getAllVersions();
        Assert.assertTrue((boolean)it.hasNext());
        while (it.hasNext()) {
            Version n = it.nextVersion();
            AssetItem item = new AssetItem(ruleItem1.getRulesRepository(), (Node)n);
            Assert.assertNotNull((Object)item);
        }
    }

    @Test
    public void testCategoriesPagination() {
        PackageItem pkg = this.getRepo().createPackage("testPagination", "");
        this.getRepo().loadCategory("/").addCategory("testPagedTag", "description");
        AssetItem a = pkg.addAsset("testPage1", "test content");
        a.addCategory("testPagedTag");
        a.checkin("");
        a = pkg.addAsset("testPage2", "test content");
        a.addCategory("testPagedTag");
        a.checkin("");
        a = pkg.addAsset("testPage3", "test content");
        a.addCategory("testPagedTag");
        a.checkin("");
        a = pkg.addAsset("testPage4", "test content");
        a.addCategory("testPagedTag");
        a.checkin("");
        a = pkg.addAsset("testPage5", "test content");
        a.addCategory("testPagedTag");
        a.checkin("");
        AssetItemPageResult result = this.getRepo().findAssetsByCategory("testPagedTag", 0, -1);
        Assert.assertTrue((result.currentPosition > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)result.assets.size());
        Assert.assertEquals((Object)false, (Object)result.hasNext);
        result = this.getRepo().findAssetsByCategory("testPagedTag", 0, 2);
        Assert.assertTrue((result.currentPosition > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)true, (Object)result.hasNext);
        Assert.assertEquals((long)2L, (long)result.assets.size());
        Assert.assertEquals((Object)"testPage1", (Object)((AssetItem)result.assets.get(0)).getName());
        Assert.assertEquals((Object)"testPage2", (Object)((AssetItem)result.assets.get(1)).getName());
        result = this.getRepo().findAssetsByCategory("testPagedTag", 2, 2);
        Assert.assertTrue((result.currentPosition > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)true, (Object)result.hasNext);
        Assert.assertEquals((long)2L, (long)result.assets.size());
        Assert.assertEquals((Object)"testPage3", (Object)((AssetItem)result.assets.get(0)).getName());
        Assert.assertEquals((Object)"testPage4", (Object)((AssetItem)result.assets.get(1)).getName());
        result = this.getRepo().findAssetsByCategory("testPagedTag", 2, 3);
        Assert.assertTrue((result.currentPosition > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)false, (Object)result.hasNext);
        Assert.assertEquals((long)3L, (long)result.assets.size());
        Assert.assertEquals((Object)"testPage3", (Object)((AssetItem)result.assets.get(0)).getName());
        Assert.assertEquals((Object)"testPage4", (Object)((AssetItem)result.assets.get(1)).getName());
        Assert.assertEquals((Object)"testPage5", (Object)((AssetItem)result.assets.get(2)).getName());
    }

    @Test
    public void testCategories() {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testAddTag", "test content");
        this.getRepo().loadCategory("/").addCategory("testAddTagTestTag", "description");
        ruleItem1.addCategory("testAddTagTestTag");
        List tags = ruleItem1.getCategories();
        Assert.assertEquals((long)1L, (long)tags.size());
        Assert.assertEquals((Object)"testAddTagTestTag", (Object)((CategoryItem)tags.get(0)).getName());
        this.getRepo().loadCategory("/").addCategory("testAddTagTestTag2", "description");
        ruleItem1.addCategory("testAddTagTestTag2");
        tags = ruleItem1.getCategories();
        Assert.assertEquals((long)2L, (long)tags.size());
        ruleItem1.checkin("woot");
        List result = this.getRepo().findAssetsByCategory((String)"testAddTagTestTag", (int)0, (int)-1).assets;
        Assert.assertEquals((long)1L, (long)result.size());
        AssetItem retItem = (AssetItem)result.get(0);
        Assert.assertEquals((Object)"testAddTag", (Object)retItem.getName());
        ruleItem1.updateContent("foo");
        ruleItem1.checkin("latest");
        Assert.assertTrue((ruleItem1.getCategories().size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)ruleItem1.getCategorySummary());
        Assert.assertEquals((Object)"testAddTagTestTag testAddTagTestTag2 ", (Object)ruleItem1.getCategorySummary());
        result = this.getRepo().findAssetsByCategory((String)"testAddTagTestTag", (int)0, (int)-1).assets;
        Assert.assertEquals((long)1L, (long)result.size());
        ruleItem1 = (AssetItem)result.get(0);
        Assert.assertEquals((long)2L, (long)ruleItem1.getCategories().size());
        Assert.assertEquals((Object)"foo", (Object)ruleItem1.getContent());
        AssetItem prev = (AssetItem)ruleItem1.getPrecedingVersion();
        Assert.assertNotNull((Object)prev);
    }

    @Test
    public void testUpdateCategories() {
        this.getRepo().loadCategory("/").addCategory("testUpdateCategoriesOnAsset", "la");
        this.getRepo().loadCategory("/").addCategory("testUpdateCategoriesOnAsset2", "la");
        AssetItem item = this.getRepo().loadDefaultPackage().addAsset("testUpdateCategoriesOnAsset", "huhuhu");
        String[] cats = new String[]{"testUpdateCategoriesOnAsset", "testUpdateCategoriesOnAsset2"};
        item.updateCategoryList(cats);
        item.checkin("aaa");
        item = this.getRepo().loadDefaultPackage().loadAsset("testUpdateCategoriesOnAsset");
        Assert.assertEquals((long)2L, (long)item.getCategories().size());
        for (CategoryItem cat : item.getCategories()) {
            Assert.assertTrue((boolean)cat.getName().startsWith("testUpdateCategoriesOnAsset"));
        }
    }

    @Test
    public void testFindRulesByCategory() throws Exception {
        this.getRepo().loadCategory("/").addCategory("testFindRulesByCat", "yeah");
        AssetItem as1 = this.getDefaultPackage().addAsset("testFindRulesByCategory1", "ya", "testFindRulesByCat", "drl");
        this.getDefaultPackage().addAsset("testFindRulesByCategory2", "ya", "testFindRulesByCat", "txt").checkin("version0");
        as1.checkin("version0");
        Assert.assertEquals((Object)"drl", (Object)as1.getFormat());
        List rules = this.getRepo().findAssetsByCategory((String)"testFindRulesByCat", (int)0, (int)-1).assets;
        Assert.assertEquals((long)2L, (long)rules.size());
        for (AssetItem element : rules) {
            Assert.assertTrue((boolean)element.getName().startsWith("testFindRulesByCategory"));
        }
        try {
            this.getRepo().loadCategory("testFindRulesByCat").remove();
            Assert.fail((String)"should not be able to remove");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testRemoveTag() {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testRemoveTag", "test content");
        this.getRepo().loadCategory("/").addCategory("TestRemoveCategory", "description");
        ruleItem1.addCategory("TestRemoveCategory");
        List tags = ruleItem1.getCategories();
        Assert.assertEquals((long)1L, (long)tags.size());
        ruleItem1.removeCategory("TestRemoveCategory");
        tags = ruleItem1.getCategories();
        Assert.assertEquals((long)0L, (long)tags.size());
        this.getRepo().loadCategory("/").addCategory("TestRemoveCategory2", "description");
        this.getRepo().loadCategory("/").addCategory("TestRemoveCategory3", "description");
        ruleItem1.addCategory("TestRemoveCategory2");
        ruleItem1.addCategory("TestRemoveCategory3");
        ruleItem1.removeCategory("TestRemoveCategory2");
        tags = ruleItem1.getCategories();
        Assert.assertEquals((long)1L, (long)tags.size());
        Assert.assertEquals((Object)"TestRemoveCategory3", (Object)((CategoryItem)tags.get(0)).getName());
    }

    @Test
    public void testGetTags() {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testGetTags", "test content");
        List tags = ruleItem1.getCategories();
        Assert.assertNotNull((Object)tags);
        Assert.assertEquals((long)0L, (long)tags.size());
        this.getRepo().loadCategory("/").addCategory("testGetTagsTestTag", "description");
        ruleItem1.addCategory("testGetTagsTestTag");
        tags = ruleItem1.getCategories();
        Assert.assertEquals((long)1L, (long)tags.size());
        Assert.assertEquals((Object)"testGetTagsTestTag", (Object)((CategoryItem)tags.get(0)).getName());
    }

    @Test
    public void testSetStateString() {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testSetStateString", "test content");
        this.getRepo().createState("TestState1");
        ruleItem1.updateState("TestState1");
        Assert.assertNotNull((Object)ruleItem1.getState());
        Assert.assertEquals((Object)"TestState1", (Object)ruleItem1.getState().getName());
        this.getRepo().createState("TestState2");
        ruleItem1.updateState("TestState2");
        Assert.assertNotNull((Object)ruleItem1.getState());
        Assert.assertEquals((Object)"TestState2", (Object)ruleItem1.getState().getName());
        ruleItem1 = this.getDefaultPackage().addAsset("foobar", "test description");
        StateItem stateItem1 = this.getRepo().getState("TestState1");
        ruleItem1.updateState(stateItem1);
        Assert.assertNotNull((Object)ruleItem1.getState());
        Assert.assertEquals((Object)ruleItem1.getState().getName(), (Object)"TestState1");
        StateItem stateItem2 = this.getRepo().getState("TestState2");
        ruleItem1.updateState(stateItem2);
        Assert.assertNotNull((Object)ruleItem1.getState());
        Assert.assertEquals((Object)"TestState2", (Object)ruleItem1.getState().getName());
    }

    @Test
    public void testStatusStuff() {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testGetState", "test content");
        StateItem stateItem1 = ruleItem1.getState();
        Assert.assertEquals((Object)"Draft", (Object)stateItem1.getName());
        this.getRepo().createState("TestState1");
        ruleItem1.updateState("TestState1");
        Assert.assertNotNull((Object)ruleItem1.getState());
        Assert.assertEquals((Object)"TestState1", (Object)ruleItem1.getState().getName());
        ruleItem1 = this.getDefaultPackage().addAsset("testGetState2", "wa");
        Assert.assertEquals((Object)"Draft", (Object)ruleItem1.getStateDescription());
        Assert.assertEquals((Object)this.getRepo().getState("Draft"), (Object)ruleItem1.getState());
    }

    @Test
    public void testToString() {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testToString", "test content");
        Assert.assertNotNull((Object)ruleItem1.toString());
    }

    @Test
    public void testGetLastModifiedOnCheckin() throws Exception {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testGetLastModified", "test content");
        Calendar cal = Calendar.getInstance();
        long before = cal.getTimeInMillis();
        Thread.sleep(100L);
        ruleItem1.updateContent("new lhs");
        ruleItem1.checkin("woot");
        Calendar cal2 = ruleItem1.getLastModified();
        long lastMod = cal2.getTimeInMillis();
        cal = Calendar.getInstance();
        long after = cal.getTimeInMillis();
        Assert.assertTrue((before < lastMod ? 1 : 0) != 0);
        Assert.assertTrue((lastMod < after ? 1 : 0) != 0);
    }

    @Test
    public void testGetDateEffective() {
        AssetItem ruleItem1 = this.getDefaultPackage().addAsset("testGetDateEffective", "test content");
        Assert.assertTrue((ruleItem1.getDateEffective() == null ? 1 : 0) != 0);
        Calendar cal = Calendar.getInstance();
        ruleItem1.updateDateEffective(cal);
        Calendar cal2 = ruleItem1.getDateEffective();
        Assert.assertEquals((long)cal.getTimeInMillis(), (long)cal2.getTimeInMillis());
    }

    @Test
    public void testGetDateExpired() {
        try {
            AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetDateExpired", "test content");
            Assert.assertTrue((ruleItem1.getDateExpired() == null ? 1 : 0) != 0);
            Calendar cal = Calendar.getInstance();
            ruleItem1.updateDateExpired(cal);
            Calendar cal2 = ruleItem1.getDateExpired();
            Assert.assertEquals((long)cal.getTimeInMillis(), (long)cal2.getTimeInMillis());
        }
        catch (Exception e) {
            Assert.fail((String)("Caught unexpected exception: " + e));
        }
    }

    @Test
    public void testSaveAndCheckinDescriptionAndTitle() throws Exception {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetDescription", "");
        ruleItem1.checkin("version0");
        Assert.assertEquals((Object)"", (Object)ruleItem1.getDescription());
        ruleItem1.updateDescription("test description");
        Assert.assertEquals((Object)"test description", (Object)ruleItem1.getDescription());
        Assert.assertTrue((boolean)this.getRepo().getSession().hasPendingChanges());
        ruleItem1.updateTitle("This is a title");
        Assert.assertTrue((boolean)this.getRepo().getSession().hasPendingChanges());
        ruleItem1.checkin("ya");
        this.getRepo().getSession().save();
        Assert.assertFalse((boolean)this.getRepo().getSession().hasPendingChanges());
        try {
            ruleItem1.getPrecedingVersion().updateTitle("baaad");
            Assert.fail((String)"should not be able to do this");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testGetPrecedingVersionAndRestore() throws Exception {
        this.getRepo().loadCategory("/").addCategory("foo", "ka");
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetPrecedingVersion", "descr");
        ruleItem1.checkin("version0");
        Assert.assertTrue((ruleItem1.getPrecedingVersion() == null ? 1 : 0) != 0);
        ruleItem1.addCategory("foo");
        ruleItem1.updateContent("test content");
        ruleItem1.updateDescription("descr2");
        Thread.sleep(100L);
        ruleItem1.checkin("boo");
        AssetItem predecessorRuleItem = (AssetItem)ruleItem1.getPrecedingVersion();
        Assert.assertNotNull((Object)predecessorRuleItem);
        Assert.assertNotNull((Object)predecessorRuleItem.getVersionSnapshotUUID());
        Assert.assertFalse((boolean)predecessorRuleItem.getVersionSnapshotUUID().equals(ruleItem1.getUUID()));
        Assert.assertEquals((Object)ruleItem1.getState().getName(), (Object)predecessorRuleItem.getState().getName());
        AssetItem loadedHistorical = this.getRepo().loadAssetByUUID(predecessorRuleItem.getVersionSnapshotUUID());
        Assert.assertTrue((boolean)loadedHistorical.isHistoricalVersion());
        Assert.assertFalse((ruleItem1.getVersionNumber() == loadedHistorical.getVersionNumber() ? 1 : 0) != 0);
        ruleItem1.updateContent("new content");
        ruleItem1.checkin("two changes");
        predecessorRuleItem = (AssetItem)ruleItem1.getPrecedingVersion();
        Assert.assertNotNull((Object)predecessorRuleItem);
        Assert.assertEquals((long)1L, (long)predecessorRuleItem.getCategories().size());
        CategoryItem cat = (CategoryItem)predecessorRuleItem.getCategories().get(0);
        Assert.assertEquals((Object)"foo", (Object)cat.getName());
        Assert.assertEquals((Object)"test content", (Object)predecessorRuleItem.getContent());
        Assert.assertEquals((Object)"defaultPackage", (Object)predecessorRuleItem.getPackageName());
        ruleItem1.updateContent("newer lhs");
        ruleItem1.checkin("another");
        predecessorRuleItem = (AssetItem)ruleItem1.getPrecedingVersion();
        Assert.assertNotNull((Object)predecessorRuleItem);
        Assert.assertEquals((Object)"new content", (Object)predecessorRuleItem.getContent());
        predecessorRuleItem = (AssetItem)predecessorRuleItem.getPrecedingVersion();
        Assert.assertNotNull((Object)predecessorRuleItem);
        Assert.assertEquals((Object)"test content", (Object)predecessorRuleItem.getContent());
        long oldVersionNumber = ruleItem1.getVersionNumber();
        AssetItem toRestore = this.getRepo().loadAssetByUUID(predecessorRuleItem.getVersionSnapshotUUID());
        this.getRepo().restoreHistoricalAsset(toRestore, ruleItem1, "cause I want to");
        AssetItem restored = this.getRepo().loadDefaultPackage().loadAsset("testGetPrecedingVersion");
        Assert.assertEquals((Object)predecessorRuleItem.getDescription(), (Object)restored.getDescription());
        Assert.assertEquals((Object)"cause I want to", (Object)restored.getCheckinComment());
        Assert.assertEquals((long)5L, (long)restored.getVersionNumber());
        Assert.assertFalse((oldVersionNumber == restored.getVersionNumber() ? 1 : 0) != 0);
    }

    @Test
    public void testGetSucceedingVersion() {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetSucceedingVersion", "test description");
        ruleItem1.checkin("version0");
        Assert.assertEquals((long)1L, (long)ruleItem1.getVersionNumber());
        AssetItem succeedingRuleItem = (AssetItem)ruleItem1.getSucceedingVersion();
        Assert.assertTrue((succeedingRuleItem == null ? 1 : 0) != 0);
        ruleItem1.updateContent("new content");
        ruleItem1.checkin("la");
        Assert.assertEquals((long)2L, (long)ruleItem1.getVersionNumber());
        AssetItem predecessorRuleItem = (AssetItem)ruleItem1.getPrecedingVersion();
        Assert.assertEquals((Object)"", (Object)predecessorRuleItem.getContent());
        succeedingRuleItem = (AssetItem)predecessorRuleItem.getSucceedingVersion();
        Assert.assertNotNull((Object)succeedingRuleItem);
        Assert.assertEquals((Object)ruleItem1.getContent(), (Object)succeedingRuleItem.getContent());
    }

    @Test
    public void testGetSuccessorVersionsIterator() {
        try {
            AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetSuccessorVersionsIterator", "test content");
            ruleItem1.checkin("version0");
            ItemVersionIterator iterator = ruleItem1.getSuccessorVersionsIterator();
            Assert.assertNotNull((Object)iterator);
            Assert.assertFalse((boolean)iterator.hasNext());
            ruleItem1.updateContent("new content").checkin("ya");
            iterator = ruleItem1.getSuccessorVersionsIterator();
            Assert.assertNotNull((Object)iterator);
            Assert.assertFalse((boolean)iterator.hasNext());
            AssetItem predecessorRuleItem = (AssetItem)ruleItem1.getPrecedingVersion();
            iterator = predecessorRuleItem.getSuccessorVersionsIterator();
            Assert.assertNotNull((Object)iterator);
            Assert.assertTrue((boolean)iterator.hasNext());
            AssetItem nextRuleItem = (AssetItem)iterator.next();
            Assert.assertEquals((Object)"new content", (Object)nextRuleItem.getContent());
            Assert.assertFalse((boolean)iterator.hasNext());
            ruleItem1.updateContent("newer content");
            ruleItem1.checkin("boo");
            iterator = predecessorRuleItem.getSuccessorVersionsIterator();
            Assert.assertNotNull((Object)iterator);
            Assert.assertTrue((boolean)iterator.hasNext());
            nextRuleItem = (AssetItem)iterator.next();
            Assert.assertEquals((Object)"new content", (Object)nextRuleItem.getContent());
            Assert.assertTrue((boolean)iterator.hasNext());
            nextRuleItem = (AssetItem)iterator.next();
            Assert.assertEquals((Object)"newer content", (Object)nextRuleItem.getContent());
            Assert.assertFalse((boolean)iterator.hasNext());
        }
        catch (Exception e) {
            Assert.fail((String)("Caught unexpected exception: " + e));
        }
    }

    @Test
    public void testGetPredecessorVersionsIterator() {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetPredecessorVersionsIterator", "test description");
        ruleItem1.checkin("version0");
        ItemVersionIterator iterator = ruleItem1.getPredecessorVersionsIterator();
        Assert.assertNotNull((Object)iterator);
        Assert.assertFalse((boolean)iterator.hasNext());
        ruleItem1.updateContent("test content");
        ruleItem1.checkin("lalalalala");
        iterator = ruleItem1.getPredecessorVersionsIterator();
        Assert.assertNotNull((Object)iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        ruleItem1.updateContent("new content");
        ruleItem1.checkin("boo");
        iterator = ruleItem1.getPredecessorVersionsIterator();
        Assert.assertNotNull((Object)iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        AssetItem nextRuleItem = (AssetItem)iterator.next();
        Assert.assertEquals((Object)"test content", (Object)nextRuleItem.getContent());
        ruleItem1.updateContent("newer content");
        ruleItem1.checkin("wee");
        iterator = ruleItem1.getPredecessorVersionsIterator();
        Assert.assertNotNull((Object)iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        nextRuleItem = (AssetItem)iterator.next();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"new content", (Object)nextRuleItem.getContent());
        nextRuleItem = (AssetItem)iterator.next();
        Assert.assertEquals((Object)"test content", (Object)nextRuleItem.getContent());
        Assert.assertEquals((Object)"", (Object)((AssetItem)iterator.next()).getContent());
    }

    @Test
    public void testHistoryIterator() throws Exception {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testHistoryIterator", "test description");
        ruleItem1.checkin("version0");
        ruleItem1 = this.getRepo().loadAssetByUUID(ruleItem1.getUUID());
        ruleItem1.updateContent("wo");
        ruleItem1.checkin("version1");
        ruleItem1 = this.getRepo().loadAssetByUUID(ruleItem1.getUUID());
        ruleItem1.updateContent("ya");
        ruleItem1.checkin("version2");
        AssetHistoryIterator it = ruleItem1.getHistory();
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)it.hasNext());
            it.next();
        }
    }

    @Test
    public void testGetAssetItemWithSpecifiedVersion() throws Exception {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetAssetItemWithSpecifiedVersion", "test description");
        ruleItem1.checkin("version0");
        ruleItem1 = this.getRepo().loadAssetByUUID(ruleItem1.getUUID());
        ruleItem1.updateContent("wo");
        ruleItem1.checkin("version1");
        ruleItem1 = this.getRepo().loadAssetByUUID(ruleItem1.getUUID());
        ruleItem1.updateContent("ya");
        ruleItem1.checkin("version2");
        AssetItem assetItemVersion1 = this.getRepo().loadDefaultPackage().loadAsset("testGetAssetItemWithSpecifiedVersion", 1L);
        Assert.assertEquals((Object)"", (Object)assetItemVersion1.getContent());
        Assert.assertEquals((long)1L, (long)assetItemVersion1.getVersionNumber());
        AssetItem assetItemVersion2 = this.getRepo().loadDefaultPackage().loadAsset("testGetAssetItemWithSpecifiedVersion", 2L);
        Assert.assertEquals((Object)"wo", (Object)assetItemVersion2.getContent());
        Assert.assertEquals((long)2L, (long)assetItemVersion2.getVersionNumber());
        AssetItem assetItemVersion3 = this.getRepo().loadDefaultPackage().loadAsset("testGetAssetItemWithSpecifiedVersion", 3L);
        Assert.assertEquals((Object)"ya", (Object)assetItemVersion3.getContent());
        Assert.assertEquals((long)3L, (long)assetItemVersion3.getVersionNumber());
    }

    @Test
    public void testGetTitle() {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetTitle", "test content");
        Assert.assertEquals((Object)"testGetTitle", (Object)ruleItem1.getTitle());
    }

    @Test
    public void testDublinCoreProperties() {
        PackageItem pkg = this.getRepo().createPackage("testDublinCore", "wa");
        AssetItem ruleItem = pkg.addAsset("testDublinCoreProperties", "yeah yeah yeah");
        ruleItem.updateCoverage("b");
        Assert.assertEquals((Object)"b", (Object)ruleItem.getCoverage());
        ruleItem.checkin("woo");
        pkg = this.getRepo().loadPackage("testDublinCore");
        ruleItem = (AssetItem)pkg.getAssets().next();
        Assert.assertEquals((Object)"b", (Object)ruleItem.getCoverage());
        Assert.assertEquals((Object)"", (Object)ruleItem.getExternalRelation());
        Assert.assertEquals((Object)"", (Object)ruleItem.getExternalSource());
    }

    @Test
    public void testGetFormat() throws Exception {
        AssetItem ruleItem1 = this.getRepo().loadDefaultPackage().addAsset("testGetFormat", "test content");
        ruleItem1.updateContent("la");
        Assert.assertEquals((Object)"txt", (Object)ruleItem1.getFormat());
        Assert.assertTrue((boolean)ruleItem1.getNode().hasProperty("drools:content"));
        Assert.assertFalse((boolean)ruleItem1.getNode().hasProperty("drools:binaryContent"));
        ruleItem1.updateFormat("blah");
        Assert.assertEquals((Object)"blah", (Object)ruleItem1.getFormat());
    }

    @Test
    public void testAnonymousProperties() {
        AssetItem item = this.getRepo().loadDefaultPackage().addAsset("anonymousproperty", "lalalalala");
        item.updateUserProperty("fooBar", "value");
        Assert.assertEquals((Object)"value", (Object)item.getUserProperty("fooBar"));
        item.checkin("lalalala");
        try {
            item.updateUserProperty("drools:content", "whee");
            Assert.fail((String)"should not be able to set built in properties this way.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testBinaryAsset() throws Exception {
        AssetItem item = this.getRepo().loadDefaultPackage().addAsset("testBinaryAsset", "yeah");
        String data = "abc 123";
        ByteArrayInputStream in = new ByteArrayInputStream(data.getBytes());
        item.updateBinaryContentAttachment((InputStream)in);
        item.updateBinaryContentAttachmentFileName("x.x");
        in.close();
        Assert.assertEquals((Object)data, (Object)item.getContent());
        Assert.assertFalse((boolean)item.getNode().hasProperty("drools:content"));
        Assert.assertTrue((boolean)item.getNode().hasProperty("drools:binaryContent"));
        item.checkin("lalalala");
        Assert.assertTrue((boolean)item.isBinary());
        item = this.getRepo().loadDefaultPackage().loadAsset("testBinaryAsset");
        InputStream in2 = item.getBinaryContentAttachment();
        Assert.assertNotNull((Object)in2);
        byte[] data2 = item.getBinaryContentAsBytes();
        Assert.assertEquals((Object)data, (Object)new String(data2));
        Assert.assertEquals((Object)"x.x", (Object)item.getBinaryContentAttachmentFileName());
        Assert.assertTrue((boolean)item.isBinary());
        item.updateContent("qed");
        item.checkin("");
        item = this.getRepo().loadAssetByUUID(item.getUUID());
        Assert.assertEquals((Object)"qed", (Object)item.getContent());
    }
}

