/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.repository.RepositorySessionUtil;
import org.drools.repository.RepositoryTestCase;
import org.drools.repository.security.PermissionManager;
import org.junit.Assert;
import org.junit.Test;

public class PermissionManagerTest
extends RepositoryTestCase {
    @Test
    public void testLoadSave() throws Exception {
        PermissionManager pm = new PermissionManager(RepositorySessionUtil.getRepository());
        HashMap<String, List<String>> perms = new HashMap<String, List<String>>(){
            {
                this.put("package.admin", new ArrayList<String>(){
                    {
                        this.add("1234567890");
                    }
                });
                this.put("package.developer", new ArrayList<String>(){
                    {
                        this.add("1");
                        this.add("2");
                    }
                });
                this.put("analyst", new ArrayList<String>(){
                    {
                        this.add("HR");
                    }
                });
                this.put("admin", new ArrayList());
            }
        };
        pm.updateUserPermissions("wankle", (Map)perms);
        Map perms_ = pm.retrieveUserPermissions("wankle");
        Assert.assertEquals((long)perms.size(), (long)perms_.size());
        perms_ = pm.retrieveUserPermissions("wankle");
        Assert.assertEquals((long)perms.size(), (long)perms_.size());
        List padmin = (List)perms_.get("package.admin");
        Assert.assertEquals((long)1L, (long)padmin.size());
        Assert.assertEquals((Object)"1234567890", padmin.get(0));
        List pdev = (List)perms_.get("package.developer");
        Assert.assertEquals((long)2L, (long)pdev.size());
        perms = new HashMap<String, List<String>>(){
            {
                this.put("admin", null);
            }
        };
        pm.updateUserPermissions("wankle2", (Map)perms);
        perms_ = pm.retrieveUserPermissions("wankle2");
        List aperms = (List)perms_.get("admin");
        Assert.assertEquals((long)0L, (long)aperms.size());
        perms_.remove("admin");
        Assert.assertEquals((long)0L, (long)perms_.size());
        pm.updateUserPermissions("wankle2", perms_);
        perms_ = pm.retrieveUserPermissions("wankle2");
        Assert.assertEquals((long)0L, (long)perms_.size());
        perms_ = pm.retrieveUserPermissions("wankle");
        padmin = (List)perms_.get("package.admin");
        Assert.assertEquals((long)1L, (long)padmin.size());
        Assert.assertEquals((Object)"1234567890", padmin.get(0));
        Assert.assertTrue((boolean)pm.listUsers().containsKey("wankle"));
        pm.removeUserPermissions("wankle");
        Assert.assertFalse((boolean)pm.listUsers().containsKey("wankle"));
    }

    @Test
    public void testUpdatePerms() throws Exception {
        PermissionManager pm = new PermissionManager(RepositorySessionUtil.getRepository());
        Map<String, List<String>> perms = new HashMap<String, List<String>>(){
            {
                this.put("package.admin", new ArrayList<String>(){
                    {
                        this.add("1234567890");
                    }
                });
                this.put("package.developer", new ArrayList<String>(){
                    {
                        this.add("1");
                        this.add("2");
                    }
                });
                this.put("analyst", new ArrayList<String>(){
                    {
                        this.add("HR");
                    }
                });
                this.put("admin", new ArrayList());
            }
        };
        pm.updateUserPermissions("testUpdatePermsWankle", (Map)perms);
        perms = pm.retrieveUserPermissions("testUpdatePermsWankle");
        Assert.assertEquals((long)4L, (long)perms.size());
        perms.remove("package.developer");
        pm.updateUserPermissions("testUpdatePermsWankle", perms);
        perms = pm.retrieveUserPermissions("testUpdatePermsWankle");
        Assert.assertEquals((long)3L, (long)perms.size());
    }

    @Test
    public void testNilUser() throws Exception {
        PermissionManager pm = new PermissionManager(RepositorySessionUtil.getRepository());
        Map perms_ = pm.retrieveUserPermissions("nobody");
        Assert.assertEquals((long)0L, (long)perms_.size());
        perms_ = pm.retrieveUserPermissions("nobody");
        Assert.assertEquals((long)0L, (long)perms_.size());
    }

    @Test
    public void testListingUsers() throws Exception {
        PermissionManager pm = new PermissionManager(RepositorySessionUtil.getRepository());
        pm.deleteAllUsers();
        HashMap<String, List<String>> perms = new HashMap<String, List<String>>(){
            {
                this.put("package.admin", new ArrayList<String>(){
                    {
                        this.add("1234567890");
                    }
                });
                this.put("package.developer", new ArrayList<String>(){
                    {
                        this.add("1");
                        this.add("2");
                    }
                });
                this.put("analyst", new ArrayList<String>(){
                    {
                        this.add("HR");
                    }
                });
                this.put("admin", new ArrayList());
            }
        };
        pm.updateUserPermissions("listingUser1", (Map)perms);
        perms = new HashMap<String, List<String>>(){
            {
                this.put("admin", new ArrayList());
            }
        };
        pm.updateUserPermissions("listingUser2", (Map)perms);
        pm.updateUserPermissions("listingUser3", (Map)perms);
        perms = new HashMap<String, List<String>>(){
            {
                this.put("package.developer", new ArrayList<String>(){
                    {
                        this.add("1");
                        this.add("2");
                    }
                });
            }
        };
        pm.updateUserPermissions("listingUser4", (Map)perms);
        perms = new HashMap<String, List<String>>(){
            {
                this.put("analyst", new ArrayList<String>(){
                    {
                        this.add("1");
                        this.add("2");
                    }
                });
            }
        };
        pm.updateUserPermissions("listingUser5", (Map)perms);
        Map result = pm.listUsers();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)5L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("listingUser1"));
        Assert.assertTrue((boolean)result.containsKey("listingUser2"));
        Assert.assertTrue((boolean)result.containsKey("listingUser3"));
        Assert.assertTrue((boolean)result.containsKey("listingUser4"));
        Assert.assertTrue((boolean)result.containsKey("listingUser5"));
        List permTypes = (List)result.get("listingUser1");
        Assert.assertEquals((long)4L, (long)permTypes.size());
        Assert.assertTrue((boolean)permTypes.contains("package.developer"));
        permTypes = (List)result.get("listingUser5");
        Assert.assertEquals((long)1L, (long)permTypes.size());
        Assert.assertEquals((Object)"analyst", permTypes.get(0));
    }

    @Test
    public void testEmptyUserName() throws Exception {
        PermissionManager pm = new PermissionManager(RepositorySessionUtil.getRepository());
        Map perms_ = pm.retrieveUserPermissions("");
        Assert.assertEquals((long)0L, (long)perms_.size());
        perms_ = pm.retrieveUserPermissions("  ");
        Assert.assertEquals((long)0L, (long)perms_.size());
        HashMap<String, List<String>> perms = new HashMap<String, List<String>>(){
            {
                this.put("package.admin", new ArrayList<String>(){
                    {
                        this.add("1234567890");
                    }
                });
                this.put("package.developer", new ArrayList<String>(){
                    {
                        this.add("1");
                        this.add("2");
                    }
                });
                this.put("analyst", new ArrayList<String>(){
                    {
                        this.add("HR");
                    }
                });
                this.put("admin", new ArrayList());
            }
        };
        pm.updateUserPermissions(" ", (Map)perms);
        pm.updateUserPermissions("", (Map)perms);
        pm.removeUserPermissions("");
        pm.removeUserPermissions("  ");
    }
}

