/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RepositoryTestCase;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.StateItem;
import org.drools.repository.VersionedAssetItemIterator;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class PackageItemTest
extends RepositoryTestCase {
    private PackageItem loadGlobalArea() {
        return this.getRepo().loadGlobalArea();
    }

    @Test
    public void testListPackages() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem item = repo.createPackage("testListPackages1", "lalalala");
        Assert.assertNotNull((Object)item.getCreator());
        item.updateStringProperty("goo", "whee");
        Assert.assertEquals((Object)"goo", (Object)item.getStringProperty("whee"));
        Assert.assertFalse((boolean)item.getCreator().equals(""));
        List list = this.iteratorToList((Iterator)repo.listPackages());
        int prevSize = list.size();
        repo.createPackage("testListPackages2", "abc");
        list = this.iteratorToList((Iterator)repo.listPackages());
        Assert.assertEquals((long)(prevSize + 1), (long)list.size());
    }

    @Test
    @Ignore(value="JackRabbit errors about node type for property {}testing. Probably repository changes have broken test.")
    public void testAddPackageProperties() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem item = repo.createPackage("testListPackages1", "lalalala");
        Assert.assertNotNull((Object)item.getCreator());
        String[] testProp = new String[]{"Test1", "Test2"};
        item.node.checkout();
        item.node.setProperty("testing", testProp);
        String[] newProp = item.getStringPropertyArray("testing");
        Assert.assertTrue((boolean)testProp[0].equals(newProp[0]));
        Assert.assertTrue((boolean)"Test2".equals(newProp[1]));
        Assert.assertFalse((boolean)item.getCreator().equals(""));
        List list = this.iteratorToList((Iterator)repo.listPackages());
        int prevSize = list.size();
        repo.createPackage("testListPackages2", "abc");
        list = this.iteratorToList((Iterator)repo.listPackages());
        Assert.assertEquals((long)(prevSize + 1), (long)list.size());
    }

    @Test
    public void testPackageRemove() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem p = repo.createPackage("removeMe", "");
        AssetItem a = p.addAsset("Whee", "");
        a.updateContent("yeah");
        a.checkin("la");
        p.addAsset("Waa", "");
        repo.save();
        PackageItem pkgNested = p.createSubPackage("NestedGoodness");
        Assert.assertNotNull((Object)pkgNested);
        int n = this.iteratorToList((Iterator)repo.listPackages()).size();
        p = repo.loadPackage("removeMe");
        p.remove();
        repo.save();
        int n_ = this.iteratorToList((Iterator)repo.listPackages()).size();
        Assert.assertEquals((long)(n - 1), (long)n_);
    }

    @Test
    public void testRulePackageItem() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem rulePackageItem1 = repo.createPackage("testRulePackage", "desc");
        Assert.assertNotNull((Object)rulePackageItem1);
        Assert.assertEquals((Object)"testRulePackage", (Object)rulePackageItem1.getName());
        PackageIterator it = this.getRepo().listPackages();
        Assert.assertTrue((boolean)it.hasNext());
        while (it.hasNext()) {
            PackageItem pack = (PackageItem)it.next();
            if (!pack.getName().equals("testRulePackage")) continue;
            return;
        }
        Assert.fail((String)"should have picked up the testRulePackage but didnt.");
    }

    @Test
    public void testPackageCopy() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem pkg = repo.createPackage("testPackageCopy", "this is something");
        AssetItem it1 = pkg.addAsset("testPackageCopy1", "la");
        AssetItem it2 = pkg.addAsset("testPackageCopy2", "la");
        it1.updateContent("new content");
        it2.updateContent("more content");
        it1.checkin("c");
        it2.checkin("c");
        it1 = pkg.loadAsset("testPackageCopy1");
        List hist1 = this.iteratorToList((Iterator)it1.getHistory());
        System.out.println(hist1.size());
        repo.getSession().getWorkspace().copy(pkg.getNode().getPath(), pkg.getNode().getPath() + "_");
        PackageItem pkg2 = repo.loadPackage("testPackageCopy_");
        Assert.assertNotNull((Object)pkg2);
        Assert.assertEquals((long)2L, (long)this.iteratorToList(pkg2.getAssets()).size());
        AssetItem it1_ = pkg2.loadAsset("testPackageCopy1");
        it1.updateContent("new content2");
        it1.checkin("la");
        it1_ = pkg2.loadAsset("testPackageCopy1");
        Assert.assertEquals((Object)"new content", (Object)it1_.getContent());
    }

    @Test
    public void testPackageSnapshot() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem pkg = repo.createPackage("testPackageSnapshot", "this is something");
        Assert.assertFalse((boolean)pkg.isSnapshot());
        AssetItem it1 = pkg.addAsset("testPackageCopy1", "la");
        AssetItem it2 = pkg.addAsset("testPackageCopy2", "la");
        it1.updateContent("new content");
        it1.updateFormat("drl");
        it2.updateContent("more content");
        it2.updateFormat("drl");
        it1.checkin("c");
        it2.checkin("c");
        long ver1 = it1.getVersionNumber();
        long ver2 = it2.getVersionNumber();
        Assert.assertFalse((ver1 == 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)this.iteratorToList((Iterator)pkg.listAssetsByFormat(new String[]{"drl"})).size());
        repo.createPackageSnapshot("testPackageSnapshot", "PROD 2.0");
        PackageItem pkgLoaded = repo.loadPackageSnapshot("testPackageSnapshot", "PROD 2.0");
        Assert.assertTrue((boolean)pkgLoaded.isSnapshot());
        Assert.assertEquals((Object)"PROD 2.0", (Object)pkgLoaded.getSnapshotName());
        Assert.assertEquals((Object)"testPackageSnapshot", (Object)pkgLoaded.getName());
        PackageItem _pkgLoaded = repo.loadPackageByUUID(pkgLoaded.getUUID());
        Assert.assertNotNull((Object)_pkgLoaded);
        Assert.assertEquals((Object)pkgLoaded.getCreatedDate(), (Object)_pkgLoaded.getCreatedDate());
        Assert.assertEquals((Object)pkgLoaded.getName(), (Object)_pkgLoaded.getName());
        List loadedAssets = this.iteratorToList(pkgLoaded.getAssets());
        List _loadedAssets = this.iteratorToList(_pkgLoaded.getAssets());
        Assert.assertEquals((long)loadedAssets.size(), (long)_loadedAssets.size());
        it1.updateContent("XXX");
        it1.checkin("X");
        Assert.assertFalse((it1.getVersionNumber() == ver1 ? 1 : 0) != 0);
        AssetItem it3 = pkg.addAsset("testPackageCopy3", "x");
        it3.updateFormat("drl");
        it3.checkin("a");
        Assert.assertEquals((long)3L, (long)this.iteratorToList((Iterator)pkg.listAssetsByFormat(new String[]{"drl"})).size());
        PackageItem pkg2 = repo.loadPackageSnapshot("testPackageSnapshot", "PROD 2.0");
        Assert.assertNotNull((Object)pkg2);
        List snapAssets = this.iteratorToList(pkg2.getAssets());
        Assert.assertEquals((long)2L, (long)snapAssets.size());
        Assert.assertFalse((boolean)pkg2.getUUID().equals(pkg.getUUID()));
        Assert.assertTrue((boolean)(snapAssets.get(0) instanceof AssetItem));
        Assert.assertTrue((boolean)(snapAssets.get(1) instanceof AssetItem));
        AssetItem sn1 = (AssetItem)snapAssets.get(0);
        AssetItem sn2 = (AssetItem)snapAssets.get(1);
        Assert.assertEquals((Object)"la", (Object)sn1.getDescription());
        Assert.assertEquals((Object)"la", (Object)sn2.getDescription());
        Assert.assertEquals((long)ver1, (long)sn1.getVersionNumber());
        Assert.assertEquals((long)ver2, (long)sn2.getVersionNumber());
        Assert.assertEquals((long)2L, (long)this.iteratorToList((Iterator)pkg2.listAssetsByFormat(new String[]{"drl"})).size());
        String[] res = repo.listPackageSnapshots("testPackageSnapshot");
        Assert.assertEquals((long)1L, (long)res.length);
        Assert.assertEquals((Object)"PROD 2.0", (Object)res[0]);
        res = repo.listPackageSnapshots("does not exist");
        Assert.assertEquals((long)0L, (long)res.length);
        repo.removePackageSnapshot("testPackageSnapshot", "XX");
        try {
            repo.removePackageSnapshot("NOTHING SENSIBLE", "XX");
            Assert.fail((String)"should not be able to remove this.");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        repo.removePackageSnapshot("testPackageSnapshot", "PROD 2.0");
        repo.save();
        res = repo.listPackageSnapshots("testPackageSnapshot");
        Assert.assertEquals((long)0L, (long)res.length);
        repo.createPackageSnapshot("testPackageSnapshot", "BOO");
        res = repo.listPackageSnapshots("testPackageSnapshot");
        Assert.assertEquals((long)1L, (long)res.length);
        repo.copyPackageSnapshot("testPackageSnapshot", "BOO", "BOO2");
        res = repo.listPackageSnapshots("testPackageSnapshot");
        Assert.assertEquals((long)2L, (long)res.length);
        repo.copyPackageSnapshot("testPackageSnapshot", "BOO", "BOO2");
        res = repo.listPackageSnapshots("testPackageSnapshot");
        Assert.assertEquals((long)2L, (long)res.length);
        Assert.assertEquals((Object)"BOO", (Object)res[0]);
        Assert.assertEquals((Object)"BOO2", (Object)res[1]);
    }

    @Test
    public void testLoadRulePackageItem() {
        PackageItem rulePackageItem = this.getRepo().createPackage("testLoadRuleRuleItem", "desc");
        rulePackageItem = this.getRepo().loadPackage("testLoadRuleRuleItem");
        Assert.assertNotNull((Object)rulePackageItem);
        Assert.assertEquals((Object)"testLoadRuleRuleItem", (Object)rulePackageItem.getName());
        Assert.assertEquals((Object)"desc", (Object)rulePackageItem.getDescription());
        Assert.assertEquals((Object)"package", (Object)rulePackageItem.getFormat());
        try {
            rulePackageItem = this.getRepo().loadPackage("anotherRuleRuleItem");
            Assert.fail((String)"Exception not thrown loading rule package that was not created.");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testPackageRuleVersionExtraction() throws Exception {
        PackageItem pack = this.getRepo().createPackage("package extractor", "foo");
        AssetItem rule1 = pack.addAsset("rule number 1", "yeah man");
        rule1.checkin("version0");
        AssetItem rule2 = pack.addAsset("rule number 2", "no way");
        rule2.checkin("version0");
        AssetItem rule3 = pack.addAsset("rule number 3", "yes way");
        rule3.checkin("version0");
        this.getRepo().save();
        pack = this.getRepo().loadPackage("package extractor");
        List rules = this.iteratorToList(pack.getAssets());
        Assert.assertEquals((long)3L, (long)rules.size());
        this.getRepo().createState("foobar");
        StateItem state = this.getRepo().getState("foobar");
        rule1.updateState("foobar");
        rule1.checkin("yeah");
        pack = this.getRepo().loadPackage("package extractor");
        rules = this.iteratorToList(pack.getAssetsWithStatus(state));
        Assert.assertEquals((long)1L, (long)rules.size());
        this.getRepo().createState("whee");
        rules = this.iteratorToList(pack.getAssetsWithStatus(this.getRepo().getState("whee")));
        Assert.assertEquals((long)0L, (long)rules.size());
        rules = this.iteratorToList(pack.getAssetsWithStatus(this.getRepo().getState("Draft")));
        Assert.assertEquals((long)3L, (long)rules.size());
        rule1.updateContent("new content");
        this.getRepo().createState("extractorState");
        rule1.updateState("extractorState");
        rule1.checkin("latest");
        rules = this.iteratorToList(pack.getAssetsWithStatus(this.getRepo().getState("extractorState")));
        Assert.assertEquals((long)1L, (long)rules.size());
        AssetItem rule = (AssetItem)rules.get(0);
        Assert.assertEquals((Object)"new content", (Object)rule.getContent());
        this.getRepo().createState("foobar");
        rules = this.iteratorToList(pack.getAssetsWithStatus(this.getRepo().getState("foobar")));
        Assert.assertEquals((long)1L, (long)rules.size());
        AssetItem prior = (AssetItem)rules.get(0);
        Assert.assertFalse((boolean)"new content".equals(prior.getContent()));
    }

    @Test
    public void testIgnoreState() throws Exception {
        PackageItem pack = this.getRepo().createPackage("package testIgnoreState", "foo");
        this.getRepo().createState("x");
        AssetItem rule1 = pack.addAsset("rule number 1", "yeah man");
        rule1.updateState("x");
        rule1.checkin("version0");
        AssetItem rule2 = pack.addAsset("rule number 2", "no way");
        rule2.updateState("x");
        rule2.checkin("version0");
        AssetItem rule3 = pack.addAsset("rule number 3", "yes way");
        this.getRepo().createState("disabled");
        rule3.updateState("disabled");
        rule3.checkin("version0");
        this.getRepo().save();
        Iterator result = pack.getAssetsWithStatus(this.getRepo().getState("x"), this.getRepo().getState("disabled"));
        List l = this.iteratorToList(result);
        Assert.assertEquals((long)2L, (long)l.size());
    }

    @Test
    public void testDuplicatePackageName() throws Exception {
        PackageItem pack = this.getRepo().createPackage("dupePackageTest", "testing for dupe");
        Assert.assertNotNull((Object)pack.getName());
        try {
            this.getRepo().createPackage("dupePackageTest", "this should fail");
            Assert.fail((String)"Should not be able to add a package of the same name.");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testPackageInstanceWrongNodeType() throws Exception {
        PackageItem pack = this.getRepo().loadDefaultPackage();
        AssetItem rule = pack.addAsset("packageInstanceWrongNodeType", "");
        try {
            new PackageItem(this.getRepo(), rule.getNode());
            Assert.fail((String)"Can't create a package from a rule node.");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testLoadRulePackageItemByUUID() throws Exception {
        PackageItem rulePackageItem = this.getRepo().createPackage("testLoadRuleRuleItemByUUID", "desc");
        String uuid = null;
        uuid = rulePackageItem.getNode().getUUID();
        rulePackageItem = this.getRepo().loadPackageByUUID(uuid);
        Assert.assertNotNull((Object)rulePackageItem);
        Assert.assertEquals((Object)"testLoadRuleRuleItemByUUID", (Object)rulePackageItem.getName());
        try {
            rulePackageItem = this.getRepo().loadPackageByUUID("01010101-0101-0101-0101-010101010101");
            Assert.fail((String)"Exception not thrown loading rule package that was not created.");
        }
        catch (RulesRepositoryException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testAddAssetTrailingWhitespace() {
        PackageItem pkg = this.getRepo().createPackage("testAddAssetTrailingWhitespace", "desc");
        pkg.addAsset("wee ", "");
        Assert.assertNotNull((Object)pkg.loadAsset("wee"));
    }

    @Test
    public void testAddRuleRuleItem() {
        PackageItem rulePackageItem1 = this.getRepo().createPackage("testAddRuleRuleItem", "desc");
        AssetItem ruleItem1 = rulePackageItem1.addAsset("testAddRuleRuleItem", "test description");
        ruleItem1.updateContent("test content");
        ruleItem1.checkin("updated the rule content");
        Iterator rulesIt = rulePackageItem1.getAssets();
        Assert.assertNotNull((Object)rulesIt);
        AssetItem first = (AssetItem)rulesIt.next();
        Assert.assertFalse((boolean)rulesIt.hasNext());
        Assert.assertEquals((Object)"testAddRuleRuleItem", (Object)first.getName());
        ruleItem1.updateContent("new lhs");
        ruleItem1.checkin("updated again");
        rulesIt = rulePackageItem1.getAssets();
        Assert.assertNotNull((Object)rulesIt);
        List rules = this.iteratorToList(rulesIt);
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertEquals((Object)"testAddRuleRuleItem", (Object)((AssetItem)rules.get(0)).getName());
        Assert.assertEquals((Object)"new lhs", (Object)((AssetItem)rules.get(0)).getContent());
        AssetItem ruleItem2 = rulePackageItem1.addAsset("testAddRuleRuleItem2", "test content");
        rules = this.iteratorToList(rulePackageItem1.getAssets());
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)2L, (long)rules.size());
    }

    @Test
    public void testAddRuleItemFromGlobalArea() {
        AssetItem ruleItem1 = this.loadGlobalArea().addAsset("testAddRuleItemFromGlobalAreaRuleItem", "test description");
        ruleItem1.updateContent("test content");
        ruleItem1.checkin("updated the rule content");
        PackageItem rulePackageItem2 = this.getRepo().createPackage("testAddRuleItemFromGlobalArea1", "desc");
        AssetItem linkedRuleItem1 = rulePackageItem2.addAssetImportedFromGlobalArea(ruleItem1.getName());
        linkedRuleItem1.updateContent("test content for linked");
        linkedRuleItem1.checkin("updated the rule content for linked");
        ruleItem1.updateContent("new lhs");
        ruleItem1.checkin("updated again");
        Iterator rulesIt2 = rulePackageItem2.getAssets();
        List rules2 = this.iteratorToList(rulesIt2);
        Assert.assertEquals((long)1L, (long)rules2.size());
        AssetItem ai = (AssetItem)rules2.get(0);
        Assert.assertTrue((boolean)ai.getName().equals("testAddRuleItemFromGlobalAreaRuleItem"));
        Assert.assertEquals((Object)"new lhs", (Object)ai.getContent());
        Assert.assertEquals((Object)"test description", (Object)ai.getDescription());
        Assert.assertEquals((Object)"updated again", (Object)ai.getCheckinComment());
    }

    private List iteratorToList(Iterator it) {
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Test
    public void testGetRules() {
        PackageItem rulePackageItem1 = this.getRepo().createPackage("testGetRules", "desc");
        Assert.assertFalse((boolean)rulePackageItem1.containsAsset("goober"));
        AssetItem ruleItem1 = rulePackageItem1.addAsset("testGetRules", "desc");
        ruleItem1.updateContent("test lhs content");
        Assert.assertTrue((boolean)rulePackageItem1.containsAsset("testGetRules"));
        Assert.assertFalse((boolean)rulePackageItem1.containsAsset("XXXXYYYYZZZZ"));
        List rules = this.iteratorToList(rulePackageItem1.getAssets());
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertEquals((Object)"testGetRules", (Object)((AssetItem)rules.get(0)).getName());
        AssetItem ruleItem2 = rulePackageItem1.addAsset("testGetRules2", "desc");
        ruleItem2.updateContent("test lhs content");
        rules = this.iteratorToList(rulePackageItem1.getAssets());
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)2L, (long)rules.size());
        AssetItem loaded = rulePackageItem1.loadAsset("testGetRules");
        Assert.assertNotNull((Object)loaded);
        Assert.assertEquals((Object)"testGetRules", (Object)loaded.getName());
        Assert.assertEquals((Object)"desc", (Object)loaded.getDescription());
    }

    @Test
    public void testToString() {
        PackageItem rulePackageItem1 = this.getRepo().createPackage("testToStringPackage", "desc");
        AssetItem ruleItem1 = rulePackageItem1.addAsset("testToStringPackage", "test lhs content");
        ruleItem1.updateContent("test lhs content");
        Assert.assertNotNull((Object)rulePackageItem1.toString());
    }

    @Test
    public void testRemoveRule() {
        PackageItem rulePackageItem1 = this.getRepo().createPackage("testRemoveRule", "desc");
        AssetItem ruleItem1 = rulePackageItem1.addAsset("testRemoveRule", "test lhs content");
        ruleItem1.updateContent("test lhs content");
        Iterator rulesIt = rulePackageItem1.getAssets();
        AssetItem next = (AssetItem)rulesIt.next();
        Assert.assertFalse((boolean)rulesIt.hasNext());
        Assert.assertEquals((Object)"testRemoveRule", (Object)next.getName());
        ruleItem1.updateContent("new lhs");
        List rules = this.iteratorToList(rulePackageItem1.getAssets());
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertEquals((Object)"testRemoveRule", (Object)((AssetItem)rules.get(0)).getName());
        Assert.assertEquals((Object)"new lhs", (Object)((AssetItem)rules.get(0)).getContent());
        AssetItem ruleItem2 = rulePackageItem1.addAsset("testRemoveRule2", "test lhs content");
        rulePackageItem1.loadAsset(ruleItem1.getName()).remove();
        rulePackageItem1.rulesRepository.save();
        rules = this.iteratorToList(rulePackageItem1.getAssets());
        Assert.assertEquals((long)1L, (long)rules.size());
        Assert.assertEquals((Object)"testRemoveRule2", (Object)((AssetItem)rules.get(0)).getName());
        rulePackageItem1.loadAsset(ruleItem2.getName()).remove();
        rules = this.iteratorToList(rulePackageItem1.getAssets());
        Assert.assertNotNull((Object)rules);
        Assert.assertEquals((long)0L, (long)rules.size());
    }

    @Test
    public void testSearchByFormat() throws Exception {
        PackageItem pkg = this.getRepo().createPackage("searchByFormat", "");
        this.getRepo().save();
        AssetItem item = pkg.addAsset("searchByFormatAsset1", "");
        item.updateFormat("xyz");
        item.checkin("la");
        item = pkg.addAsset("searchByFormatAsset2", "wee");
        item.updateFormat("xyz");
        item.checkin("la");
        item = pkg.addAsset("searchByFormatAsset3", "wee");
        item.updateFormat("ABC");
        item.checkin("la");
        Thread.sleep(150L);
        AssetItemIterator it = pkg.queryAssets("drools:format='xyz'");
        List list = this.iteratorToList((Iterator)it);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof AssetItem));
        Assert.assertTrue((boolean)(list.get(1) instanceof AssetItem));
        AssetItemIterator it2 = pkg.listAssetsByFormat(new String[]{"xyz"});
        List list2 = this.iteratorToList((Iterator)it2);
        Assert.assertEquals((long)2L, (long)list2.size());
        Assert.assertTrue((boolean)(list2.get(0) instanceof AssetItem));
        Assert.assertTrue((boolean)(list2.get(1) instanceof AssetItem));
        it2 = pkg.listAssetsByFormat(new String[]{"xyz", "ABC"});
        list2 = this.iteratorToList((Iterator)it2);
        Assert.assertEquals((long)3L, (long)list2.size());
        Assert.assertTrue((boolean)(list2.get(0) instanceof AssetItem));
        Assert.assertTrue((boolean)(list2.get(1) instanceof AssetItem));
        Assert.assertTrue((boolean)(list2.get(2) instanceof AssetItem));
    }

    @Test
    public void testSearchSharedAssetByFormat() throws Exception {
        AssetItem item = this.loadGlobalArea().addAsset("testSearchSharedAssetByFormat", "");
        item.updateFormat("testSearchSharedAssetByFormat");
        item.checkin("la");
        AssetItemIterator it = this.loadGlobalArea().queryAssets("drools:format='testSearchSharedAssetByFormat'");
        List list = this.iteratorToList((Iterator)it);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof AssetItem));
        PackageItem pkg2 = this.getRepo().createPackage("testSearchSharedAssetByFormat", "");
        this.getRepo().save();
        AssetItem linkedItem = pkg2.addAssetImportedFromGlobalArea(item.getName());
        Thread.sleep(150L);
        item = this.loadGlobalArea().loadAsset("testSearchSharedAssetByFormat");
        Assert.assertEquals((Object)"testSearchSharedAssetByFormat", (Object)item.getFormat());
        it = this.loadGlobalArea().queryAssets("drools:format='testSearchSharedAssetByFormat'");
        list = this.iteratorToList((Iterator)it);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof AssetItem));
    }

    @Test
    public void testListArchivedAssets() throws Exception {
        PackageItem pkg = this.getRepo().createPackage("org.drools.archivedtest", "");
        this.getRepo().save();
        AssetItem item = pkg.addAsset("archivedItem1", "");
        item.archiveItem(true);
        item.checkin("la");
        item = pkg.addAsset("archivedItem2", "wee");
        item.archiveItem(true);
        item.checkin("la");
        item = pkg.addAsset("archivedItem3", "wee");
        item.archiveItem(true);
        item.checkin("la");
        item = pkg.addAsset("NOTarchivedItem", "wee");
        item.checkin("la");
        Thread.sleep(150L);
        AssetItemIterator it = pkg.listArchivedAssets();
        List list = this.iteratorToList((Iterator)it);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof AssetItem));
        Assert.assertTrue((boolean)(list.get(1) instanceof AssetItem));
        Assert.assertTrue((boolean)(list.get(2) instanceof AssetItem));
        it = pkg.queryAssets("", true);
        list = this.iteratorToList((Iterator)it);
        Assert.assertEquals((long)4L, (long)list.size());
    }

    @Test
    public void testExcludeAssetTypes() throws Exception {
        PackageItem pkg = this.getRepo().createPackage("testExcludeAssetTypes", "");
        this.getRepo().save();
        AssetItem item = pkg.addAsset("a1", "");
        item.updateFormat("drl");
        item.checkin("la");
        item = pkg.addAsset("a2", "wee");
        item.updateFormat("xls");
        item.checkin("la");
        AssetItemIterator it = pkg.listAssetsNotOfFormat(new String[]{"drl"});
        List ls = this.iteratorToList((Iterator)it);
        Assert.assertEquals((long)1L, (long)ls.size());
        AssetItem as = (AssetItem)ls.get(0);
        Assert.assertEquals((Object)"a2", (Object)as.getName());
        it = pkg.listAssetsNotOfFormat(new String[]{"drl", "wang"});
        ls = this.iteratorToList((Iterator)it);
        Assert.assertEquals((long)1L, (long)ls.size());
        as = (AssetItem)ls.get(0);
        Assert.assertEquals((Object)"a2", (Object)as.getName());
        it = pkg.listAssetsNotOfFormat(new String[]{"drl", "xls"});
        ls = this.iteratorToList((Iterator)it);
        Assert.assertEquals((long)0L, (long)ls.size());
    }

    @Test
    public void testSortHistoryByVersionNumber() {
        PackageItem item = new PackageItem();
        ArrayList<MockAssetItem> l = new ArrayList<MockAssetItem>();
        MockAssetItem i1 = new MockAssetItem(42L);
        MockAssetItem i2 = new MockAssetItem(1L);
        l.add(i2);
        l.add(i1);
        Assert.assertEquals((Object)((Object)i2), l.iterator().next());
        item.sortHistoryByVersionNumber(l);
        Assert.assertEquals((Object)((Object)i1), l.iterator().next());
    }

    @Test
    public void testMiscProperties() {
        PackageItem item = this.getRepo().createPackage("testHeader", "ya");
        PackageItemTest.updateHeader("new header", item);
        item.updateExternalURI("boo");
        this.getRepo().save();
        Assert.assertEquals((Object)"new header", (Object)PackageItemTest.getHeader(item));
        item = this.getRepo().loadPackage("testHeader");
        Assert.assertEquals((Object)"new header", (Object)PackageItemTest.getHeader(item));
        Assert.assertEquals((Object)"boo", (Object)item.getExternalURI());
    }

    @Test
    public void testGetFormatAndUpToDate() {
        PackageItem rulePackageItem1 = this.getRepo().createPackage("testGetFormat", "woot");
        Assert.assertNotNull((Object)rulePackageItem1);
        Assert.assertEquals((Object)"package", (Object)rulePackageItem1.getFormat());
        Assert.assertFalse((boolean)rulePackageItem1.isBinaryUpToDate());
        rulePackageItem1.updateBinaryUpToDate(true);
        Assert.assertTrue((boolean)rulePackageItem1.isBinaryUpToDate());
        rulePackageItem1.updateBinaryUpToDate(false);
        Assert.assertFalse((boolean)rulePackageItem1.isBinaryUpToDate());
    }

    @Test
    public void testFormatOtherThanDroolsPackage() {
        PackageItem rulePackageItem1 = this.getRepo().createPackage("testFormatOtherThanDroolsPackage", "woot");
        Assert.assertNotNull((Object)rulePackageItem1);
        Assert.assertEquals((Object)"package", (Object)rulePackageItem1.getFormat());
        rulePackageItem1.updateFormat("soaservice");
        PackageItem item = this.getRepo().loadPackage("testFormatOtherThanDroolsPackage");
        Assert.assertEquals((Object)"soaservice", (Object)item.getFormat());
    }

    public static void updateHeader(String h, PackageItem pkg) {
        pkg.checkout();
        AssetItem as = null;
        as = pkg.containsAsset("drools") ? pkg.loadAsset("drools") : pkg.addAsset("drools", "");
        as.updateContent(h);
    }

    public static String getHeader(PackageItem pkg) {
        if (pkg.containsAsset("drools")) {
            return pkg.loadAsset("drools").getContent();
        }
        return "";
    }

    @Test
    public void testPackageCheckinConfig() {
        PackageItem item = this.getRepo().createPackage("testPackageCheckinConfig", "description");
        AssetItem rule = item.addAsset("testPackageCheckinConfig", "w");
        rule.checkin("goo");
        Assert.assertEquals((long)1L, (long)this.iteratorToList(item.getAssets()).size());
        PackageItemTest.updateHeader("la", item);
        item.checkin("woot");
        PackageItemTest.updateHeader("we", item);
        item.checkin("gah");
        AssetItem rule_ = this.getRepo().loadAssetByUUID(rule.getUUID());
        Assert.assertEquals((long)rule.getVersionNumber(), (long)rule_.getVersionNumber());
        item = this.getRepo().loadPackage("testPackageCheckinConfig");
        long v = item.getVersionNumber();
        item.updateCheckinComment("x");
        this.getRepo().save();
        Assert.assertEquals((long)v, (long)item.getVersionNumber());
    }

    @Test
    public void testPackageWorkspaceProperty() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem item = repo.createPackage("testPackageWorkspaceProperty1", "lalalala");
        this.getRepo().save();
        String[] workspaces = repo.loadPackage(item.getName()).getWorkspaces();
        item.removeWorkspace("workspace1");
        workspaces = item.getWorkspaces();
        Assert.assertEquals((long)workspaces.length, (long)0L);
        item.addWorkspace("workspace1");
        item.addWorkspace("workspace2");
        item.addWorkspace("workspace1");
        item.addWorkspace("workspace2");
        workspaces = item.getWorkspaces();
        Assert.assertEquals((long)workspaces.length, (long)2L);
        item.removeWorkspace("workspace1");
        item.removeWorkspace("workspace3");
        workspaces = item.getWorkspaces();
        Assert.assertEquals((long)workspaces.length, (long)1L);
        Assert.assertTrue((boolean)workspaces[0].equals("workspace2"));
    }

    @Test
    public void testDependencies() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem item = repo.createPackage("testDependencies", "lalalala");
        this.getRepo().save();
        String[] dependencies = item.getDependencies();
        Assert.assertEquals((long)dependencies.length, (long)0L);
        AssetItem rule = item.addAsset("testDependenciesAsset1", "w");
        rule.checkout();
        rule.checkin("version 1");
        rule.checkout();
        rule.checkin("version 2");
        rule.checkout();
        rule.checkin("version 3");
        dependencies = item.getDependencies();
        Assert.assertEquals((long)dependencies.length, (long)1L);
        Assert.assertEquals((Object)"testDependenciesAsset1?version=LATEST", (Object)dependencies[0]);
        item.updateDependency("testDependenciesAsset1?version=LATEST");
        item.checkin("Update dependency");
        dependencies = item.getDependencies();
        Assert.assertEquals((Object)"testDependenciesAsset1?version=LATEST", (Object)dependencies[0]);
        item.updateDependency("testDependenciesAsset1?version=2");
        item.checkin("Update dependency");
        dependencies = item.getDependencies();
        Assert.assertEquals((Object)"testDependenciesAsset1?version=2", (Object)dependencies[0]);
    }

    @Test
    public void testDependenciesWithHistoricalVersion() throws Exception {
        RulesRepository repo = this.getRepo();
        PackageItem item = repo.createPackage("testDependenciesWithHistoricalVersion", "lalalala");
        this.getRepo().save();
        String[] dependencies = item.getDependencies();
        Assert.assertEquals((long)dependencies.length, (long)0L);
        AssetItem rule = item.addAsset("testDependenciesWithHistoricalVersionAsset1", "w");
        dependencies = item.getDependencies();
        Assert.assertEquals((long)dependencies.length, (long)1L);
        Assert.assertEquals((Object)"testDependenciesWithHistoricalVersionAsset1?version=LATEST", (Object)dependencies[0]);
        item.checkout();
        item.checkin("v1");
        PackageItem historicalPackage = this.getRepo().loadPackage("testDependenciesWithHistoricalVersion", 2L);
        dependencies = historicalPackage.getDependencies();
        Assert.assertEquals((long)1L, (long)dependencies.length);
        Assert.assertEquals((Object)"testDependenciesWithHistoricalVersionAsset1?version=1", (Object)dependencies[0]);
        item.checkout();
        item.checkin("v2");
        historicalPackage = this.getRepo().loadPackage("testDependenciesWithHistoricalVersion", 3L);
        dependencies = historicalPackage.getDependencies();
        Assert.assertEquals((long)1L, (long)dependencies.length);
        Assert.assertEquals((Object)"testDependenciesWithHistoricalVersionAsset1?version=1", (Object)dependencies[0]);
    }

    @Test
    public void testListAssetsByFormatForHistoricalPackage() throws Exception {
        PackageItem pkg = this.getRepo().createPackage("testListAssetsByFormatForHistoricalPackage", "");
        this.getRepo().save();
        AssetItem item = pkg.addAsset("testVersionedAssetItemIteratorAsset1", "");
        item.updateFormat("xyz");
        item.checkin("la");
        item = pkg.addAsset("testVersionedAssetItemIteratorAsset2", "wee");
        item.updateFormat("xyz");
        item.checkin("la");
        item = pkg.addAsset("testVersionedAssetItemIteratorAsset3", "wee");
        item.updateFormat("ABC");
        item.checkin("version 1");
        item.checkout();
        item.checkin("version 2");
        item.checkout();
        item.checkin("version 3");
        item.checkout();
        item.checkin("version 4");
        pkg.updateDependency("testVersionedAssetItemIteratorAsset3?version=2");
        pkg.checkin("Update dependency");
        pkg.checkout();
        pkg.checkin("version 3");
        item.checkout();
        item.checkin("version 5");
        pkg = this.getRepo().loadPackage("testListAssetsByFormatForHistoricalPackage");
        String[] dependencies = pkg.getDependencies();
        Assert.assertEquals((long)dependencies.length, (long)3L);
        AssetItemIterator it = pkg.listAssetsByFormat(new String[]{"xyz", "ABC"});
        List list = this.iteratorToList((Iterator)it);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof AssetItem));
        Assert.assertTrue((boolean)(list.get(1) instanceof AssetItem));
        Assert.assertTrue((boolean)(list.get(2) instanceof AssetItem));
        it = pkg.listAssetsByFormat(new String[]{"ABC"});
        Assert.assertTrue((boolean)(it instanceof VersionedAssetItemIterator));
        list = this.iteratorToList((Iterator)it);
        Assert.assertEquals((long)1L, (long)list.size());
        AssetItem ai = (AssetItem)list.get(0);
        Assert.assertEquals((long)5L, (long)ai.getVersionNumber());
        Assert.assertEquals((Object)"version 5", (Object)ai.getCheckinComment());
        it = pkg.listAssetsByFormat(new String[]{"ABC"});
        Assert.assertTrue((boolean)(it instanceof VersionedAssetItemIterator));
        ((VersionedAssetItemIterator)it).setReturnAssetsWithVersionsSpecifiedByDependencies(true);
        list = this.iteratorToList((Iterator)it);
        Assert.assertEquals((long)1L, (long)list.size());
        ai = (AssetItem)list.get(0);
        Assert.assertEquals((long)2L, (long)ai.getVersionNumber());
        Assert.assertEquals((Object)"version 2", (Object)ai.getCheckinComment());
        PackageItem historicalPackage = this.getRepo().loadPackage("testListAssetsByFormatForHistoricalPackage", 2L);
        it = historicalPackage.listAssetsByFormat(new String[]{"xyz", "ABC"});
        list = this.iteratorToList((Iterator)it);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof AssetItem));
        Assert.assertTrue((boolean)(list.get(1) instanceof AssetItem));
        Assert.assertTrue((boolean)(list.get(2) instanceof AssetItem));
        it = historicalPackage.listAssetsByFormat(new String[]{"ABC"});
        Assert.assertTrue((boolean)(it instanceof VersionedAssetItemIterator));
        list = this.iteratorToList((Iterator)it);
        Assert.assertEquals((long)1L, (long)list.size());
        ai = (AssetItem)list.get(0);
        Assert.assertEquals((long)4L, (long)ai.getVersionNumber());
        Assert.assertEquals((Object)"version 4", (Object)ai.getCheckinComment());
        it = historicalPackage.listAssetsByFormat(new String[]{"ABC"});
        Assert.assertTrue((boolean)(it instanceof VersionedAssetItemIterator));
        ((VersionedAssetItemIterator)it).setReturnAssetsWithVersionsSpecifiedByDependencies(true);
        list = this.iteratorToList((Iterator)it);
        Assert.assertEquals((long)1L, (long)list.size());
        ai = (AssetItem)list.get(0);
        Assert.assertEquals((long)2L, (long)ai.getVersionNumber());
        Assert.assertEquals((Object)"version 2", (Object)ai.getCheckinComment());
    }

    static class MockAssetItem
    extends AssetItem {
        private long version;

        MockAssetItem(long ver) {
            this.version = ver;
        }

        public long getVersionNumber() {
            return this.version;
        }

        public boolean equals(Object in) {
            return in == this;
        }

        public String toString() {
            return Long.toString(this.version);
        }
    }
}

