/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.migration;

import javax.jcr.Session;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RepositoryTestCase;
import org.drools.repository.RulesRepository;
import org.drools.repository.migration.MigrateDroolsPackage;
import org.junit.Assert;
import org.junit.Test;

public class MigrateDroolsPackageTest
extends RepositoryTestCase {
    @Test
    public void testMigrate() throws Exception {
        RulesRepository repo = this.getRepo();
        Session sess = repo.getSession();
        sess.getRootNode().getNode("drools:repository").getNode("drools.package.migrated").remove();
        sess.save();
        MigrateDroolsPackage mig = new MigrateDroolsPackage();
        ModuleItem pkg = repo.createModule("testMigratePackage", "");
        pkg.updateStringProperty("some header", "drools:header");
        sess.save();
        repo.createModuleSnapshot("testMigratePackage", "SNAP1");
        repo.createModuleSnapshot("testMigratePackage", "SNAP2");
        Assert.assertTrue((boolean)mig.needsMigration(repo));
        mig.migrate(repo);
        Assert.assertFalse((boolean)repo.getSession().hasPendingChanges());
        Assert.assertFalse((boolean)mig.needsMigration(repo));
        pkg = repo.loadModule("testMigratePackage");
        Assert.assertTrue((boolean)pkg.containsAsset("drools"));
        AssetItem as = pkg.loadAsset("drools");
        Assert.assertEquals((Object)"some header", (Object)as.getContent());
        pkg = repo.loadModuleSnapshot("testMigratePackage", "SNAP1");
        Assert.assertTrue((boolean)pkg.containsAsset("drools"));
        as = pkg.loadAsset("drools");
        Assert.assertEquals((Object)"some header", (Object)as.getContent());
        pkg = repo.loadModuleSnapshot("testMigratePackage", "SNAP2");
        Assert.assertTrue((boolean)pkg.containsAsset("drools"));
        as = pkg.loadAsset("drools");
        Assert.assertEquals((Object)"some header", (Object)as.getContent());
    }
}

