/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.SaveEventListener;
import org.drools.guvnor.client.asseteditor.drools.DSLRuleEditor;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;

public class RuleValidatorWrapper
extends DirtyableComposite
implements SaveEventListener,
EditorWidget {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private Widget editor;

    public RuleValidatorWrapper(Asset asset, RuleViewer viewer, ClientFactory clientFactory, EventBus eventBus) {
        this.editor = new DSLRuleEditor(asset);
        VerticalPanel layout = new VerticalPanel();
        layout.add(this.editor);
        layout.setWidth("100%");
        layout.setHeight("100%");
        this.initWidget((Widget)layout);
    }

    public static void showBuilderErrors(BuilderResult result) {
        if (result == null || result.getLines() == null || result.getLines().size() == 0) {
            FormStylePopup pop = new FormStylePopup();
            pop.setWidth("200px");
            pop.setTitle(constants.ValidationResultsDotDot());
            HorizontalPanel h = new HorizontalPanel();
            h.add((Widget)new SmallLabel(AbstractImagePrototype.create((ImageResource)images.greenTick()).getHTML() + "<i>" + constants.ItemValidatedSuccessfully() + "</i>"));
            pop.addRow((Widget)h);
            pop.show();
        } else {
            FormStylePopup pop = new FormStylePopup(images.packageBuilder(), constants.ValidationResults());
            FlexTable errTable = new FlexTable();
            errTable.setStyleName("build-Results");
            for (int i = 0; i < result.getLines().size(); ++i) {
                int row = i;
                BuilderResultLine res = (BuilderResultLine)result.getLines().get(i);
                errTable.setWidget(row, 0, (Widget)new Image(images.error()));
                if (res.getAssetFormat().equals("package")) {
                    errTable.setText(row, 1, constants.packageConfigurationProblem() + res.getMessage());
                    continue;
                }
                errTable.setText(row, 1, "[" + res.getAssetName() + "] " + res.getMessage());
            }
            ScrollPanel scroll = new ScrollPanel((Widget)errTable);
            scroll.setWidth("100%");
            pop.addRow((Widget)scroll);
            pop.show();
        }
        LoadingPopup.close();
    }

    public void onSave() {
        if (this.editor instanceof SaveEventListener) {
            SaveEventListener el = (SaveEventListener)this.editor;
            el.onSave();
        }
    }

    public void onAfterSave() {
        if (this.editor instanceof SaveEventListener) {
            SaveEventListener el = (SaveEventListener)this.editor;
            el.onAfterSave();
        }
    }
}

