/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.changeset;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.drools.changeset.AbstractXMLResourceDefinitionCreatorWidget;
import org.drools.guvnor.client.asseteditor.drools.changeset.CreatePackageResourceWidget;
import org.drools.guvnor.client.asseteditor.drools.changeset.ResourceElementReadyCommand;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.PackageBuilderWidget;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;

public class CreatePackageResourceWidget
extends AbstractXMLResourceDefinitionCreatorWidget {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private boolean globalArea;
    private ModuleServiceAsync packageService;
    private String packageUUID;
    private static CreatePackageResourceWidgetBinder uiBinder = (CreatePackageResourceWidgetBinder)GWT.create(CreatePackageResourceWidgetBinder.class);
    @UiField
    protected TextBox txtName;
    @UiField
    protected TextBox txtDescription;
    @UiField
    protected Tree packageTree;

    public CreatePackageResourceWidget(String packageUUID, String packageName, ClientFactory clientFactory) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.globalArea = packageName.equals("globalArea");
        this.packageService = clientFactory.getModuleService();
        this.packageUUID = packageUUID;
        this.initializePackageTree();
    }

    private void initializePackageTree() {
        if (this.globalArea) {
            this.packageService.loadGlobalModule((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            this.packageService.listModules((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.packageService.loadModule(this.packageUUID, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.packageTree.setStyleName("category-explorer-Tree");
    }

    private void populatePackageTree(Module packageConfigData, TreeItem rootItem) {
        TreeItem packageItem = new TreeItem(packageConfigData.getName());
        packageItem.addItem(this.createTreeItem("LATEST", PackageBuilderWidget.getDownloadLink((Module)packageConfigData)));
        this.packageService.listSnapshots(packageConfigData.getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        if (rootItem == null) {
            this.packageTree.addItem(packageItem);
        } else {
            rootItem.addItem(packageItem);
        }
    }

    private TreeItem createTreeItem(String label, String link) {
        TreeItem treeItem = new TreeItem((Widget)new RadioButton("pkgResourceGroup", label));
        treeItem.setUserObject((Object)link);
        return treeItem;
    }

    public void getResourceElement(ResourceElementReadyCommand resourceElementReadyCommand) {
        try {
            TreeItem selectedPackageItem = this.packageTree.getSelectedItem();
            if (selectedPackageItem == null || selectedPackageItem.getChildCount() != 0) {
                throw new IllegalStateException(this.constants.NoPackageSeleced());
            }
            String result = "<resource {name} {description} source='{source}' type='{type}' />";
            String nameString = "";
            if (this.txtName.getText().length() != 0) {
                nameString = "name=\"" + this.txtName.getText().trim() + "\"";
            }
            result = result.replace("{name}", nameString);
            String descriptionString = "";
            if (this.txtDescription.getText().length() != 0) {
                descriptionString = "description=\"" + this.txtDescription.getText().trim() + "\"";
            }
            result = result.replace("{description}", descriptionString);
            result = result.replace("{type}", "PKG");
            String source = (String)selectedPackageItem.getUserObject();
            result = result.replace("{source}", source);
            resourceElementReadyCommand.onSuccess(result);
        }
        catch (Throwable t) {
            resourceElementReadyCommand.onFailure(t);
        }
    }

    static /* synthetic */ void access$000(CreatePackageResourceWidget x0, Module x1, TreeItem x2) {
        x0.populatePackageTree(x1, x2);
    }

    static /* synthetic */ TreeItem access$100(CreatePackageResourceWidget x0, String x1, String x2) {
        return x0.createTreeItem(x1, x2);
    }
}

