/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.factmodel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationEditor;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationEditorPopup;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationMetaModel;
import org.drools.guvnor.client.messages.Constants;

public class AnnotationEditor
extends Composite {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static AnnotationEditorBinder uiBinder = (AnnotationEditorBinder)GWT.create(AnnotationEditorBinder.class);
    @UiField
    Label annotationName;
    @UiField
    Label annotationKey;
    @UiField
    Label annotationValue;
    @UiField
    Image editAnnotationIcon;
    @UiField
    Image deleteAnnotationIcon;
    private AnnotationMetaModel annotation;
    private List<AnnotationMetaModel> annotations;
    private Command deleteCommand;

    public AnnotationEditor(AnnotationMetaModel annotation, List<AnnotationMetaModel> annotations) {
        this.annotation = annotation;
        this.annotations = annotations;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.annotationName.setStyleName("guvnor-bold-label");
        this.setControlValues(annotation);
        this.editAnnotationIcon.setTitle(constants.Rename());
        this.deleteAnnotationIcon.setTitle(constants.Delete());
    }

    private void setControlValues(AnnotationMetaModel annotation) {
        String name = annotation.name;
        String key = this.getFirstEntry(annotation.getValues().keySet());
        String value = this.getFirstEntry(annotation.getValues().values());
        this.annotationName.setText("@" + name);
        this.annotationKey.setText(key);
        this.annotationValue.setText(value);
    }

    private String getFirstEntry(Collection<String> values) {
        if (values.isEmpty()) {
            return "";
        }
        return values.iterator().next();
    }

    @UiHandler(value={"editAnnotationIcon"})
    void editAnnotationIconClick(ClickEvent event) {
        AnnotationEditorPopup popup = new AnnotationEditorPopup(this.annotation, this.annotations);
        popup.setOkCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    @UiHandler(value={"deleteAnnotationIcon"})
    void deleteAnnotationIconClick(ClickEvent event) {
        this.deleteCommand.execute();
    }

    public void setDeleteCommand(Command deleteCommand) {
        this.deleteCommand = deleteCommand;
    }

    static /* synthetic */ AnnotationMetaModel access$000(AnnotationEditor x0) {
        return x0.annotation;
    }

    static /* synthetic */ void access$100(AnnotationEditor x0, AnnotationMetaModel x1) {
        x0.setControlValues(x1);
    }
}

