/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.factmodel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.ModelNameHelper;
import org.drools.guvnor.client.asseteditor.drools.factmodel.NoSpaceKeyPressHandler;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.messages.Constants;

public class FactEditorPopup {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static final RegExp VALID_NAME = RegExp.compile((String)"^[a-zA-Z][a-zA-Z\\d_$]*$");
    private final FactMetaModel factModel;
    private final List<FactMetaModel> factModels;
    private final ModelNameHelper modelNameHelper;
    private final ListBox lstSuperTypes = new ListBox();
    private Command okCommand;

    public FactEditorPopup(ModelNameHelper modelNameHelper, List<FactMetaModel> factModels) {
        this(new FactMetaModel(), factModels, modelNameHelper);
    }

    public FactEditorPopup(FactMetaModel factModel, List<FactMetaModel> factModels, ModelNameHelper modelNameHelper) {
        this.factModel = factModel;
        this.factModels = factModels;
        this.modelNameHelper = modelNameHelper;
    }

    public FactMetaModel getFactModel() {
        return this.factModel;
    }

    public void setOkCommand(Command okCommand) {
        this.okCommand = okCommand;
    }

    public void show() {
        FormStylePopup pop = new FormStylePopup();
        pop.setTitle(constants.Name());
        HorizontalPanel changeName = new HorizontalPanel();
        TextBox name = new TextBox();
        name.setText(this.factModel.getName());
        changeName.add((Widget)name);
        int selectedIndex = 0;
        this.lstSuperTypes.addItem(constants.DoesNotExtend());
        for (FactMetaModel fmm : this.factModels) {
            if (fmm.getName().equals(this.factModel.getName())) continue;
            this.lstSuperTypes.addItem(fmm.getName());
            if (this.factModel.getSuperType() == null || !this.factModel.getSuperType().equals(fmm.getName())) continue;
            selectedIndex = this.lstSuperTypes.getItemCount() - 1;
        }
        this.lstSuperTypes.setSelectedIndex(selectedIndex);
        if (this.lstSuperTypes.getItemCount() == 1) {
            this.lstSuperTypes.setEnabled(false);
        }
        this.lstSuperTypes.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button nameButton = new Button(constants.OK());
        nameButton.addKeyPressHandler((KeyPressHandler)new NoSpaceKeyPressHandler());
        nameButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute(constants.Name(), (Widget)changeName);
        pop.addAttribute(constants.TypeExtends(), (Widget)this.lstSuperTypes);
        pop.addRow((Widget)nameButton);
        pop.show();
    }

    private int getSelectedIndex(String superType) {
        if (superType == null) {
            return 0;
        }
        for (int i = 1; i < this.lstSuperTypes.getItemCount(); ++i) {
            if (!superType.equals(this.lstSuperTypes.getItemText(i))) continue;
            return i;
        }
        return 0;
    }

    private boolean createsCircularDependency(String type) {
        HashSet circulars = new HashSet();
        FactMetaModel fmm = this.getFactMetaModel(type);
        return this.addCircular(fmm, circulars);
    }

    private boolean addCircular(FactMetaModel fmm, Set<String> circulars) {
        if (!fmm.hasSuperType()) {
            return false;
        }
        String type = fmm.getName();
        if (circulars.contains(type)) {
            return true;
        }
        circulars.add(type);
        FactMetaModel efmm = this.getFactMetaModel(fmm.getSuperType());
        return this.addCircular(efmm, circulars);
    }

    private FactMetaModel getFactMetaModel(String type) {
        for (FactMetaModel fmm : this.factModels) {
            if (!fmm.getName().equals(type)) continue;
            return fmm;
        }
        return null;
    }

    static /* synthetic */ ListBox access$000(FactEditorPopup x0) {
        return x0.lstSuperTypes;
    }

    static /* synthetic */ FactMetaModel access$100(FactEditorPopup x0) {
        return x0.factModel;
    }

    static /* synthetic */ boolean access$200(FactEditorPopup x0, String x1) {
        return x0.createsCircularDependency(x1);
    }

    static /* synthetic */ Constants access$300() {
        return constants;
    }

    static /* synthetic */ int access$400(FactEditorPopup x0, String x1) {
        return x0.getSelectedIndex(x1);
    }

    static /* synthetic */ RegExp access$500() {
        return VALID_NAME;
    }

    static /* synthetic */ ModelNameHelper access$600(FactEditorPopup x0) {
        return x0.modelNameHelper;
    }

    static /* synthetic */ Command access$700(FactEditorPopup x0) {
        return x0.okCommand;
    }
}

