/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.cells;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.math.BigDecimal;
import org.drools.guvnor.client.decisiontable.cells.AbstractPopupEditCell;

public class PopupNumericEditCell
extends AbstractPopupEditCell<BigDecimal, BigDecimal> {
    private final TextBox textBox = new TextBox();
    private static final RegExp VALID = RegExp.compile((String)"(^[-+]?[0-9]*\\.?[0-9]*([eE][-+]?[0-9]*)?$)");

    public PopupNumericEditCell() {
        this.textBox.addKeyDownHandler((KeyDownHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.textBox.addKeyPressHandler((KeyPressHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.vPanel.add((Widget)this.textBox);
    }

    public void render(Cell.Context context, BigDecimal value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(this.renderer.render((Object)value.toPlainString()));
        }
    }

    protected void commit() {
        String text = this.textBox.getValue();
        BigDecimal number = null;
        if (text.length() > 0) {
            try {
                number = new BigDecimal(text);
            }
            catch (NumberFormatException e) {
                number = new BigDecimal(0);
            }
        }
        this.setValue(this.lastContext, this.lastParent, (Object)number);
        if (this.valueUpdater != null) {
            this.valueUpdater.update((Object)number);
        }
        this.panel.hide();
    }

    protected void startEditing(Cell.Context context, Element parent, BigDecimal value) {
        this.textBox.setValue((Object)(value == null ? "" : value.toPlainString()));
        this.panel.setPopupPositionAndShow((PopupPanel.PositionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ TextBox access$000(PopupNumericEditCell x0) {
        return x0.textBox;
    }

    static /* synthetic */ RegExp access$100() {
        return VALID;
    }
}

