/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.event.shared.EventBus;
import java.math.BigDecimal;
import org.drools.guvnor.client.decisiontable.cells.AnalysisCell;
import org.drools.guvnor.client.decisiontable.cells.PopupBoundPatternDropDownEditCell;
import org.drools.guvnor.client.decisiontable.cells.PopupDropDownEditCell;
import org.drools.guvnor.client.decisiontable.cells.RowNumberCell;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractCellFactory;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.DecoratedGridCellValueAdaptor;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionRetractFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.Analysis;
import org.drools.ide.common.client.modeldriven.dt52.AnalysisCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.BRLActionVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLConditionVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLRuleModel;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryBRLActionColumn;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;
import org.drools.ide.common.client.modeldriven.dt52.RowNumberCol52;

public class DecisionTableCellFactory
extends AbstractCellFactory<BaseColumn> {
    private static String[] DIALECTS = new String[]{"java", "mvel"};
    private GuidedDecisionTable52 model;

    public DecisionTableCellFactory(SuggestionCompletionEngine sce, EventBus eventBus) {
        super(sce, eventBus);
    }

    public void setModel(GuidedDecisionTable52 model) {
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
    }

    public DecoratedGridCellValueAdaptor<? extends Comparable<?>> getCell(BaseColumn column) {
        DecoratedGridCellValueAdaptor cell = this.makeTextCell();
        if (column instanceof RowNumberCol52) {
            cell = this.makeRowNumberCell();
        } else if (column instanceof AttributeCol52) {
            AttributeCol52 attrCol = (AttributeCol52)column;
            String attrName = attrCol.getAttribute();
            if (attrName.equals("salience")) {
                cell = attrCol.isUseRowNumber() ? this.makeRowNumberCell() : this.makeNumericCell();
            } else if (attrName.equals("enabled")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("no-loop")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("duration")) {
                cell = this.makeNumericCell();
            } else if (attrName.equals("auto-focus")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("lock-on-active")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("date-effective")) {
                cell = this.makeDateCell();
            } else if (attrName.equals("date-expires")) {
                cell = this.makeDateCell();
            } else if (attrName.equals("dialect")) {
                cell = this.makeDialectCell();
            } else if (attrName.equals("negate")) {
                cell = this.makeBooleanCell();
            }
        } else if (column instanceof BRLConditionVariableColumn) {
            cell = this.derieveCellFromCondition((ConditionCol52)((BRLConditionVariableColumn)column));
        } else if (column instanceof ConditionCol52) {
            cell = this.derieveCellFromCondition((ConditionCol52)column);
        } else if (column instanceof ActionWorkItemSetFieldCol52) {
            cell = this.makeBooleanCell();
        } else if (column instanceof ActionWorkItemInsertFactCol52) {
            cell = this.makeBooleanCell();
        } else if (column instanceof ActionSetFieldCol52) {
            cell = this.derieveCellFromAction((ActionCol52)((ActionSetFieldCol52)column));
        } else if (column instanceof ActionInsertFactCol52) {
            cell = this.derieveCellFromAction((ActionCol52)((ActionInsertFactCol52)column));
        } else if (column instanceof ActionRetractFactCol52) {
            cell = this.derieveCellFromAction((ActionRetractFactCol52)column);
        } else if (column instanceof ActionWorkItemCol52) {
            cell = this.makeBooleanCell();
        } else if (column instanceof LimitedEntryBRLActionColumn) {
            cell = this.derieveCellFromAction((ActionCol52)((LimitedEntryBRLActionColumn)column));
        } else if (column instanceof BRLActionVariableColumn) {
            cell = this.derieveCellFromAction((ActionCol52)((BRLActionVariableColumn)column));
        } else if (column instanceof AnalysisCol52) {
            cell = this.makeRowAnalysisCell();
        }
        return cell;
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromCondition(ConditionCol52 col) {
        if (col instanceof LimitedEntryCol) {
            return this.makeBooleanCell();
        }
        if (col.getOperator() != null && (col.getOperator().equals("== null") || col.getOperator().equals("!= null"))) {
            return this.makeBooleanCell();
        }
        return this.derieveCellFromModel((DTColumnConfig52)col);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromAction(ActionCol52 col) {
        if (col instanceof LimitedEntryCol) {
            return this.makeBooleanCell();
        }
        return this.derieveCellFromModel((DTColumnConfig52)col);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromAction(ActionRetractFactCol52 col) {
        if (col instanceof LimitedEntryCol) {
            return this.makeBooleanCell();
        }
        PopupBoundPatternDropDownEditCell pudd = new PopupBoundPatternDropDownEditCell(this.eventBus);
        BRLRuleModel rm = new BRLRuleModel(this.model);
        pudd.setFactBindings(rm.getLHSBoundFacts());
        return new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveCellFromModel(DTColumnConfig52 col) {
        DecoratedGridCellValueAdaptor cell = this.makeTextCell();
        String type = this.model.getType((BaseColumn)col, this.sce);
        String[] vals = this.model.getValueList((BaseColumn)col, this.sce);
        if (vals.length == 0) {
            if (type == null) {
                return cell;
            }
            if (type.equals("Numeric")) {
                cell = this.makeNumericCell();
            } else if (type.equals("Boolean")) {
                cell = this.makeBooleanCell();
            } else if (type.equals("Date")) {
                cell = this.makeDateCell();
            }
        } else {
            PopupDropDownEditCell pudd = new PopupDropDownEditCell();
            pudd.setItems(vals);
            cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
        }
        return cell;
    }

    private DecoratedGridCellValueAdaptor<String> makeDialectCell() {
        PopupDropDownEditCell pudd = new PopupDropDownEditCell();
        pudd.setItems(DIALECTS);
        return new DecoratedGridCellValueAdaptor((AbstractCell)pudd, this.eventBus);
    }

    private DecoratedGridCellValueAdaptor<BigDecimal> makeRowNumberCell() {
        return new DecoratedGridCellValueAdaptor((AbstractCell)new RowNumberCell(), this.eventBus);
    }

    private DecoratedGridCellValueAdaptor<Analysis> makeRowAnalysisCell() {
        return new DecoratedGridCellValueAdaptor((AbstractCell)new AnalysisCell(), this.eventBus);
    }
}

