/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellValueFactory;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractCellValueFactory;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.DynamicDataRow;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.Analysis;
import org.drools.ide.common.client.modeldriven.dt52.AnalysisCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;
import org.drools.ide.common.client.modeldriven.dt52.RowNumberCol52;

public class DecisionTableCellValueFactory
extends AbstractCellValueFactory<BaseColumn, DTCellValue52> {
    private GuidedDecisionTable52 model;

    public DecisionTableCellValueFactory(SuggestionCompletionEngine sce) {
        super(sce);
    }

    public void setModel(GuidedDecisionTable52 model) {
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
    }

    public List<DTCellValue52> makeRowData() {
        ArrayList<DTCellValue52> data = new ArrayList<DTCellValue52>();
        List columns = this.model.getExpandedColumns();
        for (int iCol = 0; iCol < columns.size() - 1; ++iCol) {
            BaseColumn column = (BaseColumn)columns.get(iCol);
            DTCellValue52 cell = this.makeModelCellValue(column);
            data.add(cell);
        }
        return data;
    }

    public DynamicDataRow makeUIRowData() {
        DynamicDataRow data = new DynamicDataRow();
        List columns = this.model.getExpandedColumns();
        for (BaseColumn column : columns) {
            DTCellValue52 dcv = this.makeModelCellValue(column);
            DTDataTypes52 dataType = this.getDataType(column);
            this.assertDTCellValue(dataType, dcv);
            CellValue cell = this.convertModelCellValue(column, dcv);
            data.add(cell);
        }
        return data;
    }

    public List<DTCellValue52> makeColumnData(BaseColumn column) {
        ArrayList<DTCellValue52> data = new ArrayList<DTCellValue52>();
        for (int iRow = 0; iRow < this.model.getData().size(); ++iRow) {
            DTCellValue52 cell = this.makeModelCellValue(column);
            data.add(cell);
        }
        return data;
    }

    public List<CellValue<? extends Comparable<?>>> convertColumnData(BaseColumn column, List<DTCellValue52> columnData) {
        ArrayList data = new ArrayList();
        for (int iRow = 0; iRow < this.model.getData().size(); ++iRow) {
            DTCellValue52 dcv = columnData.get(iRow);
            CellValue cell = this.convertModelCellValue(column, dcv);
            data.add(cell);
        }
        return data;
    }

    public DTCellValue52 makeModelCellValue(BaseColumn column) {
        DTDataTypes52 dataType = this.getDataType(column);
        DTCellValue52 dcv = null;
        dcv = column instanceof LimitedEntryCol ? new DTCellValue52(Boolean.FALSE) : new DTCellValue52(column.getDefaultValue());
        this.assertDTCellValue(dataType, dcv);
        return dcv;
    }

    public CellValue<? extends Comparable<?>> convertModelCellValue(BaseColumn column, DTCellValue52 dcv) {
        if (column instanceof AnalysisCol52) {
            return this.makeNewAnalysisCellValue();
        }
        DTDataTypes52 dataType = this.getDataType(column);
        this.assertDTCellValue(dataType, dcv);
        CellValue cell = null;
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[dataType.ordinal()]) {
            case 1: {
                cell = this.makeNewBooleanCellValue(dcv.getBooleanValue());
                break;
            }
            case 2: {
                cell = this.makeNewDateCellValue(dcv.getDateValue());
                break;
            }
            case 3: {
                AttributeCol52 at;
                if (column instanceof RowNumberCol52) {
                    cell = this.makeNewRowNumberCellValue(dcv.getNumericValue());
                    break;
                }
                cell = this.makeNewNumericCellValue(dcv.getNumericValue());
                if (!(column instanceof AttributeCol52) || !(at = (AttributeCol52)column).getAttribute().equals("salience") || !at.isUseRowNumber()) break;
                cell = this.makeNewRowNumberCellValue(dcv.getNumericValue());
                break;
            }
            default: {
                AttributeCol52 ac;
                cell = this.makeNewStringCellValue((Object)dcv.getStringValue());
                if (!(column instanceof AttributeCol52) || !(ac = (AttributeCol52)column).getAttribute().equals("dialect")) break;
                cell = this.makeNewDialectCellValue(dcv.getStringValue());
            }
        }
        if (dcv.isOtherwise()) {
            cell.addState(CellValue.CellState.OTHERWISE);
        }
        return cell;
    }

    protected DTDataTypes52 getDataType(BaseColumn column) {
        ConditionCol52 cc;
        if (column instanceof LimitedEntryCol) {
            return DTDataTypes52.BOOLEAN;
        }
        if (column instanceof ActionWorkItemCol52) {
            return DTDataTypes52.BOOLEAN;
        }
        if (column instanceof ActionWorkItemSetFieldCol52 || column instanceof ActionWorkItemInsertFactCol52) {
            return DTDataTypes52.BOOLEAN;
        }
        if (column instanceof ConditionCol52 && (cc = (ConditionCol52)column).getOperator() != null && (cc.getOperator().equals("== null") || cc.getOperator().equals("!= null"))) {
            return DTDataTypes52.BOOLEAN;
        }
        return this.model.getTypeSafeType(column, this.sce);
    }

    private void assertDTCellValue(DTDataTypes52 dataType, DTCellValue52 dcv) {
        if (dataType.equals((Object)dcv.getDataType())) {
            return;
        }
        String text = dcv.getStringValue();
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[dataType.ordinal()]) {
            case 1: {
                dcv.setBooleanValue(text == null ? null : Boolean.valueOf(text));
                break;
            }
            case 2: {
                Date d = null;
                try {
                    if (text != null) {
                        if (DATE_CONVERTOR == null) {
                            throw new IllegalArgumentException("DATE_CONVERTOR has not been initialised.");
                        }
                        d = DATE_CONVERTOR.parse(text);
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                dcv.setDateValue(d);
                break;
            }
            case 3: {
                BigDecimal bd = null;
                try {
                    if (text != null) {
                        bd = new BigDecimal(text);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                dcv.setNumericValue(bd);
            }
        }
    }

    public CellValue<BigDecimal> makeNewRowNumberCellValue(BigDecimal initialValue) {
        CellValue cv = this.makeNewNumericCellValue();
        if (initialValue != null) {
            cv.setValue((Object)initialValue);
        }
        return cv;
    }

    public CellValue<Analysis> makeNewAnalysisCellValue() {
        Analysis analysis = new Analysis();
        return new CellValue((Comparable)analysis);
    }

    public DTCellValue52 convertToModelCell(BaseColumn column, CellValue<?> cell) {
        DTDataTypes52 dt = this.getDataType(column);
        DTCellValue52 dtCell = null;
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[dt.ordinal()]) {
            case 1: {
                dtCell = new DTCellValue52((Boolean)cell.getValue());
                break;
            }
            case 2: {
                dtCell = new DTCellValue52((Date)cell.getValue());
                break;
            }
            case 3: {
                dtCell = new DTCellValue52((BigDecimal)cell.getValue());
                break;
            }
            default: {
                dtCell = new DTCellValue52((String)((Object)cell.getValue()));
            }
        }
        dtCell.setOtherwise(cell.isOtherwise());
        return dtCell;
    }
}

