/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.RootPanel;
import java.util.List;

public class WidthCalculator<V> {
    private static Element div = DOM.createDiv();
    private Cell<V> cell;
    private Integer minWidth;

    public WidthCalculator(Cell<V> cell) {
        DOM.appendChild((Element)RootPanel.getBodyElement(), (Element)div);
        div.getStyle().setPosition(Style.Position.ABSOLUTE);
        div.getStyle().setVisibility(Style.Visibility.HIDDEN);
        div.getStyle().setProperty("width", "auto");
        div.getStyle().setProperty("height", "auto");
        div.getStyle().setPadding(1.0, Style.Unit.PX);
        div.getStyle().setMargin(2.0, Style.Unit.PX);
        this.cell = cell;
    }

    public void setMinimumWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public int getMaximumElementWidth(List<? extends V> values) {
        int maximumWidth = 0;
        for (V value : values) {
            int w = this.getElementWidth(value);
            if (w <= maximumWidth) continue;
            maximumWidth = w;
        }
        if (this.minWidth == null) {
            return maximumWidth;
        }
        return this.minWidth > maximumWidth ? this.minWidth : maximumWidth;
    }

    private int getElementWidth(V value) {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        this.cell.render(null, value, sb);
        div.setInnerHTML(sb.toSafeHtml().asString());
        int width = div.getClientWidth();
        if (this.minWidth == null) {
            return div.getClientWidth();
        }
        return this.minWidth > width ? this.minWidth : width;
    }
}

