/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.changeset;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.SaveEventListener;
import org.drools.guvnor.client.asseteditor.drools.changeset.ChangeSetEditor;
import org.drools.guvnor.client.asseteditor.drools.changeset.NewResourcePopup;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.client.widgets.RESTUtil;
import org.drools.guvnor.client.widgets.drools.explorer.AssetResourceExplorerWidget;
import org.drools.guvnor.client.widgets.drools.explorer.ExplorerRenderMode;
import org.drools.guvnor.client.widgets.drools.explorer.PackageDisplayMode;
import org.drools.guvnor.client.widgets.drools.explorer.PackageResourceExplorerWidget;

public class ChangeSetEditor
extends DirtyableComposite
implements EditorWidget,
SaveEventListener {
    private static final String resourceXMLElementTemplate = "<resource {name} {description} source='{source}' type='{type}' />";
    private static ChangeSetEditorBinder uiBinder = (ChangeSetEditorBinder)GWT.create(ChangeSetEditorBinder.class);
    @UiField
    protected TextArea editorArea;
    @UiField
    protected Button btnAssetResource;
    @UiField
    protected Button btnPackageResource;
    @UiField
    protected HorizontalPanel pnlURL;
    private ClientFactory clientFactory;
    private final RuleContentText data;
    private final String assetPackageName;
    private final String assetPackageUUID;
    private final String assetName;
    private final int visibleLines;

    public ChangeSetEditor(Asset a, RuleViewer v, ClientFactory clientFactory, EventBus eventBus) {
        this(a, clientFactory);
    }

    public ChangeSetEditor(Asset a, ClientFactory clientFactory) {
        this(a, clientFactory, -1);
    }

    public ChangeSetEditor(Asset asset, ClientFactory clientFactory, int visibleLines) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.clientFactory = clientFactory;
        this.assetPackageUUID = asset.getMetaData().getModuleUUID();
        this.assetPackageName = asset.getMetaData().getModuleName();
        this.assetName = asset.getName();
        this.data = (RuleContentText)asset.getContent();
        if (this.data.content == null) {
            this.data.content = "Empty!";
        }
        this.visibleLines = visibleLines;
        this.customizeUIElements();
    }

    private void customizeUIElements() {
        this.pnlURL.add(this.createChangeSetLink());
        this.editorArea.setStyleName("default-text-Area");
        this.editorArea.setVisibleLines(this.visibleLines == -1 ? 25 : this.visibleLines);
        this.editorArea.setText(this.data.content);
        this.editorArea.getElement().setAttribute("spellcheck", "false");
        this.editorArea.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.editorArea.addKeyDownHandler((KeyDownHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    void insertText(String ins, boolean isSpecialPaste) {
        int p;
        this.editorArea.setFocus(true);
        int i = this.editorArea.getCursorPos();
        String left = this.editorArea.getText().substring(0, i);
        String right = this.editorArea.getText().substring(i, this.editorArea.getText().length());
        int cursorPosition = left.toCharArray().length;
        if (isSpecialPaste && (p = ins.indexOf("|")) > -1) {
            cursorPosition += p;
            ins = ins.replaceAll("\\|", "");
        }
        this.editorArea.setText(left + ins + right);
        this.data.content = this.editorArea.getText();
        this.editorArea.setCursorPos(cursorPosition);
    }

    public void onSave() {
    }

    public void onAfterSave() {
    }

    @UiHandler(value={"btnPackageResource"})
    public void addNewPackageResource(ClickEvent e) {
        this.addNewResourcePackage(new PackageResourceExplorerWidget(this.assetPackageUUID, this.assetPackageName, this.clientFactory, ExplorerRenderMode.DISPLAY_NAME_AND_DESCRIPTION));
    }

    private void addNewResourcePackage(PackageResourceExplorerWidget widget) {
        NewResourcePopup popup = new NewResourcePopup(widget.asWidget());
        popup.addOkButtonClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    @UiHandler(value={"btnAssetResource"})
    public void addNewAssetResource(ClickEvent e) {
        this.addNewResource(new AssetResourceExplorerWidget(this.assetPackageUUID, this.assetPackageName, this.clientFactory, AssetFormats.CHANGE_SET_RESOURCE, ExplorerRenderMode.DISPLAY_NAME_AND_DESCRIPTION, PackageDisplayMode.ALL_PACKAGES));
    }

    private void addNewResource(AssetResourceExplorerWidget widget) {
        NewResourcePopup popup = new NewResourcePopup(widget.asWidget());
        popup.addOkButtonClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    private Widget createChangeSetLink() {
        String url = RESTUtil.getRESTBaseURL();
        url = url + "packages/";
        url = url + this.assetPackageName;
        url = url + "/assets/";
        url = url + this.assetName;
        url = url + "/source";
        return new HTML(Constants.INSTANCE.Url() + ":&nbsp;<a href='" + url + "' target='_blank'>" + url + "</a>");
    }

    static /* synthetic */ RuleContentText access$000(ChangeSetEditor x0) {
        return x0.data;
    }
}

