/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.factmodel;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.guvnor.client.asseteditor.DefaultRuleContentWidget;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.SaveEventListener;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactModels;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactModelsEditor;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactModelsWidget;
import org.drools.guvnor.client.asseteditor.drools.factmodel.ModelNameHelper;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.AssetPageRow;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;

public class FactModelsWidget
extends Composite
implements SaveEventListener,
EditorWidget {
    private final Asset asset;
    private final ClientFactory clientFactory;
    private final List<FactMetaModel> superTypeFactModels = new ArrayList();
    private final ModelNameHelper modelNameHelper = new ModelNameHelper();
    private final SimplePanel editorContainer = new SimplePanel();

    public FactModelsWidget(Asset asset, RuleViewer viewer, ClientFactory clientFactory, EventBus eventBus) {
        this.asset = asset;
        this.clientFactory = clientFactory;
        if (this.isContentPlainText()) {
            this.initWidget(this.getPlainTextEditor());
        } else {
            this.initWidget((Widget)this.editorContainer);
            this.initFactModelsEditor();
        }
        this.setWidth("100%");
        this.setStyleName("model-builder-Background");
    }

    private boolean isContentPlainText() {
        return this.asset.getContent() instanceof RuleContentText;
    }

    private Widget getPlainTextEditor() {
        return new DefaultRuleContentWidget(this.asset);
    }

    private void initFactModelsEditor() {
        if (this.asset.getContent() == null) {
            this.asset.setContent((PortableObject)new FactModels());
        }
        this.populateSuperTypesFactModels();
    }

    private void populateSuperTypesFactModels() {
        String containingModuleUUID = this.asset.getMetaData().getModuleUUID();
        List<String> formats = Arrays.asList("model.drl");
        AssetPageRequest request = new AssetPageRequest(containingModuleUUID, formats, null);
        this.clientFactory.getAssetService().findAssetPage(request, (AsyncCallback)this.makeLoadAssetsCallback());
    }

    private GenericCallback<PageResponse<AssetPageRow>> makeLoadAssetsCallback() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private GenericCallback<Asset> makeLoadFactModelsCallback(FactModelsSemaphore s) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void addEditorToContainer() {
        FactModelsEditor editor = new FactModelsEditor(((FactModels)this.asset.getContent()).models, this.superTypeFactModels, this.modelNameHelper);
        this.editorContainer.setWidget((Widget)editor);
    }

    private void loadFacts(Asset asset) {
        if (asset.getContent() == null) {
            asset.setContent((PortableObject)new FactModels());
        }
        FactModels factModels = (FactModels)asset.getContent();
        for (FactMetaModel factMetaModel : factModels.models) {
            this.superTypeFactModels.add(factMetaModel);
            this.modelNameHelper.getTypeDescriptions().put(factMetaModel.getName(), factMetaModel.getName());
        }
    }

    public void onAfterSave() {
    }

    public void onSave() {
    }

    static /* synthetic */ Asset access$000(FactModelsWidget x0) {
        return x0.asset;
    }

    static /* synthetic */ void access$100(FactModelsWidget x0, Asset x1) {
        x0.loadFacts(x1);
    }

    static /* synthetic */ void access$200(FactModelsWidget x0) {
        x0.addEditorToContainer();
    }

    static /* synthetic */ GenericCallback access$300(FactModelsWidget x0, FactModelsSemaphore x1) {
        return x0.makeLoadFactModelsCallback(x1);
    }

    static /* synthetic */ ClientFactory access$400(FactModelsWidget x0) {
        return x0.clientFactory;
    }
}

