/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.HumanReadable;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CompositeFactPatternWidget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.DirtyableHorizontalPane;
import org.drools.guvnor.client.common.DirtyableVerticalPane;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;

public class CompositeFactPatternWidget
extends RuleModellerWidget {
    protected final SuggestionCompletionEngine completions;
    protected DirtyableFlexTable layout;
    protected CompositeFactPattern pattern;
    protected boolean readOnly;

    public CompositeFactPatternWidget(RuleModeller modeller, EventBus eventBus, CompositeFactPattern pattern, Boolean readOnly) {
        super(modeller, eventBus);
        this.completions = modeller.getSuggestionCompletions();
        this.pattern = pattern;
        this.layout = new DirtyableFlexTable();
        this.layout.setStyleName("model-builderInner-Background");
        if (readOnly != null) {
            this.readOnly = readOnly;
        } else {
            this.readOnly = false;
            if (this.pattern != null && this.pattern.getPatterns() != null) {
                IFactPattern[] patterns = this.pattern.getPatterns();
                for (int i = 0; i < patterns.length; ++i) {
                    IFactPattern p = patterns[i];
                    if (p.getFactType() == null || this.completions.containsFactType(p.getFactType())) continue;
                    this.readOnly = true;
                    break;
                }
            }
        }
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private HTML spacerWidget() {
        HTML h = new HTML("&nbsp;");
        h.setHeight("2px");
        return h;
    }

    private Widget wrapLHSWidget(CompositeFactPattern model, int i, RuleModellerWidget w) {
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        ImageButton remove = new ImageButton(DroolsGuvnorImages.INSTANCE.deleteItemSmall());
        remove.setTitle(Constants.INSTANCE.RemoveThisENTIREConditionAndAllTheFieldConstraintsThatBelongToIt());
        int idx = i;
        remove.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        horiz.setWidth("100%");
        w.setWidth("100%");
        horiz.add((Widget)w);
        if (!this.getModeller().lockLHS() && !w.isReadOnly()) {
            horiz.add((Widget)remove);
        }
        return horiz;
    }

    protected void doLayout() {
        this.layout.setWidget(0, 0, this.getCompositeLabel());
        this.layout.getFlexCellFormatter().setColSpan(0, 0, 2);
        this.layout.setWidget(1, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        if (this.pattern.getPatterns() != null) {
            DirtyableVerticalPane vert = new DirtyableVerticalPane();
            IFactPattern[] facts = this.pattern.getPatterns();
            for (int i = 0; i < facts.length; ++i) {
                RuleModellerWidget widget = this.getModeller().getWidgetFactory().getWidget(this.getModeller(), this.getEventBus(), (IPattern)facts[i], Boolean.valueOf(this.readOnly));
                widget.addOnModifiedCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
                vert.add(this.wrapLHSWidget(this.pattern, i, widget));
                vert.add((Widget)this.spacerWidget());
            }
            this.layout.setWidget(1, 1, (Widget)vert);
        }
    }

    protected Widget getCompositeLabel() {
        3 click = new /* Unavailable Anonymous Inner Class!! */;
        String lbl = HumanReadable.getCEDisplayName((String)this.pattern.type);
        if (this.pattern.getPatterns() == null || this.pattern.getPatterns().length == 0) {
            lbl = lbl + " <font color='red'>" + Constants.INSTANCE.clickToAddPatterns() + "</font>";
        }
        return new ClickableLabel(lbl + ":", (ClickHandler)click, !this.readOnly);
    }

    protected void showFactTypeSelector(Widget w) {
        ListBox box = new ListBox();
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        String[] facts = completions.getFactTypes();
        box.addItem(Constants.INSTANCE.Choose());
        for (int i = 0; i < facts.length; ++i) {
            box.addItem(facts[i]);
        }
        box.setSelectedIndex(0);
        FormStylePopup popup = new FormStylePopup();
        popup.setTitle(Constants.INSTANCE.NewFactPattern());
        popup.addAttribute(Constants.INSTANCE.chooseFactType(), (IsWidget)box);
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button fromBtn = new Button(Constants.INSTANCE.From());
        Button fromAccumulateBtn = new Button(Constants.INSTANCE.FromAccumulate());
        Button fromCollectBtn = new Button(Constants.INSTANCE.FromCollect());
        5 btnsClickHandler = new /* Unavailable Anonymous Inner Class!! */;
        fromBtn.addClickHandler((ClickHandler)btnsClickHandler);
        fromAccumulateBtn.addClickHandler((ClickHandler)btnsClickHandler);
        fromCollectBtn.addClickHandler((ClickHandler)btnsClickHandler);
        popup.addAttribute("", (IsWidget)fromBtn);
        popup.addAttribute("", (IsWidget)fromAccumulateBtn);
        popup.addAttribute("", (IsWidget)fromCollectBtn);
        popup.show();
    }
}

