/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.HasResizeHandlers;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.TextArea;

public class DynamicTextArea
extends TextArea
implements HasResizeHandlers {
    protected int minWidth = 60;
    protected int maxWidth = 100;
    protected int minLines = 1;
    protected int maxLines = 20;

    public DynamicTextArea() {
        this.getElement().setAttribute("wrap", "off");
    }

    public void setText(String text) {
        super.setText(text);
        this.assertTextAreaDimensions();
        this.addKeyDownHandler((KeyDownHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addKeyPressHandler((KeyPressHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void assertTextAreaDimensions() {
        String text = this.getText();
        int oldLines = this.getVisibleLines();
        int oldCharacters = this.getCharacterWidth();
        this.setNumberOfLines(text);
        this.setMaxLineWidth(text);
        boolean resizeContainer = false;
        if (oldLines != this.getVisibleLines()) {
            resizeContainer = true;
        }
        if (oldCharacters != this.getCharacterWidth()) {
            resizeContainer = true;
        }
        if (resizeContainer) {
            ResizeEvent.fire((HasResizeHandlers)this, (int)this.getVisibleLines(), (int)this.getCharacterWidth());
        }
    }

    private boolean setMaxLineWidth(String text) {
        boolean overflow = false;
        if (text == null || text.length() == 0) {
            this.setCharacterWidth(this.minWidth);
            return overflow;
        }
        int maxFoundWidth = 0;
        String[] aLines = text.split("\\n");
        for (int i = 0; i < aLines.length; ++i) {
            String aLine = aLines[i];
            if (aLine.length() <= maxFoundWidth) continue;
            maxFoundWidth = aLine.length();
        }
        if (maxFoundWidth < this.minWidth) {
            maxFoundWidth = this.minWidth;
        }
        if (maxFoundWidth > this.maxWidth) {
            maxFoundWidth = this.maxWidth;
            overflow = true;
        }
        this.setCharacterWidth(maxFoundWidth);
        return overflow;
    }

    private boolean setNumberOfLines(String text) {
        boolean overflow = false;
        if (text == null || text.length() == 0) {
            this.setVisibleLines(this.minLines);
            return overflow;
        }
        int lines = 1;
        String[] aLines = text.split("\\n");
        lines = aLines.length;
        if (text.endsWith("\n")) {
            ++lines;
        }
        if (lines < this.minLines) {
            lines = this.minLines;
        }
        if (lines > this.maxLines) {
            lines = this.maxLines;
            overflow = true;
        }
        this.setVisibleLines(lines);
        return overflow;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMinLines() {
        return this.minLines;
    }

    public void setMinLines(int minLines) {
        this.minLines = minLines;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public HandlerRegistration addResizeHandler(ResizeHandler handler) {
        return this.addHandler((EventHandler)handler, ResizeEvent.getType());
    }

    static /* synthetic */ void access$000(DynamicTextArea x0) {
        x0.assertTextAreaDimensions();
    }
}

