/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.ListBox;
import java.util.Arrays;
import java.util.HashSet;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.common.IDirtyable;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.ui.ConstraintValueEditorHelper;

public class EnumDropDown
extends ListBox
implements IDirtyable {
    private final DropDownValueChanged valueChangedCommand;

    public EnumDropDown(String currentValue, DropDownValueChanged valueChanged, DropDownData dropData) {
        this(currentValue, valueChanged, dropData, false);
    }

    public EnumDropDown(String currentValue, DropDownValueChanged valueChanged, DropDownData dropData, boolean multipleSelect) {
        super(multipleSelect);
        this.valueChangedCommand = valueChanged;
        this.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.setDropDownData(currentValue, dropData);
    }

    String getSelectedItemsText() {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.isItemSelected(i)) continue;
            if (!first) {
                buffer.append(",");
            }
            first = false;
            buffer.append(this.getItemText(i));
        }
        return buffer.toString();
    }

    String getSelectedValue() {
        if (this.getItemCount() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.isMultipleSelect()) {
            boolean first = true;
            buffer.append("( ");
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (!this.isItemSelected(i)) continue;
                if (!first) {
                    buffer.append(",");
                }
                first = false;
                buffer.append("\"");
                buffer.append(this.getValue(i));
                buffer.append("\"");
            }
            buffer.append(" )");
        } else {
            buffer.append(this.getValue(this.getSelectedIndex()));
        }
        return buffer.toString();
    }

    public void setDropDownData(String currentValue, DropDownData dropData) {
        if (dropData != null && dropData.fixedList == null && dropData.queryExpression != null) {
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.fillDropDown(currentValue, dropData);
        }
    }

    private void fillDropDown(String currentValue, DropDownData dropData) {
        if (dropData == null) {
            this.fillDropDown(currentValue, new String[0]);
        } else {
            this.fillDropDown(currentValue, dropData.fixedList);
        }
    }

    private void fillDropDown(String currentValue, String[] enumeratedValues) {
        this.clear();
        boolean selected = false;
        HashSet<String> currentValues = new HashSet<String>();
        String trimmedCurrentValue = currentValue;
        if (this.isMultipleSelect() && trimmedCurrentValue != null) {
            trimmedCurrentValue = currentValue.replace("\"", "");
            trimmedCurrentValue = trimmedCurrentValue.replace("(", "");
            trimmedCurrentValue = trimmedCurrentValue.replace(")", "");
            if ((trimmedCurrentValue = trimmedCurrentValue.trim()).indexOf(",") > 0) {
                currentValues.addAll(Arrays.asList(trimmedCurrentValue.split(",")));
            }
        } else {
            currentValues.add(currentValue);
        }
        for (int i = 0; i < enumeratedValues.length; ++i) {
            String val;
            String v = enumeratedValues[i];
            if (v.indexOf(61) > 0) {
                String[] splut = ConstraintValueEditorHelper.splitValue((String)v);
                String realValue = splut[0];
                String display = splut[1];
                val = realValue;
                this.addItem(display, realValue);
            } else {
                this.addItem(v);
                val = v;
            }
            if (currentValue == null || !currentValues.contains(val)) continue;
            this.setItemSelected(i, true);
            selected = true;
        }
        if (!selected) {
            int itemCount = this.getItemCount();
            this.setEnabled(itemCount > 0);
            if (itemCount > 0) {
                this.setSelectedIndex(0);
                Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    static /* synthetic */ DropDownValueChanged access$000(EnumDropDown x0) {
        return x0.valueChangedCommand;
    }

    static /* synthetic */ void access$100(EnumDropDown x0, String x1, String[] x2) {
        x0.fillDropDown(x1, x2);
    }
}

