/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.HumanReadable;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.ExpressionBuilder;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.FactPatternWidget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.FromCompositeFactPatternWidget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.DirtyableHorizontalPane;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;

public class FromCompositeFactPatternWidget
extends RuleModellerWidget {
    protected FromCompositeFactPattern pattern;
    protected DirtyableFlexTable layout;
    protected boolean readOnly;

    public FromCompositeFactPatternWidget(RuleModeller modeller, EventBus eventBus, FromCompositeFactPattern pattern) {
        this(modeller, eventBus, pattern, null);
    }

    public FromCompositeFactPatternWidget(RuleModeller modeller, EventBus eventBus, FromCompositeFactPattern pattern, Boolean readOnly) {
        super(modeller, eventBus);
        this.pattern = pattern;
        if (readOnly == null) {
            this.calculateReadOnly();
        } else {
            this.readOnly = readOnly;
        }
        this.layout = new DirtyableFlexTable();
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.layout.addStyleName("model-builderInner-Background");
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    protected void doLayout() {
        FactPattern fact;
        int row = 0;
        if (this.pattern.getFactPattern() != null && (fact = this.pattern.getFactPattern()) != null) {
            this.layout.setWidget(row++, 0, this.createFactPatternWidget(fact));
        }
        this.layout.setWidget(row++, 0, this.getCompositeLabel());
    }

    private Widget createFactPatternWidget(FactPattern fact) {
        if (this.readOnly) {
            FactPatternWidget factPatternWidget = new FactPatternWidget(this.getModeller(), this.getEventBus(), (IPattern)fact, false, Boolean.valueOf(true));
            return factPatternWidget;
        }
        FactPatternWidget factPatternWidget = new FactPatternWidget(this.getModeller(), this.getEventBus(), (IPattern)fact, true, Boolean.valueOf(false));
        factPatternWidget.addOnModifiedCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        return this.addRemoveButton((Widget)factPatternWidget, this.createClickHandlerForAddRemoveButton());
    }

    private ClickHandler createClickHandlerForAddRemoveButton() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected Widget getCompositeLabel() {
        3 click = new /* Unavailable Anonymous Inner Class!! */;
        String lbl = "<div class='form-field'>" + HumanReadable.getCEDisplayName((String)"from") + "</div>";
        DirtyableFlexTable panel = new DirtyableFlexTable();
        int r = 0;
        if (this.pattern.getFactPattern() == null) {
            panel.setWidget(r, 0, (Widget)new ClickableLabel("<br> <font color='red'>" + Constants.INSTANCE.clickToAddPatterns() + "</font>", (ClickHandler)click, !this.readOnly));
            ++r;
        }
        panel.setWidget(r, 0, (Widget)new HTML(lbl));
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getModeller(), this.getEventBus(), this.pattern.getExpression(), Boolean.valueOf(this.readOnly));
        expressionBuilder.addOnModifiedCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        panel.setWidget(r, 1, (Widget)expressionBuilder);
        return panel;
    }

    protected void showFactTypeSelector(Widget w) {
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        ListBox box = new ListBox();
        String[] facts = completions.getFactTypes();
        box.addItem(Constants.INSTANCE.Choose());
        for (int i = 0; i < facts.length; ++i) {
            box.addItem(facts[i]);
        }
        box.setSelectedIndex(0);
        FormStylePopup popup = new FormStylePopup();
        popup.setTitle(Constants.INSTANCE.NewFactPattern());
        popup.addAttribute(Constants.INSTANCE.chooseFactType(), (IsWidget)box);
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    protected Widget addRemoveButton(Widget w, ClickHandler listener) {
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        ImageButton remove = new ImageButton(DroolsGuvnorImages.INSTANCE.deleteItemSmall());
        remove.setTitle(Constants.INSTANCE.RemoveThisBlockOfData());
        remove.addClickHandler(listener);
        horiz.setWidth("100%");
        w.setWidth("100%");
        horiz.add(w);
        if (!this.readOnly) {
            horiz.add((Widget)remove);
        }
        return horiz;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    protected void calculateReadOnly() {
        if (this.pattern.factPattern != null) {
            this.readOnly = !this.getModeller().getSuggestionCompletions().containsFactType(this.pattern.factPattern.getFactType());
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

