/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.drools.guvnor.client.common.AbstractRestrictedEntryTextBox;
import org.drools.guvnor.client.common.NumericBigDecimalTextBox;
import org.drools.guvnor.client.common.NumericBigIntegerTextBox;
import org.drools.guvnor.client.common.NumericByteTextBox;
import org.drools.guvnor.client.common.NumericDoubleTextBox;
import org.drools.guvnor.client.common.NumericFloatTextBox;
import org.drools.guvnor.client.common.NumericIntegerTextBox;
import org.drools.guvnor.client.common.NumericLongTextBox;
import org.drools.guvnor.client.common.NumericShortTextBox;
import org.drools.guvnor.client.common.NumericTextBox;
import org.drools.guvnor.client.common.PopupDatePicker;
import org.drools.guvnor.client.configurations.ApplicationPreferences;
import org.drools.guvnor.client.decisiontable.DTCellValueWidgetFactory;
import org.drools.guvnor.client.decisiontable.widget.DefaultValueDropDownManager;
import org.drools.guvnor.client.decisiontable.widget.LimitedEntryDropDownManager;
import org.drools.guvnor.client.messages.Constants;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.drools.ide.common.client.modeldriven.ui.ConstraintValueEditorHelper;

public class DTCellValueWidgetFactory {
    private final SuggestionCompletionEngine sce;
    private final GuidedDecisionTable52 dtable;
    private final LimitedEntryDropDownManager dropDownManager;
    private final boolean isReadOnly;
    private final boolean allowEmptyValues;
    private static final String DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
    private static final DateTimeFormat format = DateTimeFormat.getFormat((String)DATE_FORMAT);

    public static DTCellValueWidgetFactory getInstance(GuidedDecisionTable52 dtable, SuggestionCompletionEngine sce, boolean isReadOnly, boolean allowEmptyValues) {
        switch (17.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$GuidedDecisionTable52$TableFormat[dtable.getTableFormat().ordinal()]) {
            case 1: {
                return new DTCellValueWidgetFactory(dtable, sce, (LimitedEntryDropDownManager)new DefaultValueDropDownManager(dtable, sce), isReadOnly, allowEmptyValues);
            }
        }
        return new DTCellValueWidgetFactory(dtable, sce, new LimitedEntryDropDownManager(dtable, sce), isReadOnly, allowEmptyValues);
    }

    private DTCellValueWidgetFactory(GuidedDecisionTable52 dtable, SuggestionCompletionEngine sce, LimitedEntryDropDownManager dropDownManager, boolean isReadOnly, boolean allowEmptyValues) {
        this.sce = sce;
        this.dtable = dtable;
        this.dropDownManager = dropDownManager;
        this.isReadOnly = isReadOnly;
        this.allowEmptyValues = allowEmptyValues;
    }

    public DTCellValue52 makeNewValue(DTColumnConfig52 c) {
        DTDataTypes52 type = this.dtable.getTypeSafeType((BaseColumn)c, this.sce);
        return new DTCellValue52(type, this.allowEmptyValues);
    }

    public DTCellValue52 makeNewValue(Pattern52 p, ConditionCol52 c) {
        DTDataTypes52 type = this.dtable.getTypeSafeType(p, c, this.sce);
        return new DTCellValue52(type, this.allowEmptyValues);
    }

    public Widget getWidget(Pattern52 pattern, ConditionCol52 column, DTCellValue52 value) {
        if (this.dtable.hasValueList(column)) {
            String[] valueList = this.dtable.getValueList((BaseColumn)column);
            return this.makeListBox(valueList, pattern, column, value);
        }
        if (this.sce.hasEnums(pattern.getFactType(), column.getFactField())) {
            LimitedEntryDropDownManager.Context context = new LimitedEntryDropDownManager.Context(pattern, column);
            Map currentValueMap = this.dropDownManager.getCurrentValueMap(context);
            DropDownData dd = this.sce.getEnums(pattern.getFactType(), column.getFactField(), currentValueMap);
            if (dd == null) {
                return this.makeListBox(new String[0], pattern, column, value);
            }
            return this.makeListBox(dd.fixedList, pattern, column, value);
        }
        DTDataTypes52 type = this.dtable.getTypeSafeType(pattern, column, this.sce);
        switch (17.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[type.ordinal()]) {
            case 1: {
                return this.makeNumericTextBox(value);
            }
            case 2: {
                return this.makeNumericBigDecimalTextBox(value);
            }
            case 3: {
                return this.makeNumericBigIntegerTextBox(value);
            }
            case 4: {
                return this.makeNumericByteTextBox(value);
            }
            case 5: {
                return this.makeNumericDoubleTextBox(value);
            }
            case 6: {
                return this.makeNumericFloatTextBox(value);
            }
            case 7: {
                return this.makeNumericIntegerTextBox(value);
            }
            case 8: {
                return this.makeNumericLongTextBox(value);
            }
            case 9: {
                return this.makeNumericShortTextBox(value);
            }
            case 10: {
                return this.makeBooleanSelector(value);
            }
            case 11: {
                return this.makeDateSelector(value);
            }
        }
        return this.makeTextBox(value);
    }

    public DTCellValue52 makeNewValue(Pattern52 p, ActionSetFieldCol52 c) {
        DTDataTypes52 type = this.dtable.getTypeSafeType(p, c, this.sce);
        return new DTCellValue52(type, this.allowEmptyValues);
    }

    public Widget getWidget(Pattern52 pattern, ActionSetFieldCol52 column, DTCellValue52 value) {
        if (this.dtable.hasValueList(column)) {
            String[] valueList = this.dtable.getValueList((BaseColumn)column);
            return this.makeListBox(valueList, pattern, column, value);
        }
        if (this.sce.hasEnums(pattern.getFactType(), column.getFactField())) {
            LimitedEntryDropDownManager.Context context = new LimitedEntryDropDownManager.Context(pattern, column);
            Map currentValueMap = this.dropDownManager.getCurrentValueMap(context);
            DropDownData dd = this.sce.getEnums(pattern.getFactType(), column.getFactField(), currentValueMap);
            if (dd == null) {
                return this.makeListBox(new String[0], pattern, column, value);
            }
            return this.makeListBox(dd.fixedList, pattern, column, value);
        }
        DTDataTypes52 type = this.dtable.getTypeSafeType(pattern, column, this.sce);
        switch (17.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[type.ordinal()]) {
            case 1: {
                return this.makeNumericTextBox(value);
            }
            case 2: {
                return this.makeNumericBigDecimalTextBox(value);
            }
            case 3: {
                return this.makeNumericBigIntegerTextBox(value);
            }
            case 4: {
                return this.makeNumericByteTextBox(value);
            }
            case 5: {
                return this.makeNumericDoubleTextBox(value);
            }
            case 6: {
                return this.makeNumericFloatTextBox(value);
            }
            case 7: {
                return this.makeNumericIntegerTextBox(value);
            }
            case 8: {
                return this.makeNumericLongTextBox(value);
            }
            case 9: {
                return this.makeNumericShortTextBox(value);
            }
            case 10: {
                return this.makeBooleanSelector(value);
            }
            case 11: {
                return this.makeDateSelector(value);
            }
        }
        return this.makeTextBox(value);
    }

    public Widget getWidget(ActionInsertFactCol52 column, DTCellValue52 value) {
        if (this.dtable.hasValueList(column)) {
            String[] valueList = this.dtable.getValueList((BaseColumn)column);
            return this.makeListBox(valueList, column, value);
        }
        if (this.sce.hasEnums(column.getFactType(), column.getFactField())) {
            LimitedEntryDropDownManager.Context context = new LimitedEntryDropDownManager.Context(column);
            Map currentValueMap = this.dropDownManager.getCurrentValueMap(context);
            DropDownData dd = this.sce.getEnums(column.getFactType(), column.getFactField(), currentValueMap);
            if (dd == null) {
                return this.makeListBox(new String[0], column, value);
            }
            return this.makeListBox(dd.fixedList, column, value);
        }
        DTDataTypes52 type = this.dtable.getTypeSafeType((BaseColumn)column, this.sce);
        switch (17.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[type.ordinal()]) {
            case 1: {
                return this.makeNumericTextBox(value);
            }
            case 2: {
                return this.makeNumericBigDecimalTextBox(value);
            }
            case 3: {
                return this.makeNumericBigIntegerTextBox(value);
            }
            case 4: {
                return this.makeNumericByteTextBox(value);
            }
            case 5: {
                return this.makeNumericDoubleTextBox(value);
            }
            case 6: {
                return this.makeNumericFloatTextBox(value);
            }
            case 7: {
                return this.makeNumericIntegerTextBox(value);
            }
            case 8: {
                return this.makeNumericLongTextBox(value);
            }
            case 9: {
                return this.makeNumericShortTextBox(value);
            }
            case 10: {
                return this.makeBooleanSelector(value);
            }
            case 11: {
                return this.makeDateSelector(value);
            }
        }
        return this.makeTextBox(value);
    }

    private ListBox makeBooleanSelector(DTCellValue52 value) {
        ListBox lb = new ListBox();
        int indexTrue = 0;
        int indexFalse = 1;
        if (this.allowEmptyValues) {
            indexTrue = 1;
            indexFalse = 2;
            lb.addItem(Constants.INSTANCE.Choose(), "");
        }
        lb.addItem("true");
        lb.addItem("false");
        Boolean currentItem = value.getBooleanValue();
        if (currentItem == null) {
            lb.setSelectedIndex(0);
        } else {
            lb.setSelectedIndex(currentItem != false ? indexTrue : indexFalse);
        }
        lb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            lb.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return lb;
    }

    private ListBox makeListBox(String[] completions, Pattern52 basePattern, ConditionCol52 baseCondition, DTCellValue52 value) {
        ListBox lb = this.makeListBox(completions, value);
        lb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            lb.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return lb;
    }

    private ListBox makeListBox(String[] completions, Pattern52 basePattern, ActionSetFieldCol52 baseAction, DTCellValue52 value) {
        ListBox lb = this.makeListBox(completions, value);
        lb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            lb.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return lb;
    }

    private ListBox makeListBox(String[] completions, ActionInsertFactCol52 baseAction, DTCellValue52 value) {
        ListBox lb = this.makeListBox(completions, value);
        lb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            lb.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return lb;
    }

    private ListBox makeListBox(String[] completions, DTCellValue52 value) {
        int selectedIndex = -1;
        ListBox lb = new ListBox();
        if (this.allowEmptyValues) {
            lb.addItem(Constants.INSTANCE.Choose(), "");
        }
        String currentItem = value.getStringValue();
        int selectedIndexOffset = this.allowEmptyValues ? 1 : 0;
        for (int i = 0; i < completions.length; ++i) {
            String item = completions[i].trim();
            String[] splut = ConstraintValueEditorHelper.splitValue((String)item);
            lb.addItem(splut[1], splut[0]);
            if (!splut[0].equals(currentItem)) continue;
            lb.setSelectedIndex(i + selectedIndexOffset);
            selectedIndex = i + selectedIndexOffset;
        }
        if (selectedIndex == -1) {
            if (lb.getItemCount() > 0) {
                lb.setSelectedIndex(0);
                value.setStringValue(lb.getValue(0));
            } else {
                value.setStringValue(null);
            }
        }
        return lb;
    }

    private AbstractRestrictedEntryTextBox makeNumericTextBox(DTCellValue52 value) {
        NumericTextBox tb = new NumericTextBox(this.allowEmptyValues);
        BigDecimal numericValue = (BigDecimal)value.getNumericValue();
        tb.setValue((Object)(numericValue == null ? "" : numericValue.toPlainString()));
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericBigDecimalTextBox(DTCellValue52 value) {
        NumericBigDecimalTextBox tb = new NumericBigDecimalTextBox(this.allowEmptyValues);
        BigDecimal numericValue = (BigDecimal)value.getNumericValue();
        tb.setValue((Object)(numericValue == null ? "" : numericValue.toPlainString()));
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericBigIntegerTextBox(DTCellValue52 value) {
        NumericBigIntegerTextBox tb = new NumericBigIntegerTextBox(this.allowEmptyValues);
        BigInteger numericValue = (BigInteger)value.getNumericValue();
        tb.setValue((Object)(numericValue == null ? "" : numericValue.toString()));
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericByteTextBox(DTCellValue52 value) {
        NumericByteTextBox tb = new NumericByteTextBox(this.allowEmptyValues);
        Byte numericValue = (Byte)value.getNumericValue();
        tb.setValue((Object)(numericValue == null ? "" : numericValue.toString()));
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericDoubleTextBox(DTCellValue52 value) {
        NumericDoubleTextBox tb = new NumericDoubleTextBox(this.allowEmptyValues);
        Double numericValue = (Double)value.getNumericValue();
        tb.setValue((Object)(numericValue == null ? "" : numericValue.toString()));
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericFloatTextBox(DTCellValue52 value) {
        NumericFloatTextBox tb = new NumericFloatTextBox(this.allowEmptyValues);
        Float numericValue = (Float)value.getNumericValue();
        tb.setValue((Object)(numericValue == null ? "" : numericValue.toString()));
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericIntegerTextBox(DTCellValue52 value) {
        NumericIntegerTextBox tb = new NumericIntegerTextBox(this.allowEmptyValues);
        Integer numericValue = (Integer)value.getNumericValue();
        tb.setValue((Object)(numericValue == null ? "" : numericValue.toString()));
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericLongTextBox(DTCellValue52 value) {
        NumericLongTextBox tb = new NumericLongTextBox(this.allowEmptyValues);
        Long numericValue = (Long)value.getNumericValue();
        tb.setValue((Object)(numericValue == null ? "" : numericValue.toString()));
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return tb;
    }

    private AbstractRestrictedEntryTextBox makeNumericShortTextBox(DTCellValue52 value) {
        NumericShortTextBox tb = new NumericShortTextBox(this.allowEmptyValues);
        Short numericValue = (Short)value.getNumericValue();
        tb.setValue((Object)(numericValue == null ? "" : numericValue.toString()));
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return tb;
    }

    private TextBox makeTextBox(DTCellValue52 value) {
        TextBox tb = new TextBox();
        tb.setValue((Object)value.getStringValue());
        tb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            tb.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return tb;
    }

    private Widget makeDateSelector(DTCellValue52 value) {
        if (this.isReadOnly) {
            Label dateLabel = new Label();
            dateLabel.setText(format.format(value.getDateValue()));
            return dateLabel;
        }
        PopupDatePicker dp = new PopupDatePicker(this.allowEmptyValues);
        if (value.getDateValue() != null) {
            dp.setValue(value.getDateValue());
        }
        dp.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return dp;
    }

    public static CheckBox getHideColumnIndicator(DTColumnConfig52 col) {
        CheckBox chkHide = new CheckBox();
        chkHide.setValue(Boolean.valueOf(col.isHideColumn()));
        chkHide.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return chkHide;
    }

    static /* synthetic */ LimitedEntryDropDownManager access$000(DTCellValueWidgetFactory x0) {
        return x0.dropDownManager;
    }

    static /* synthetic */ GuidedDecisionTable52 access$100(DTCellValueWidgetFactory x0) {
        return x0.dtable;
    }

    static /* synthetic */ boolean access$200(DTCellValueWidgetFactory x0) {
        return x0.allowEmptyValues;
    }
}

