/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.AssetAttachmentFileWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.decisiontable.ConversionMessageWidget;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.RefreshModuleEditorEvent;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.ConversionResult;
import org.drools.guvnor.client.widgets.PopupListWidget;

public class DecisionTableXLSWidget
extends AssetAttachmentFileWidget {
    public DecisionTableXLSWidget(Asset asset, RuleViewer viewer, ClientFactory clientFactory, EventBus eventBus) {
        super(asset, viewer, clientFactory, eventBus);
        if (!asset.isReadonly()) {
            super.addSupplementaryWidget(this.makeConvertToGuidedDecisionTableWidget(asset));
        }
        super.addSupplementaryWidget(this.makeDescriptionWidget());
    }

    private Widget makeConvertToGuidedDecisionTableWidget(Asset asset) {
        Button convertButton = new Button(Constants.INSTANCE.ConvertTo0(Constants.INSTANCE.DecisionTableWebGuidedEditor()));
        convertButton.setEnabled(asset.getVersionNumber() > 0L);
        convertButton.addClickHandler(this.getConvertButtonClickHandler());
        return convertButton;
    }

    private ClickHandler getConvertButtonClickHandler() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void postConversion(ConversionResult result) {
        LoadingPopup.close();
        this.eventBus.fireEvent((GwtEvent)new RefreshModuleEditorEvent(this.asset.metaData.moduleUUID));
        if (result.getMessages().size() > 0) {
            PopupListWidget popup = new PopupListWidget(600, 200);
            for (ConversionResult.ConversionMessage message : result.getMessages()) {
                popup.addListItem((Widget)new ConversionMessageWidget(message));
            }
            popup.show();
        }
    }

    private Widget makeDescriptionWidget() {
        return new HTML(Constants.INSTANCE.DecisionTableWidgetDescription());
    }

    public ImageResource getIcon() {
        return DroolsGuvnorImages.INSTANCE.decisionTable();
    }

    public String getOverallStyleName() {
        return "decision-Table-upload";
    }

    static /* synthetic */ Asset access$000(DecisionTableXLSWidget x0) {
        return x0.asset;
    }

    static /* synthetic */ void access$100(DecisionTableXLSWidget x0, ConversionResult x1) {
        x0.postConversion(x1);
    }

    static /* synthetic */ ClientFactory access$200(DecisionTableXLSWidget x0) {
        return x0.clientFactory;
    }
}

