/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.analysis.condition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.guvnor.client.decisiontable.analysis.condition.ConditionDetector;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

public class StringConditionDetector
extends ConditionDetector<StringConditionDetector> {
    private List<String> allowedValueList = null;
    private List<String> disallowedList = new ArrayList(1);

    public StringConditionDetector(Pattern52 pattern, String factField, String value, String operator) {
        super(pattern, factField);
        if (operator.equals("==")) {
            this.allowedValueList = new ArrayList(1);
            this.allowedValueList.add(value);
        } else if (operator.equals("!=")) {
            this.disallowedList.add(value);
        } else if (operator.equals("in")) {
            String[] tokens = value.split(",");
            this.allowedValueList = new ArrayList(tokens.length);
            Collections.addAll(this.allowedValueList, tokens);
        } else {
            this.hasUnrecognizedConstraint = true;
        }
    }

    public StringConditionDetector(StringConditionDetector a, StringConditionDetector b) {
        super((ConditionDetector)a, (ConditionDetector)b);
        if (b.allowedValueList == null) {
            this.allowedValueList = a.allowedValueList;
        } else if (a.allowedValueList == null) {
            this.allowedValueList = b.allowedValueList;
        } else {
            this.allowedValueList = new ArrayList(a.allowedValueList);
            this.allowedValueList.retainAll(b.allowedValueList);
        }
        this.disallowedList.addAll(a.disallowedList);
        this.disallowedList.addAll(b.disallowedList);
        this.optimizeAllowedValueList();
        this.detectImpossibleMatch();
    }

    private void optimizeAllowedValueList() {
        if (this.allowedValueList != null) {
            this.allowedValueList.removeAll(this.disallowedList);
            this.disallowedList.clear();
        }
    }

    private void detectImpossibleMatch() {
        if (this.allowedValueList != null && this.allowedValueList.isEmpty()) {
            this.impossibleMatch = true;
        }
    }

    public StringConditionDetector merge(StringConditionDetector other) {
        return new StringConditionDetector(this, other);
    }
}

