/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.cells;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.NumericLongTextBox;
import org.drools.guvnor.client.decisiontable.cells.AbstractPopupEditCell;

public class PopupNumericLongEditCell
extends AbstractPopupEditCell<Long, Long> {
    private final TextBox textBox = new NumericLongTextBox();

    public PopupNumericLongEditCell(boolean isReadOnly) {
        super(isReadOnly);
        this.textBox.addKeyDownHandler((KeyDownHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.vPanel.add((Widget)this.textBox);
    }

    public void render(Cell.Context context, Long value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(this.renderer.render((Object)value.toString()));
        }
    }

    protected void commit() {
        String text = this.textBox.getValue();
        Long number = null;
        if (text.length() > 0) {
            try {
                number = new Long(text);
            }
            catch (NumberFormatException e) {
                number = new Long(0L);
            }
        }
        this.setValue(this.lastContext, this.lastParent, (Object)number);
        if (this.valueUpdater != null) {
            this.valueUpdater.update((Object)number);
        }
        this.panel.hide();
    }

    protected void startEditing(Cell.Context context, Element parent, Long value) {
        this.textBox.setValue((Object)(value == null ? "" : value.toString()));
        this.panel.setPopupPositionAndShow((PopupPanel.PositionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ TextBox access$000(PopupNumericLongEditCell x0) {
        return x0.textBox;
    }
}

