/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa;

import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.explorer.navigation.qa.FactUsagesItem;
import org.drools.guvnor.client.explorer.navigation.qa.VerifierMessageLinesItem;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.client.rpc.AnalysisReportLine;

public class VerifierResultWidget
extends Composite {
    public VerifierResultWidget(AnalysisReport report, boolean showFactUsage) {
        FormStyleLayout layout = new FormStyleLayout();
        Tree tree = new Tree();
        TreeItem errors = this.doMessageLines(Constants.INSTANCE.Errors(), DroolsGuvnorImages.INSTANCE.error(), report.errors);
        tree.addItem(errors);
        TreeItem warnings = this.doMessageLines(Constants.INSTANCE.Warnings(), DroolsGuvnorImages.INSTANCE.warning(), report.warnings);
        tree.addItem(warnings);
        TreeItem notes = this.doMessageLines(Constants.INSTANCE.Notes(), DroolsGuvnorImages.INSTANCE.note(), report.notes);
        tree.addItem(notes);
        if (showFactUsage) {
            tree.addItem((TreeItem)new FactUsagesItem(report.factUsages));
        }
        tree.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
        tree.addOpenHandler((OpenHandler)new /* Unavailable Anonymous Inner Class!! */);
        layout.addRow((Widget)tree);
        this.initWidget((Widget)layout);
    }

    private TreeItem doMessageLines(String messageType, ImageResource icon, AnalysisReportLine[] lines) {
        String summary = Constants.INSTANCE.analysisResultSummary(messageType, lines.length);
        String topicHtml = AbstractImagePrototype.create((ImageResource)icon).getHTML() + "&nbsp; " + summary;
        VerifierMessageLinesItem linesItem = new VerifierMessageLinesItem(topicHtml, lines);
        return linesItem;
    }

    private void swapTitleWithUserObject(TreeItem x) {
        if (x.getUserObject() != null) {
            Widget currentW = x.getWidget();
            x.setWidget((Widget)x.getUserObject());
            x.setUserObject((Object)currentW);
        }
    }

    static /* synthetic */ void access$000(VerifierResultWidget x0, TreeItem x1) {
        x0.swapTitleWithUserObject(x1);
    }
}

