/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.widgets.drools.explorer.AbstractResourceDefinitionExplorerWidget;
import org.drools.guvnor.client.widgets.drools.explorer.AssetResourceExplorerWidget;
import org.drools.guvnor.client.widgets.drools.explorer.ExplorerRenderMode;
import org.drools.guvnor.client.widgets.drools.explorer.PackageDisplayMode;
import org.drools.guvnor.client.widgets.drools.explorer.ResourceElementReadyCommand;
import org.drools.guvnor.client.widgets.tables.AssetPagedTable;

public class AssetResourceExplorerWidget
extends AbstractResourceDefinitionExplorerWidget {
    private boolean globalArea;
    private ModuleServiceAsync packageService;
    private final AssetServiceAsync assetService;
    private ClientFactory clientFactory;
    private String packageUUID;
    private final PackageDisplayMode packageDisplayMode;
    private static CreateAssetResourceWidgetBinder uiBinder = (CreateAssetResourceWidgetBinder)GWT.create(CreateAssetResourceWidgetBinder.class);
    @UiField
    protected TextBox txtName;
    @UiField
    protected TextBox txtDescription;
    @UiField
    protected ListBox lstPackage;
    @UiField
    protected ListBox lstFormat;
    @UiField
    protected ScrollPanel sclTreePanel;
    @UiField
    protected Label labelName;
    @UiField
    protected Label labelDescr;
    protected AssetPagedTable assetsTable;

    public AssetResourceExplorerWidget(String packageUUID, String packageName, ClientFactory clientFactory, String[] formatList, ExplorerRenderMode mode, PackageDisplayMode packageDisplayMode) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.globalArea = packageName.equals("globalArea");
        this.packageService = clientFactory.getModuleService();
        this.assetService = clientFactory.getAssetService();
        this.clientFactory = clientFactory;
        this.packageDisplayMode = packageDisplayMode;
        this.packageUUID = packageUUID;
        this.initializeFormatList(formatList);
        this.initializePackageList();
        if (mode.equals((Object)ExplorerRenderMode.HIDE_NAME_AND_DESCRIPTION)) {
            this.txtName.setVisible(false);
            this.txtDescription.setVisible(false);
            this.labelName.setVisible(false);
            this.labelDescr.setVisible(false);
        }
    }

    private void initializePackageList() {
        if (this.globalArea || this.packageDisplayMode.equals((Object)PackageDisplayMode.ALL_PACKAGES)) {
            this.packageService.loadGlobalModule((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            this.packageService.listModules((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.packageService.loadModule(this.packageUUID, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.lstPackage.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initializeFormatList(String[] formatList) {
        for (String format : formatList) {
            this.lstFormat.addItem(format, format);
        }
        this.lstFormat.setSelectedIndex(0);
        this.lstFormat.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadAssetTable() {
        this.sclTreePanel.clear();
        String selectedPackageUUID = this.lstPackage.getValue(this.lstPackage.getSelectedIndex());
        ArrayList<String> selectedFormats = new ArrayList<String>();
        selectedFormats.add(this.lstFormat.getValue(this.lstFormat.getSelectedIndex()));
        this.assetsTable = new AssetPagedTable(selectedPackageUUID, selectedFormats, null, this.clientFactory);
        this.sclTreePanel.add((Widget)this.assetsTable);
        this.makeDirty();
    }

    private void handleListChanges(ChangeEvent event) {
        this.loadAssetTable();
    }

    private void populatePackageList(Module packageConfigData, String uuidToBeSelected) {
        this.lstPackage.addItem(packageConfigData.getName(), packageConfigData.getUuid());
        if (uuidToBeSelected == null) {
            this.lstPackage.setSelectedIndex(0);
        } else if (packageConfigData.getUuid().equals(uuidToBeSelected)) {
            this.lstPackage.setSelectedIndex(this.lstPackage.getItemCount() - 1);
        }
    }

    public void processSelectedResources(ResourceElementReadyCommand command) {
        String[] selectedRowUUIDs = this.assetsTable.getSelectedRowUUIDs();
        if (selectedRowUUIDs == null || selectedRowUUIDs.length == 0) {
            throw new IllegalStateException(Constants.INSTANCE.NoPackageSeleced());
        }
        this.assetService.loadRuleAssets(selectedRowUUIDs, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ String access$000(AssetResourceExplorerWidget x0) {
        return x0.packageUUID;
    }

    static /* synthetic */ void access$100(AssetResourceExplorerWidget x0, Module x1, String x2) {
        x0.populatePackageList(x1, x2);
    }

    static /* synthetic */ void access$200(AssetResourceExplorerWidget x0) {
        x0.loadAssetTable();
    }

    static /* synthetic */ void access$300(AssetResourceExplorerWidget x0, ChangeEvent x1) {
        x0.handleListChanges(x1);
    }
}

