/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.List;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.BindingTextBox;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CEPWindowOperatorsDropdown;
import org.drools.guvnor.client.decisiontable.Validator;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.resources.WizardCellListResources;
import org.drools.guvnor.client.resources.WizardResources;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.FactPatternsPageView;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.FactPatternsPageViewImpl;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.MinimumWidthCellList;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.cells.PatternCell;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

public class FactPatternsPageViewImpl
extends Composite
implements FactPatternsPageView {
    private FactPatternsPageView.Presenter presenter;
    private Validator validator;
    private Set<String> availableTypesSelections;
    private MinimumWidthCellList<String> availableTypesWidget;
    private List<Pattern52> chosenPatterns;
    private Pattern52 chosenPatternSelection;
    private Set<Pattern52> chosenPatternSelections;
    private MinimumWidthCellList<Pattern52> chosenPatternWidget;
    @UiField
    ScrollPanel availableTypesContainer;
    @UiField
    ScrollPanel chosenPatternsContainer;
    @UiField
    PushButton btnAdd;
    @UiField
    PushButton btnRemove;
    @UiField
    VerticalPanel patternDefinition;
    @UiField
    BindingTextBox txtBinding;
    @UiField
    HorizontalPanel bindingContainer;
    @UiField
    TextBox txtEntryPoint;
    @UiField
    CEPWindowOperatorsDropdown ddCEPWindow;
    @UiField
    HorizontalPanel cepWindowContainer;
    @UiField
    HorizontalPanel msgDuplicateBindings;
    @UiField(provided=true)
    PushButton btnMoveUp = new PushButton(AbstractImagePrototype.create((ImageResource)DroolsGuvnorImages.INSTANCE.shuffleUp()).createImage());
    @UiField(provided=true)
    PushButton btnMoveDown = new PushButton(AbstractImagePrototype.create((ImageResource)DroolsGuvnorImages.INSTANCE.shuffleDown()).createImage());
    private static FactPatternsPageWidgetBinder uiBinder = (FactPatternsPageWidgetBinder)GWT.create(FactPatternsPageWidgetBinder.class);

    public FactPatternsPageViewImpl(Validator validator) {
        this.validator = validator;
        this.availableTypesWidget = new MinimumWidthCellList((Cell)new TextCell(), (CellList.Resources)WizardCellListResources.INSTANCE);
        this.chosenPatternWidget = new MinimumWidthCellList((Cell)new PatternCell(validator), (CellList.Resources)WizardCellListResources.INSTANCE);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.initialiseAvailableTypes();
        this.initialiseChosenPatterns();
        this.initialiseBinding();
        this.initialiseEntryPoint();
        this.initialiseCEPWindow();
        this.initialiseShufflers();
    }

    private void initialiseAvailableTypes() {
        this.availableTypesContainer.add((Widget)this.availableTypesWidget);
        this.availableTypesWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.availableTypesWidget.setMinimumWidth(275);
        Label lstEmpty = new Label(Constants.INSTANCE.DecisionTableWizardNoAvailablePatterns());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.availableTypesWidget.setEmptyListWidget((Widget)lstEmpty);
        MultiSelectionModel selectionModel = new MultiSelectionModel();
        this.availableTypesWidget.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initialiseChosenPatterns() {
        this.chosenPatternsContainer.add((Widget)this.chosenPatternWidget);
        this.chosenPatternWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.chosenPatternWidget.setMinimumWidth(275);
        Label lstEmpty = new Label(Constants.INSTANCE.DecisionTableWizardNoChosenPatterns());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.chosenPatternWidget.setEmptyListWidget((Widget)lstEmpty);
        MultiSelectionModel selectionModel = new MultiSelectionModel();
        this.chosenPatternWidget.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void validateBinding() {
        if (this.validator.isPatternBindingUnique(this.chosenPatternSelection)) {
            this.bindingContainer.setStyleName(WizardResources.INSTANCE.style().wizardDTableFieldContainerValid());
        } else {
            this.bindingContainer.setStyleName(WizardResources.INSTANCE.style().wizardDTableFieldContainerInvalid());
        }
    }

    private void enableMoveUpButton() {
        if (this.chosenPatterns == null || this.chosenPatternSelection == null) {
            this.btnMoveUp.setEnabled(false);
            return;
        }
        int index = this.chosenPatterns.indexOf(this.chosenPatternSelection);
        this.btnMoveUp.setEnabled(index > 0);
    }

    private void enableMoveDownButton() {
        if (this.chosenPatterns == null || this.chosenPatternSelection == null) {
            this.btnMoveDown.setEnabled(false);
            return;
        }
        int index = this.chosenPatterns.indexOf(this.chosenPatternSelection);
        this.btnMoveDown.setEnabled(index < this.chosenPatterns.size() - 1);
    }

    private void initialiseBinding() {
        this.txtBinding.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initialiseEntryPoint() {
        this.txtEntryPoint.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initialiseCEPWindow() {
        this.ddCEPWindow.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initialiseShufflers() {
        this.btnMoveUp.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.btnMoveDown.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setAvailableFactTypes(List<String> types) {
        this.availableTypesWidget.setRowCount(types.size(), true);
        this.availableTypesWidget.setRowData(types);
    }

    public void setChosenPatterns(List<Pattern52> types) {
        this.chosenPatterns = types;
        this.chosenPatternWidget.setRowCount(types.size(), true);
        this.chosenPatternWidget.setRowData(types);
        this.enableMoveUpButton();
        this.enableMoveDownButton();
        this.presenter.stateChanged();
    }

    public void setPresenter(FactPatternsPageView.Presenter presenter) {
        this.presenter = presenter;
    }

    public void setArePatternBindingsUnique(boolean arePatternBindingsUnique) {
        this.msgDuplicateBindings.setVisible(!arePatternBindingsUnique);
        this.chosenPatternWidget.redraw();
    }

    @UiHandler(value={"btnAdd"})
    public void btnAddClick(ClickEvent event) {
        for (String type : this.availableTypesSelections) {
            Pattern52 pattern = new Pattern52();
            pattern.setFactType(type);
            this.chosenPatterns.add(pattern);
        }
        this.setChosenPatterns(this.chosenPatterns);
        this.presenter.setConditionPatterns(this.chosenPatterns);
        this.presenter.stateChanged();
    }

    @UiHandler(value={"btnRemove"})
    public void btnRemoveClick(ClickEvent event) {
        for (Pattern52 pattern : this.chosenPatternSelections) {
            this.chosenPatterns.remove(pattern);
            this.presenter.signalRemovalOfPattern(pattern);
        }
        this.chosenPatternSelections.clear();
        this.setChosenPatterns(this.chosenPatterns);
        this.presenter.setConditionPatterns(this.chosenPatterns);
        this.presenter.stateChanged();
        this.txtBinding.setText("");
        this.txtBinding.setEnabled(false);
        this.txtEntryPoint.setText("");
        this.txtEntryPoint.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.patternDefinition.setVisible(false);
    }

    static /* synthetic */ Set access$002(FactPatternsPageViewImpl x0, Set x1) {
        x0.availableTypesSelections = x1;
        return x0.availableTypesSelections;
    }

    static /* synthetic */ Set access$000(FactPatternsPageViewImpl x0) {
        return x0.availableTypesSelections;
    }

    static /* synthetic */ Set access$102(FactPatternsPageViewImpl x0, Set x1) {
        x0.chosenPatternSelections = x1;
        return x0.chosenPatternSelections;
    }

    static /* synthetic */ Set access$100(FactPatternsPageViewImpl x0) {
        return x0.chosenPatternSelections;
    }

    static /* synthetic */ Pattern52 access$202(FactPatternsPageViewImpl x0, Pattern52 x1) {
        x0.chosenPatternSelection = x1;
        return x0.chosenPatternSelection;
    }

    static /* synthetic */ void access$300(FactPatternsPageViewImpl x0) {
        x0.validateBinding();
    }

    static /* synthetic */ Pattern52 access$200(FactPatternsPageViewImpl x0) {
        return x0.chosenPatternSelection;
    }

    static /* synthetic */ void access$400(FactPatternsPageViewImpl x0) {
        x0.enableMoveUpButton();
    }

    static /* synthetic */ void access$500(FactPatternsPageViewImpl x0) {
        x0.enableMoveDownButton();
    }

    static /* synthetic */ FactPatternsPageView.Presenter access$600(FactPatternsPageViewImpl x0) {
        return x0.presenter;
    }

    static /* synthetic */ List access$700(FactPatternsPageViewImpl x0) {
        return x0.chosenPatterns;
    }
}

