/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.converters.decisiontable.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.guvnor.server.converters.decisiontable.builders.ParameterUtilities;
import org.drools.guvnor.server.converters.decisiontable.builders.ParameterizedValueBuilder;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;

public class IndexedParametersValueBuilder
implements ParameterizedValueBuilder {
    private static final Pattern delimiter = Pattern.compile("(.*?[^\\\\])(,|\\z)");
    private final String template;
    private final List<String> parameters = new ArrayList();
    private List<List<DTCellValue52>> values = new ArrayList();

    public IndexedParametersValueBuilder(String template, ParameterUtilities parameterUtilities) {
        this.template = parameterUtilities.convertIndexedParametersToTemplateKeys(template);
        this.parameters.addAll(parameterUtilities.extractTemplateKeys(this.template));
    }

    public void addCellValue(int row, int column, String value) {
        List cellVals = this.split(value);
        ArrayList<DTCellValue52> rowValues = new ArrayList<DTCellValue52>();
        for (int parameterIndex = 0; parameterIndex < this.getParameters().size(); ++parameterIndex) {
            rowValues.add(new DTCellValue52((String)cellVals.get(parameterIndex)));
        }
        this.values.add(rowValues);
    }

    private List<String> split(String input) {
        Matcher m = delimiter.matcher(input);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group(1).replaceAll("\\\\,", ","));
        }
        return result;
    }

    public String getTemplate() {
        return this.template;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public List<List<DTCellValue52>> getColumnData() {
        return this.values;
    }
}

