/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.serviceconfig;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ProtocolOption;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKBaseConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKSessionConfig;
import org.drools.guvnor.client.rpc.MavenArtifact;
import org.junit.Assert;
import org.junit.Test;

public class ServiceConfigTest {
    final Collection<MavenArtifact> excludedArtifacts = new ArrayList<MavenArtifact>(){
        {
            this.add(new MavenArtifact("org.drools:knowledge-api:jar:5.5.0-SNAPSHOT:compile"));
            this.add(new MavenArtifact("org.drools:knowledge-api:jar:5.5.0-SNAPSHOT:compile"));
            this.add(new MavenArtifact("org.apache.camel:camel-core:test-jar:tests:2.4.0:test"));
        }
    };
    final Collection<ServiceKBaseConfig> kbases = new ArrayList<ServiceKBaseConfig>(){
        {
            this.add(new ServiceKBaseConfig("kbase1"));
            this.add(new ServiceKBaseConfig("kbase1"));
            this.add(new ServiceKBaseConfig("kbase2"));
        }
    };

    @Test
    public void testNullConstructor() {
        ServiceConfig serviceConfig = new ServiceConfig(null, null, null);
        Assert.assertNull((Object)serviceConfig.getPollingFrequency());
        Assert.assertNotNull((Object)serviceConfig.getKbases());
        Assert.assertNotNull((Object)serviceConfig.getExcludedArtifacts());
        Assert.assertEquals((long)0L, (long)serviceConfig.getKbases().size());
        Assert.assertEquals((long)0L, (long)serviceConfig.getExcludedArtifacts().size());
        Assert.assertEquals((Object)serviceConfig, (Object)new ServiceConfig(null, null, null));
        Assert.assertTrue((serviceConfig.hashCode() == new ServiceConfig(null, null, null).hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((Object)serviceConfig, (Object)new ServiceConfig(serviceConfig));
        Assert.assertTrue((serviceConfig.hashCode() == new ServiceConfig(serviceConfig).hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testConstructor() {
        ServiceConfig serviceConfig = new ServiceConfig("70", this.excludedArtifacts, this.kbases);
        Assert.assertEquals((Object)new Integer(70), (Object)serviceConfig.getPollingFrequency());
        Assert.assertNotNull((Object)serviceConfig.getKbases());
        Assert.assertNotNull((Object)serviceConfig.getExcludedArtifacts());
        Assert.assertEquals((long)2L, (long)serviceConfig.getKbases().size());
        Assert.assertEquals((long)2L, (long)serviceConfig.getExcludedArtifacts().size());
        Assert.assertFalse((boolean)serviceConfig.equals((Object)new ServiceConfig(null, null, null)));
        Assert.assertFalse((serviceConfig.hashCode() == new ServiceConfig(null, null, null).hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((Object)serviceConfig, (Object)new ServiceConfig(serviceConfig));
        Assert.assertTrue((serviceConfig.hashCode() == new ServiceConfig(serviceConfig).hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        ServiceConfig serviceConfig = new ServiceConfig("71", this.excludedArtifacts, this.kbases);
        Assert.assertFalse((boolean)serviceConfig.equals((Object)new ServiceConfig("70", this.excludedArtifacts, this.kbases)));
        Assert.assertFalse((serviceConfig.hashCode() == new ServiceConfig("70", this.excludedArtifacts, this.kbases).hashCode() ? 1 : 0) != 0);
        serviceConfig = new ServiceConfig("70", this.excludedArtifacts, this.kbases);
        serviceConfig.removeExcludedArtifact(new MavenArtifact("org.drools:knowledge-api:jar:5.5.0-SNAPSHOT:compile"));
        Assert.assertFalse((boolean)serviceConfig.equals((Object)new ServiceConfig("70", this.excludedArtifacts, this.kbases)));
        Assert.assertFalse((serviceConfig.hashCode() == new ServiceConfig("70", this.excludedArtifacts, this.kbases).hashCode() ? 1 : 0) != 0);
        serviceConfig = new ServiceConfig("70", this.excludedArtifacts, this.kbases);
        serviceConfig.removeKBase("kbase2");
        Assert.assertFalse((boolean)serviceConfig.equals((Object)new ServiceConfig("70", this.excludedArtifacts, this.kbases)));
        Assert.assertFalse((serviceConfig.hashCode() == new ServiceConfig("70", this.excludedArtifacts, this.kbases).hashCode() ? 1 : 0) != 0);
        serviceConfig = new ServiceConfig("70", this.excludedArtifacts, this.kbases);
        serviceConfig.setPollingFrequency(71);
        Assert.assertFalse((boolean)serviceConfig.equals((Object)new ServiceConfig("70", this.excludedArtifacts, this.kbases)));
        Assert.assertFalse((serviceConfig.hashCode() == new ServiceConfig("70", this.excludedArtifacts, this.kbases).hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((Object)serviceConfig, (Object)serviceConfig);
        Assert.assertFalse((boolean)serviceConfig.equals(null));
        Assert.assertFalse((boolean)serviceConfig.equals((Object)"??"));
    }

    @Test
    public void testAddRemoveExcludedArtifacts() {
        ServiceConfig serviceConfig = new ServiceConfig(null, null, null);
        serviceConfig.addExcludedArtifact(new MavenArtifact("org.drools:knowledge-api:jar:5.5.0-SNAPSHOT:compile"));
        serviceConfig.addExcludedArtifact(new MavenArtifact("org.drools:knowledge-api:jar:5.5.0-SNAPSHOT:compile"));
        serviceConfig.addExcludedArtifact(null);
        Assert.assertEquals((long)1L, (long)serviceConfig.getExcludedArtifacts().size());
        serviceConfig.removeExcludedArtifact(new MavenArtifact("org.drools:knowledge-api:jar:5.5.0-SNAPSHOT:compile"));
        Assert.assertEquals((long)0L, (long)serviceConfig.getExcludedArtifacts().size());
        serviceConfig.setExcludedArtifacts(this.excludedArtifacts);
        serviceConfig.setExcludedArtifacts(null);
        Assert.assertEquals((long)2L, (long)serviceConfig.getExcludedArtifacts().size());
        serviceConfig.removeExcludedArtifact(new MavenArtifact("org.drools:knowledge-api:jar:5.5.0-SNAPSHOT:compile"));
        serviceConfig.removeExcludedArtifact(new MavenArtifact("org.drools:knowledge-aaaapi:jar:5.5.0-SNAPSHOT:compile"));
        serviceConfig.removeExcludedArtifact(null);
        Assert.assertEquals((long)1L, (long)serviceConfig.getExcludedArtifacts().size());
        serviceConfig.setExcludedArtifacts(new ArrayList());
        Assert.assertEquals((long)0L, (long)serviceConfig.getExcludedArtifacts().size());
        serviceConfig.addExcludedArtifact(new MavenArtifact("org.drools:knowledge-aaaapi:jar:5.5.0-SNAPSHOT:compile"));
        serviceConfig.addExcludedArtifacts(this.excludedArtifacts);
        serviceConfig.addExcludedArtifacts(new ArrayList());
        serviceConfig.addExcludedArtifacts(null);
        Assert.assertEquals((long)3L, (long)serviceConfig.getExcludedArtifacts().size());
        serviceConfig.removeExcludedArtifacts(this.excludedArtifacts);
        serviceConfig.removeExcludedArtifacts(new ArrayList());
        serviceConfig.removeExcludedArtifacts(null);
        Assert.assertEquals((long)1L, (long)serviceConfig.getExcludedArtifacts().size());
    }

    @Test
    public void testAddRemoveKBases() {
        ServiceConfig serviceConfig = new ServiceConfig(null, null, null);
        serviceConfig.addKBase(new ServiceKBaseConfig("kbase1"));
        serviceConfig.addKBase(null);
        Assert.assertEquals((long)1L, (long)serviceConfig.getKbases().size());
        Assert.assertEquals((Object)serviceConfig.getKbase("kbase1"), (Object)new ServiceKBaseConfig("kbase1"));
        Assert.assertNull((Object)serviceConfig.getKbase("kbase2"));
        Assert.assertNull((Object)serviceConfig.getKbase(""));
        Assert.assertNull((Object)serviceConfig.getKbase(null));
        serviceConfig.addKBase(new ServiceKBaseConfig("kbase2"));
        serviceConfig.addKBase(new ServiceKBaseConfig("kbase3"));
        Assert.assertEquals((long)3L, (long)serviceConfig.getKbases().size());
        serviceConfig.removeKBase("kbase3");
        serviceConfig.removeKBase("sss");
        serviceConfig.removeKBase("");
        serviceConfig.removeKBase(null);
        Assert.assertEquals((long)2L, (long)serviceConfig.getKbases().size());
    }

    @Test
    public void testNextKBaseName() {
        ServiceConfig serviceConfig = new ServiceConfig(null, null, null);
        Assert.assertEquals((Object)"kbase1", (Object)serviceConfig.getNextKBaseName());
        Assert.assertEquals((Object)"kbase1", (Object)serviceConfig.getNextKBaseName());
        serviceConfig.addKBase(new ServiceKBaseConfig("kbase1"));
        serviceConfig.addKBase(new ServiceKBaseConfig("kbase3"));
        Assert.assertEquals((Object)"kbase2", (Object)serviceConfig.getNextKBaseName());
        serviceConfig.addKBase(new ServiceKBaseConfig("kbase2"));
        Assert.assertEquals((Object)"kbase4", (Object)serviceConfig.getNextKBaseName());
    }

    @Test
    public void testHasProtocolReference() {
        ServiceConfig serviceConfig = new ServiceConfig(null, null, null);
        Assert.assertFalse((boolean)serviceConfig.hasProtocolReference(ProtocolOption.REST));
        Assert.assertFalse((boolean)serviceConfig.hasProtocolReference(ProtocolOption.WEB_SERVICE));
        ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
        ServiceKSessionConfig ksession1 = new ServiceKSessionConfig("ksession1");
        kbase1.addKsession(ksession1);
        serviceConfig.addKBase(kbase1);
        Assert.assertTrue((boolean)serviceConfig.hasProtocolReference(ProtocolOption.REST));
        Assert.assertFalse((boolean)serviceConfig.hasProtocolReference(ProtocolOption.WEB_SERVICE));
        ServiceKBaseConfig kbase2 = new ServiceKBaseConfig("kbase2");
        ServiceKSessionConfig ksession2 = new ServiceKSessionConfig("ksession2");
        ksession2.setProtocol(ProtocolOption.WEB_SERVICE);
        kbase2.addKsession(ksession2);
        serviceConfig.addKBase(kbase2);
        Assert.assertTrue((boolean)serviceConfig.hasProtocolReference(ProtocolOption.REST));
        Assert.assertTrue((boolean)serviceConfig.hasProtocolReference(ProtocolOption.WEB_SERVICE));
    }

    @Test
    public void testGetModels() {
        ServiceConfig serviceConfig = new ServiceConfig(null, null, null);
        Assert.assertEquals((long)0L, (long)serviceConfig.getModels().size());
        ServiceKBaseConfig kbase1 = new ServiceKBaseConfig("kbase1");
        ServiceKBaseConfig kbase2 = new ServiceKBaseConfig("kbase2");
        serviceConfig.addKBase(kbase1);
        serviceConfig.addKBase(kbase2);
        Assert.assertEquals((long)0L, (long)serviceConfig.getModels().size());
        kbase1.addModel(new AssetReference("a", "b", "c", "d", "e"));
        kbase1.addModel(new AssetReference("a2", "b2", "c2", "d2", "e2"));
        Assert.assertEquals((long)2L, (long)serviceConfig.getModels().size());
        kbase2.addModel(new AssetReference("a", "b", "c", "d", "e"));
        kbase2.addModel(new AssetReference("a4", "b4", "c4", "d4", "e4"));
        kbase2.addModel(new AssetReference("a5", "b5", "c5", "d5", "e5"));
        Assert.assertEquals((long)4L, (long)serviceConfig.getModels().size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnCopy() {
        new ServiceConfig(null);
    }

    @Test(expected=IllegalStateException.class)
    public void testPollingFrequencyNotNumeric() {
        new ServiceConfig("70a", this.excludedArtifacts, this.kbases);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddKBaseAlreadyExists() {
        ServiceConfig serviceConfig = new ServiceConfig(null, null, null);
        serviceConfig.addKBase(new ServiceKBaseConfig("kbase1"));
        serviceConfig.addKBase(new ServiceKBaseConfig("kbase1"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullOnHasProtocolReference() {
        ServiceConfig serviceConfig = new ServiceConfig(null, null, null);
        serviceConfig.hasProtocolReference(null);
    }
}

