/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa;

import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceController;
import java.util.List;
import org.drools.guvnor.client.explorer.AssetEditorPlace;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.qa.SummaryTable;
import org.drools.guvnor.client.explorer.navigation.qa.SummaryTableView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SummaryTableTest {
    private SummaryTable summaryTable;
    private SummaryTableView summaryTableView;
    private PlaceController placeController;

    @Before
    public void setUp() {
        this.summaryTableView = (SummaryTableView)Mockito.mock(SummaryTableView.class);
        ClientFactory clientFactory = (ClientFactory)Mockito.mock(ClientFactory.class);
        this.placeController = (PlaceController)Mockito.mock(PlaceController.class);
        Mockito.when((Object)clientFactory.getPlaceController()).thenReturn((Object)this.placeController);
        this.summaryTable = new SummaryTable(this.summaryTableView, clientFactory);
    }

    @Test
    public void emptyTable() throws Exception {
        ((SummaryTableView)Mockito.verify((Object)this.summaryTableView, (VerificationMode)Mockito.never())).addRow((SummaryTable.Row)Matchers.any());
    }

    @Test
    public void testGoTo() throws Exception {
        this.getPresenter().openTestScenario("uuid");
        ArgumentCaptor assetEditorPlaceArgumentCaptor = ArgumentCaptor.forClass(AssetEditorPlace.class);
        ((PlaceController)Mockito.verify((Object)this.placeController)).goTo((Place)assetEditorPlaceArgumentCaptor.capture());
        Assert.assertEquals((Object)((AssetEditorPlace)assetEditorPlaceArgumentCaptor.getValue()).getUuid(), (Object)"uuid");
    }

    @Test
    public void testSeveralRows() throws Exception {
        this.addRow("scenarioName1", "uuid1", "message1", 11, "WHITE");
        this.addRow("scenarioName2", "uuid2", "message2", 20, "YELLOW");
        this.addRow("scenarioName3", "uuid3", "message3", 33, "WHITE");
        ArgumentCaptor rowArgumentCaptor = ArgumentCaptor.forClass(SummaryTable.Row.class);
        ((SummaryTableView)Mockito.verify((Object)this.summaryTableView, (VerificationMode)Mockito.times((int)3))).addRow((SummaryTable.Row)rowArgumentCaptor.capture());
        List allValues = rowArgumentCaptor.getAllValues();
        this.assertContainsRow(allValues, "scenarioName1", "uuid1", "message1", 11, "WHITE");
        this.assertContainsRow(allValues, "scenarioName2", "uuid2", "message2", 20, "YELLOW");
        this.assertContainsRow(allValues, "scenarioName3", "uuid3", "message3", 33, "WHITE");
    }

    private void assertContainsRow(List<SummaryTable.Row> allValues, String scenarioName, String uuid, String message, int percentage, String backgroudColor) {
        boolean found = false;
        for (SummaryTable.Row row : allValues) {
            if (!row.getScenarioName().equals(scenarioName) || !row.getUuid().equals(uuid) || !row.getMessage().equals(message) || row.getPercentage() != percentage || !row.getBackgroundColor().equals(backgroudColor)) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }

    private void addRow(String scenarioName, String uuid, String message, int percentage, String backgroudColor) {
        SummaryTable.Row row = new SummaryTable.Row();
        row.setScenarioName(scenarioName);
        row.setUuid(uuid);
        row.setMessage(message);
        row.setPercentage(percentage);
        row.setBackgroundColor(backgroudColor);
        this.summaryTable.addRow(row);
    }

    @Test
    public void presenterIsSet() throws Exception {
        ((SummaryTableView)Mockito.verify((Object)this.summaryTableView)).setPresenter(this.getPresenter());
    }

    private SummaryTableView.Presenter getPresenter() {
        return this.summaryTable;
    }
}

