/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.ScenarioHelper;
import org.drools.ide.common.client.modeldriven.testing.CallFixtureMap;
import org.drools.ide.common.client.modeldriven.testing.CallMethod;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.client.modeldriven.testing.FixtureList;
import org.drools.ide.common.client.modeldriven.testing.RetractFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;
import org.junit.Assert;
import org.junit.Test;

public class ScenarioHelperTest {
    @Test
    public void testChunks() {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(new FactData("Q", "x", new ArrayList(), false));
        l.add(new FactData("Q", "y", new ArrayList(), false));
        l.add(new FactData("X", "a", new ArrayList(), false));
        l.add(new FactData("X", "b", new ArrayList(), false));
        l.add(new CallMethod("x", "hello"));
        l.add(new CallMethod("x", "helloItherWay"));
        l.add(new CallMethod("v", "helloAgain"));
        ExecutionTrace ex1 = new ExecutionTrace();
        l.add(ex1);
        l.add(new FactData("Z", "z", new ArrayList(), false));
        l.add(new FactData("Q", "x", new ArrayList(), true));
        l.add(new FactData("Q", "y", new ArrayList(), true));
        l.add(new RetractFact("y"));
        l.add(new CallMethod("x", "hello"));
        VerifyFact vf1 = new VerifyFact();
        VerifyFact vf2 = new VerifyFact();
        VerifyRuleFired vr1 = new VerifyRuleFired();
        VerifyRuleFired vr2 = new VerifyRuleFired();
        l.add(vf1);
        l.add(vf2);
        l.add(vr1);
        l.add(vr2);
        ExecutionTrace ex2 = new ExecutionTrace();
        l.add(ex2);
        VerifyFact vf3 = new VerifyFact();
        l.add(vf3);
        ScenarioHelper hlp = new ScenarioHelper();
        List fx = hlp.lumpyMap(l);
        Assert.assertEquals((long)9L, (long)fx.size());
        Map first = (Map)fx.get(0);
        Assert.assertEquals((long)2L, (long)first.size());
        List fdl = (List)first.get("Q");
        Assert.assertEquals((long)2L, (long)fdl.size());
        FactData fd = (FactData)fdl.get(0);
        Assert.assertEquals((Object)"x", (Object)fd.getName());
        fd = (FactData)fdl.get(1);
        Assert.assertEquals((Object)"y", (Object)fd.getName());
        fdl = (List)first.get("X");
        Assert.assertEquals((long)2L, (long)fdl.size());
        fd = (FactData)fdl.get(0);
        Assert.assertEquals((Object)"a", (Object)fd.getName());
        CallFixtureMap callMap = (CallFixtureMap)fx.get(1);
        Assert.assertEquals((long)2L, (long)callMap.size());
        Assert.assertTrue((boolean)callMap.containsKey((Object)"x"));
        FixtureList lcall1 = (FixtureList)callMap.get((Object)"x");
        CallMethod c1 = (CallMethod)lcall1.get(0);
        Assert.assertTrue((boolean)c1.getVariable().equals("x"));
        Assert.assertTrue((boolean)c1.getMethodName().equals("hello"));
        CallMethod c2 = (CallMethod)lcall1.get(1);
        Assert.assertTrue((boolean)c2.getVariable().equals("x"));
        Assert.assertTrue((boolean)c2.getMethodName().equals("helloItherWay"));
        Assert.assertTrue((boolean)callMap.containsKey((Object)"v"));
        FixtureList lcall2 = (FixtureList)callMap.get((Object)"v");
        CallMethod c3 = (CallMethod)lcall2.get(0);
        Assert.assertTrue((boolean)c3.getVariable().equals("v"));
        Assert.assertTrue((boolean)c3.getMethodName().equals("helloAgain"));
        Assert.assertEquals((Object)ex1, fx.get(2));
        List ruleFired = (List)fx.get(3);
        Assert.assertEquals((long)2L, (long)ruleFired.size());
        Assert.assertEquals((Object)vr1, ruleFired.get(0));
        Assert.assertEquals((Object)vr2, ruleFired.get(1));
        List verifyFact = (List)fx.get(4);
        Assert.assertEquals((long)2L, (long)verifyFact.size());
        Assert.assertEquals((Object)vf1, verifyFact.get(0));
        Assert.assertEquals((Object)vf2, verifyFact.get(1));
        Map second = (Map)fx.get(5);
        Assert.assertEquals((long)3L, (long)second.size());
        Assert.assertTrue((boolean)second.containsKey("Z"));
        Assert.assertTrue((boolean)second.containsKey("Q"));
        fdl = (List)second.get("Q");
        Assert.assertEquals((long)2L, (long)fdl.size());
        Assert.assertTrue((boolean)second.containsKey("retract"));
        List retracts = (List)second.get("retract");
        Assert.assertEquals((long)1L, (long)retracts.size());
        RetractFact ret = (RetractFact)retracts.get(0);
        Assert.assertEquals((Object)"y", (Object)ret.getName());
        CallFixtureMap third = (CallFixtureMap)fx.get(6);
        Assert.assertEquals((long)1L, (long)third.size());
        Assert.assertTrue((boolean)third.containsKey((Object)"x"));
        FixtureList lcall3 = (FixtureList)third.get((Object)"x");
        CallMethod c4 = (CallMethod)lcall3.get(0);
        Assert.assertTrue((boolean)c4.getVariable().equals("x"));
        Assert.assertTrue((boolean)c4.getMethodName().equals("hello"));
        Assert.assertEquals((Object)ex2, fx.get(7));
        List last = (List)fx.get(8);
        Assert.assertEquals((long)1L, (long)last.size());
        Assert.assertEquals((Object)vf3, last.get(0));
    }

    @Test
    public void testGlobals() {
        ArrayList<FactData> l = new ArrayList<FactData>();
        l.add(new FactData("X", "d", new ArrayList(), true));
        l.add(new FactData("X", "c", new ArrayList(), true));
        l.add(new FactData("Q", "a", new ArrayList(), true));
        l.add(new FactData("Q", "b", new ArrayList(), true));
        ScenarioHelper hlp = new ScenarioHelper();
        Map m = hlp.lumpyMapGlobals(l);
        Assert.assertEquals((long)2L, (long)m.size());
        List fd = (List)m.get("X");
        Assert.assertEquals((long)2L, (long)fd.size());
        Assert.assertEquals((Object)"d", (Object)((FactData)fd.get(0)).getName());
        Assert.assertEquals((Object)"c", (Object)((FactData)fd.get(1)).getName());
        fd = (List)m.get("Q");
        Assert.assertEquals((long)2L, (long)fd.size());
        Assert.assertEquals((Object)"a", (Object)((FactData)fd.get(0)).getName());
        Assert.assertEquals((Object)"b", (Object)((FactData)fd.get(1)).getName());
    }

    @Test
    public void testRemoveField() {
        ArrayList<FieldData> fieldData = new ArrayList<FieldData>();
        fieldData.add(new FieldData("q", "1"));
        fieldData.add(new FieldData("w", "2"));
        FactData fd = new FactData("X", "x", fieldData, false);
        ArrayList<FieldData> fieldData2 = new ArrayList<FieldData>();
        fieldData2.add(new FieldData("q", "3"));
        fieldData2.add(new FieldData("w", "4"));
        fieldData2.add(new FieldData("x", "5"));
        FactData fd2 = new FactData("X", "x", fieldData2, false);
        ArrayList<FactData> factData = new ArrayList<FactData>();
        factData.add(fd);
        factData.add(fd2);
        ScenarioHelper.removeFields(factData, (String)"q");
        Assert.assertEquals((long)2L, (long)factData.size());
        Assert.assertEquals((long)1L, (long)fieldData.size());
        Assert.assertEquals((Object)"w", (Object)((FieldData)fieldData.get(0)).getName());
        Assert.assertEquals((long)2L, (long)fieldData2.size());
        Assert.assertEquals((Object)"w", (Object)((FieldData)fieldData2.get(0)).getName());
    }

    @Test
    public void testEmptyMap() {
        ArrayList<Object> fl = new ArrayList<Object>();
        fl.add(new FactData());
        fl.add(new ExecutionTrace());
        fl.add(new ExecutionTrace());
        ScenarioHelper hlp = new ScenarioHelper();
        List r = hlp.lumpyMap(fl);
        Assert.assertEquals((long)6L, (long)r.size());
        Assert.assertTrue((boolean)(r.get(0) instanceof Map));
        Assert.assertTrue((boolean)(r.get(1) instanceof Map));
        Assert.assertTrue((boolean)(r.get(2) instanceof ExecutionTrace));
        Assert.assertTrue((boolean)(r.get(3) instanceof Map));
        Assert.assertTrue((boolean)(r.get(4) instanceof Map));
        Assert.assertTrue((boolean)(r.get(5) instanceof ExecutionTrace));
        Map r_ = (Map)r.get(3);
        Assert.assertEquals((long)0L, (long)r_.size());
        r_ = (Map)r.get(4);
        Assert.assertEquals((long)0L, (long)r_.size());
        r_ = (Map)r.get(0);
        Assert.assertEquals((long)1L, (long)r_.size());
        r_ = (Map)r.get(1);
        Assert.assertEquals((long)0L, (long)r_.size());
    }
}

