/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.DefaultContentHandler;
import org.drools.guvnor.server.contenthandler.ModelContentHandler;
import org.drools.guvnor.server.contenthandler.drools.BRLContentHandler;
import org.drools.guvnor.server.contenthandler.drools.DRLFileContentHandler;
import org.drools.guvnor.server.contenthandler.drools.DSLDefinitionContentHandler;
import org.drools.guvnor.server.contenthandler.drools.DSLRuleContentHandler;
import org.drools.guvnor.server.contenthandler.drools.DecisionTableXLSHandler;
import org.drools.guvnor.server.contenthandler.drools.EnumerationContentHandler;
import org.drools.guvnor.server.contenthandler.drools.FactModelContentHandler;
import org.drools.guvnor.server.contenthandler.drools.GuidedDTContentHandler;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.server.util.GuidedDTXMLPersistence;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.junit.Assert;
import org.junit.Test;

public class ContentHandlerIntegrationTest
extends GuvnorIntegrationTest {
    @Test
    public void testContentFormat() {
        Assert.assertTrue((boolean)(ContentManager.getHandler((String)"drl") instanceof DRLFileContentHandler));
        Assert.assertTrue((boolean)(ContentManager.getHandler((String)"dsl") instanceof DSLDefinitionContentHandler));
        Assert.assertTrue((boolean)(ContentManager.getHandler((String)"dslr") instanceof DSLRuleContentHandler));
        Assert.assertTrue((boolean)(ContentManager.getHandler((String)"brl") instanceof BRLContentHandler));
        Assert.assertTrue((boolean)(ContentManager.getHandler((String)"xls") instanceof DecisionTableXLSHandler));
        Assert.assertTrue((boolean)(ContentManager.getHandler((String)"enumeration") instanceof EnumerationContentHandler));
        Assert.assertTrue((boolean)(ContentManager.getHandler((String)"gdst") instanceof GuidedDTContentHandler));
        Assert.assertTrue((boolean)(ContentManager.getHandler((String)"model.drl") instanceof FactModelContentHandler));
        Assert.assertTrue((boolean)(ContentManager.getHandler((String)"XXX") instanceof DefaultContentHandler));
    }

    @Test
    public void testRuleAssetType() {
        Assert.assertTrue((boolean)ContentManager.getHandler((String)"drl").isRuleAsset());
        Assert.assertTrue((boolean)ContentManager.getHandler((String)"dslr").isRuleAsset());
        Assert.assertTrue((boolean)ContentManager.getHandler((String)"brl").isRuleAsset());
        Assert.assertTrue((boolean)ContentManager.getHandler((String)"xls").isRuleAsset());
        Assert.assertTrue((boolean)ContentManager.getHandler((String)"gdst").isRuleAsset());
        Assert.assertFalse((boolean)ContentManager.getHandler((String)"model.drl").isRuleAsset());
        Assert.assertFalse((boolean)ContentManager.getHandler((String)"dsl").isRuleAsset());
        Assert.assertFalse((boolean)ContentManager.getHandler((String)"jar").isRuleAsset());
        Assert.assertFalse((boolean)ContentManager.getHandler((String)"enumeration").isRuleAsset());
    }

    @Test
    public void testValidating() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.loadDefaultModule();
        AssetItem asset = pkg.addAsset("testValidatingEnum", "");
        asset.updateFormat("enumeration");
        asset.updateContent("'Person.age' : [1, 2, 3]");
        EnumerationContentHandler ch = new EnumerationContentHandler();
        BuilderResult result = ch.validateAsset(asset);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getLines().size());
        asset.updateContent("goober boy");
        result = ch.validateAsset(asset);
        Assert.assertFalse((result.getLines().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)asset.getName(), (Object)((BuilderResultLine)result.getLines().get(0)).getAssetName());
        Assert.assertEquals((Object)asset.getFormat(), (Object)((BuilderResultLine)result.getLines().get(0)).getAssetFormat());
        Assert.assertNotNull((Object)((BuilderResultLine)result.getLines().get(0)).getMessage());
        Assert.assertEquals((Object)asset.getUUID(), (Object)((BuilderResultLine)result.getLines().get(0)).getUuid());
    }

    @Test
    public void testEmptyDT() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.loadDefaultModule();
        AssetItem asset = pkg.addAsset("testEmptyDT", "");
        asset.updateFormat("gdst");
        GuidedDecisionTable52 gt = new GuidedDecisionTable52();
        asset.updateContent(GuidedDTXMLPersistence.getInstance().marshal(gt));
        asset.checkin("");
        GuidedDTContentHandler ch = new GuidedDTContentHandler();
        ch.compile(null, asset, null);
    }

    @Test
    public void testNameConvertion() {
        Assert.assertEquals((Object)"com.foo.Bar", (Object)ModelContentHandler.convertPathToName((String)"com/foo/Bar.class"));
    }
}

