/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import org.drools.guvnor.server.contenthandler.drools.DRLFileContentHandler;
import org.junit.Assert;
import org.junit.Test;

public class DRLFileContentHandlerTest {
    @Test
    public void testSniffDRLType() throws Exception {
        String classic = "package foobar \n rule boo \n when \n then\n end \n rule boo2 \n when \n then\n end";
        String moreRuleClassic = "\nrule bar \n when \n then \n end\nrule x \n when \n then \n end ";
        String newRule = "agenda-group 'x' \n when \n then \n";
        String moreSingle = "rule foo when then end";
        String query = "query FooBar\nend";
        String moreNewRule = "agenda-group 'x' \n when end.bar \n then rule.end.bar";
        String emptyRule = "";
        String complex = "//some comments about the rule \n//here\n when \n //goo \n foo.bar \n then \n //goo \n end.bar";
        Assert.assertTrue((boolean)DRLFileContentHandler.isStandAloneRule((String)newRule));
        Assert.assertFalse((boolean)DRLFileContentHandler.isStandAloneRule((String)moreRuleClassic));
        Assert.assertFalse((boolean)DRLFileContentHandler.isStandAloneRule((String)classic));
        Assert.assertFalse((boolean)DRLFileContentHandler.isStandAloneRule((String)moreSingle));
        Assert.assertFalse((boolean)DRLFileContentHandler.isStandAloneRule(null));
        Assert.assertFalse((boolean)DRLFileContentHandler.isStandAloneRule((String)emptyRule));
        Assert.assertTrue((boolean)DRLFileContentHandler.isStandAloneRule((String)moreNewRule));
        Assert.assertTrue((boolean)DRLFileContentHandler.isStandAloneRule((String)complex));
        Assert.assertFalse((boolean)DRLFileContentHandler.isStandAloneRule((String)query));
    }

    @Test
    public void testRuleWithDialect() {
        String rule = "rule \"DemoRule\" \n     salience 10 \n    dialect \"mvel\" \n  when \n Driver( age > 65 ) \n then \n insert(new Rejection(\" too old \"));end ";
        Assert.assertFalse((boolean)DRLFileContentHandler.isStandAloneRule((String)rule));
        Assert.assertFalse((boolean)DRLFileContentHandler.isStandAloneRule((String)""));
    }

    @Test
    public void testStandAlone() throws Exception {
        String rule = "when \nFoo()\nthen\n\tbar()";
        DRLFileContentHandler h = new DRLFileContentHandler();
        Assert.assertTrue((boolean)DRLFileContentHandler.isStandAloneRule((String)rule));
        String r = h.wrapRuleDeclaration("whee", "", rule);
        Assert.assertTrue((r.indexOf("rule 'whee'") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((r.indexOf("dialect 'mvel'") > -1 ? 1 : 0) != 0);
        rule = "dialect 'java'\nwhen \nFoo()\nthen\n\tbar()";
        r = h.wrapRuleDeclaration("whee", null, rule);
        Assert.assertTrue((r.indexOf("rule 'whee'") > -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)r.indexOf("dialect 'mvel'"));
        Assert.assertTrue((r.indexOf("dialect 'java'") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testStandAloneWithExtends() throws Exception {
        String rule = "when \nFoo()\nthen\n\tbar()";
        DRLFileContentHandler h = new DRLFileContentHandler();
        Assert.assertTrue((boolean)DRLFileContentHandler.isStandAloneRule((String)rule));
        String r = h.wrapRuleDeclaration("whee", "parentRule", rule);
        Assert.assertTrue((r.indexOf("extends parentRule") > -1 ? 1 : 0) != 0);
        rule = "dialect 'java'\nwhen \nFoo()\nthen\n\tbar()";
        r = h.wrapRuleDeclaration("whee", "", rule);
        Assert.assertTrue((r.indexOf("extends") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRuleWithRuleFlowGroup() {
        String rule = "rule \"DemoRule\" \n     ruleflow-group \"name-of-ruleflow\"  \n    dialect \"mvel\" \n  when \n Driver( age > 65 ) \n then \n insert(new Rejection(\" too old \"));end ";
        Assert.assertFalse((boolean)DRLFileContentHandler.isStandAloneRule((String)rule));
        rule = "    ruleflow-group \"name-of-ruleflow\"  \n    dialect \"mvel\" \n  when \n Driver( age > 65 ) \n then \n insert(new Rejection(\" too old \"));";
        Assert.assertTrue((boolean)DRLFileContentHandler.isStandAloneRule((String)rule));
    }
}

