/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import javax.inject.Inject;
import org.drools.guvnor.server.files.AuthorizationHeaderChecker;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.util.codec.Base64;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AuthorizationHeaderCheckerIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    private AuthorizationHeaderChecker authorizationHeaderChecker;

    public AuthorizationHeaderCheckerIntegrationTest() {
        this.autoLoginAsAdmin = false;
    }

    @Test
    public void testExecuteAllowUser() throws Exception {
        Assert.assertFalse((boolean)this.identity.isLoggedIn());
        String authToken = "admin:admin";
        String encodedAuthToken = "BASIC " + new String(Base64.encodeBase64((byte[])authToken.getBytes()));
        boolean allowed = this.authorizationHeaderChecker.loginByHeader(encodedAuthToken);
        Assert.assertTrue((boolean)allowed);
        Assert.assertTrue((boolean)this.identity.isLoggedIn());
        this.identity.logout();
        this.credentials.clear();
    }

    @Test
    public void testExecuteAllowUserNoBasicAuthenticationHeader() throws Exception {
        Assert.assertFalse((boolean)this.identity.isLoggedIn());
        boolean allowed = this.authorizationHeaderChecker.loginByHeader(null);
        Assert.assertFalse((boolean)allowed);
        Assert.assertFalse((boolean)this.identity.isLoggedIn());
    }

    @Test
    @Ignore
    public void testExecuteAllowUserNotBasicAuthenticationHeader() throws Exception {
        Assert.assertFalse((boolean)this.identity.isLoggedIn());
        String encodedAuthToken = "NON-Basic ";
        boolean allowed = this.authorizationHeaderChecker.loginByHeader(encodedAuthToken);
        Assert.assertTrue((boolean)allowed);
        Assert.assertTrue((boolean)this.identity.isLoggedIn());
    }

    @Test
    public void testUnpack() {
        String b42 = "BASIC " + new String(Base64.encodeBase64((byte[])"user:pass".getBytes()));
        String[] d = this.authorizationHeaderChecker.unpack(b42);
        Assert.assertEquals((Object)"user", (Object)d[0]);
        Assert.assertEquals((Object)"pass", (Object)d[1]);
    }
}

