/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.abdera.Abdera;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.io.IOUtils;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentConfiguration;
import org.drools.agent.KnowledgeAgentFactory;
import org.drools.agent.impl.PrintStreamSystemEventListener;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.rule.Rule;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.io.Resource;
import org.drools.io.ResourceChangeScannerConfiguration;
import org.drools.io.ResourceFactory;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.rule.Package;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;

public class PackageDeploymentServletChangeSetIntegrationTest
extends GuvnorIntegrationTest {
    public PackageDeploymentServletChangeSetIntegrationTest() {
        this.autoLoginAsAdmin = false;
    }

    @Test
    @InSequence(value=-1)
    public void startServers() throws Exception {
        ModuleItem pkgA = this.rulesRepository.createModule("applyChangeSetTwice", "this is package applyChangeSetTwice");
        AssetItem ruleA1 = pkgA.addAsset("ruleA1", "", null, "drl");
        ruleA1.updateContent("rule 'ruleA1' when org.drools.Person() then end");
        ruleA1.checkin("version 1");
        AssetItem ruleA2 = pkgA.addAsset("ruleA2", "", null, "drl");
        ruleA2.updateContent("rule 'ruleA2' when org.drools.Person() then end");
        ruleA2.checkin("version 1");
        this.repositoryPackageService.createModuleSnapshot(pkgA.getName(), "snapshotA1", false, "");
        ModuleItem pkgB = this.rulesRepository.createModule("scanForChangeInRepository", "this is package scanForChangeInRepository");
        AssetItem ruleB1 = pkgB.addAsset("ruleB1", "", null, "drl");
        ruleB1.updateContent("rule 'ruleA1' when org.drools.Person() then end");
        ruleB1.checkin("version 1");
        AssetItem ruleB2 = pkgB.addAsset("ruleB2", "", null, "drl");
        ruleB2.updateContent("rule 'ruleA2' when org.drools.Person() then end");
        ruleB2.checkin("version 1");
        this.repositoryPackageService.createModuleSnapshot(pkgB.getName(), "snapshotB1", false, "");
        ModuleItem pkgC = this.rulesRepository.createModule("downloadPackageWithHttpClientImpl", "this is package scanForChangeInRepository");
        AssetItem ruleC1 = pkgC.addAsset("ruleC1", "", null, "drl");
        ruleC1.updateContent("rule 'ruleA1' when org.drools.Person() then end");
        ruleC1.checkin("version 1");
        this.repositoryPackageService.createModuleSnapshot(pkgC.getName(), "snapshotC1", false, "");
        this.repositoryPackageService.rebuildPackages();
        this.repositoryPackageService.rebuildSnapshots();
    }

    @Test
    @RunAsClient
    public void applyChangeSetTwice(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "org.drools.guvnor.Guvnor/package/applyChangeSetTwice/LATEST/ChangeSet.xml");
        Resource res = ResourceFactory.newUrlResource((URL)url);
        KnowledgeAgentConfiguration conf = KnowledgeAgentFactory.newKnowledgeAgentConfiguration();
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("admin", "admin".toCharArray());
            }
        });
        KnowledgeAgent ka = KnowledgeAgentFactory.newKnowledgeAgent((String)"test", (KnowledgeAgentConfiguration)conf);
        System.out.println("Applying changeset, round #1");
        Thread.sleep(1000L);
        ka.applyChangeSet(res);
        for (KnowledgePackage pkg : ka.getKnowledgeBase().getKnowledgePackages()) {
            System.out.printf("  %s (%d)%n", pkg.getName(), pkg.getRules().size());
        }
        System.out.println("Applying changeset, round #2");
        Thread.sleep(1000L);
        ka.applyChangeSet(res);
        for (KnowledgePackage pkg : ka.getKnowledgeBase().getKnowledgePackages()) {
            System.out.printf("  %s (%d)%n", pkg.getName(), pkg.getRules().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @RunAsClient
    public void scanForChangeInRepository(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "org.drools.guvnor.Guvnor/package/scanForChangeInRepository/LATEST/ChangeSet.xml");
        Resource res = ResourceFactory.newUrlResource((URL)url);
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("admin", "admin".toCharArray());
            }
        });
        SystemEventListenerFactory.setSystemEventListener((SystemEventListener)new PrintStreamSystemEventListener(System.out));
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgentConfiguration conf = KnowledgeAgentFactory.newKnowledgeAgentConfiguration();
        conf.setProperty("drools.agent.newInstance", "true");
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"agent", (KnowledgeBase)kbase, (KnowledgeAgentConfiguration)conf);
        try {
            ResourceFactory.getResourceChangeNotifierService().start();
            ResourceFactory.getResourceChangeScannerService().start();
            ResourceChangeScannerConfiguration sconf = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
            sconf.setProperty("drools.resource.scanner.interval", "5");
            ResourceFactory.getResourceChangeScannerService().configure(sconf);
            kagent.applyChangeSet(res);
            kbase = kagent.getKnowledgeBase();
            Thread.sleep(1000L);
            Assert.assertEquals((long)2L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
            System.out.println("BUGZILLA 733008 total rules: " + ((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
            for (Rule r : ((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules()) {
                System.out.println(r.getName());
            }
            Abdera abdera = new Abdera();
            AbderaClient client = new AbderaClient(abdera);
            client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
            ClientResponse deleteResponse = client.delete(new URL(baseURL, "rest/packages/scanForChangeInRepository/assets/ruleB2").toExternalForm());
            Assert.assertEquals((long)204L, (long)deleteResponse.getStatus());
            ClientResponse binaryResponse = client.get(new URL(baseURL, "rest/packages/scanForChangeInRepository/binary").toExternalForm());
            Assert.assertEquals((long)200L, (long)binaryResponse.getStatus());
            Thread.sleep(6000L);
            kbase = kagent.getKnowledgeBase();
            Assert.assertEquals((long)1L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
        }
        finally {
            kagent.dispose();
            ResourceFactory.getResourceChangeNotifierService().stop();
            ResourceFactory.getResourceChangeScannerService().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @RunAsClient
    public void downloadPackageWithHttpClientImpl(@ArquillianResource URL baseURL) throws IOException, ClassNotFoundException {
        List<KnowledgePackage> kpkgs;
        block8: {
            URL url = new URL(baseURL, "org.drools.guvnor.Guvnor/package/downloadPackageWithHttpClientImpl/snapshotC1");
            Resource resource = ResourceFactory.newUrlResource((URL)url);
            KnowledgeAgentConfiguration conf = KnowledgeAgentFactory.newKnowledgeAgentConfiguration();
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication("admin", "admin".toCharArray());
                }
            });
            InputStream in = null;
            kpkgs = null;
            try {
                in = resource.getInputStream();
                Object object = DroolsStreamUtils.streamIn((InputStream)in);
                if (object instanceof Collection) {
                    kpkgs = (List<KnowledgePackage>)object;
                    break block8;
                }
                if (object instanceof KnowledgePackageImp) {
                    kpkgs = Collections.singletonList((KnowledgePackage)object);
                    break block8;
                }
                if (object instanceof Package) {
                    kpkgs = Collections.singletonList(new KnowledgePackageImp((Package)object));
                    break block8;
                }
                if (object instanceof Package[]) {
                    kpkgs = new ArrayList<KnowledgePackage>();
                    for (Package pkg : (Package[])object) {
                        kpkgs.add((KnowledgePackage)new KnowledgePackageImp(pkg));
                    }
                    break block8;
                }
                throw new RuntimeException("Unknown binary format trying to load resource " + resource.toString());
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        Assert.assertNotNull(kpkgs);
        Assert.assertFalse((boolean)kpkgs.isEmpty());
        Assert.assertNotNull(kpkgs.iterator().next());
    }
}

