/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import javax.inject.Inject;
import org.drools.guvnor.server.security.CategoryPathType;
import org.drools.guvnor.server.security.ModuleNameType;
import org.drools.guvnor.server.security.PathHelper;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleBasedPermissionManager;
import org.drools.guvnor.server.security.RoleBasedPermissionResolver;
import org.drools.guvnor.server.security.RoleBasedPermissionStore;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.security.WebDavPackageNameType;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RoleBasedPermissionResolverIntegrationTest
extends GuvnorIntegrationTest {
    private static final String USER_NAME = "roleBasedPermissionResolverUser";
    @Inject
    private RoleBasedPermissionStore roleBasedPermissionStore;
    @Inject
    private RoleBasedPermissionManager roleBasedPermissionManager;
    @Inject
    private RoleBasedPermissionResolver roleBasedPermissionResolver;

    public RoleBasedPermissionResolverIntegrationTest() {
        this.autoLoginAsAdmin = false;
    }

    @Before
    public void loginAsSpecificUser() {
        this.loginAs(USER_NAME);
    }

    @After
    public void logoutAsSpecificUser() {
        this.logoutAs(USER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCategoryBasedPermissionAnalyst() throws Exception {
        String package1Name = "testCategoryBasedPermissionAnalystPackageName1";
        String package2Name = "testCategoryBasedPermissionAnalystPackageName2";
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_ADMIN.getName(), package1Name, null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_READONLY.getName(), package2Name, null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, "category1"));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, "category2"));
        this.roleBasedPermissionManager.create();
        try {
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category1"), null));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category2"), null));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category3/category3"), null));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("/category1/category2"), null));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category2"), RoleType.ANALYST.getName()));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category2"), RoleType.ANALYST_READ.getName()));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category3/category3"), RoleType.ANALYST.getName()));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category3/category3"), RoleType.ANALYST_READ.getName()));
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCategoryBasedPermissionAnalystReadOnly() throws Exception {
        String package1Name = "testCategoryBasedPermissionAnalystPackageName1";
        String package2Name = "testCategoryBasedPermissionAnalystPackageName2";
        String categoryPath = "category1";
        String categoryPath2 = "category2";
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_ADMIN.getName(), package1Name, null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_READONLY.getName(), package2Name, null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST_READ.getName(), null, categoryPath));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, categoryPath2));
        this.roleBasedPermissionManager.create();
        try {
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType(categoryPath), null));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType(categoryPath2), null));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category3/category3"), null));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType(categoryPath), RoleType.ANALYST_READ.getName()));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType(categoryPath), RoleType.ANALYST.getName()));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType(categoryPath2), RoleType.ANALYST.getName()));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType(categoryPath2), RoleType.ANALYST_READ.getName()));
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCategoryBasedPermissionAnalystReadOnly2() throws Exception {
        String categoryPath = "category1";
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST_READ.getName(), null, categoryPath));
        this.roleBasedPermissionManager.create();
        try {
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType(categoryPath), RoleType.ANALYST_READ.getName()));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType(categoryPath), RoleType.ANALYST.getName()));
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    @Test
    public void testIsSubPath() {
        Assert.assertTrue((boolean)PathHelper.isSubPath((String)"foo", (String)"foo/bar"));
        Assert.assertTrue((boolean)PathHelper.isSubPath((String)"foo", (String)"/foo/bar"));
        Assert.assertTrue((boolean)PathHelper.isSubPath((String)"/foo/bar", (String)"/foo/bar"));
        Assert.assertFalse((boolean)PathHelper.isSubPath((String)"/foo/bar", (String)"foo"));
        Assert.assertTrue((boolean)PathHelper.isSubPath((String)"foo", (String)"foo/bar/baz"));
        Assert.assertTrue((boolean)PathHelper.isSubPath((String)"foo/bar", (String)"foo/bar/baz"));
        Assert.assertFalse((boolean)PathHelper.isSubPath((String)"wang", (String)"foo/bar/baz"));
        Assert.assertFalse((boolean)PathHelper.isSubPath((String)"wang/whee", (String)"foo/bar/baz"));
        Assert.assertFalse((boolean)PathHelper.isSubPath((String)"foo1", (String)"foo2"));
        Assert.assertTrue((boolean)PathHelper.isSubPath((String)"foo1", (String)"foo1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCategoryBasedSubPerms() throws Exception {
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST_READ.getName(), null, "category1/sub1"));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, "category2/sub1/sub2"));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, "category4"));
        this.roleBasedPermissionManager.create();
        try {
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category1"), null));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category2"), null));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category1"), RoleType.ANALYST_READ.getName()));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category2/sub1"), RoleType.ANALYST_READ.getName()));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category1"), RoleType.ANALYST.getName()));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category1/sub1"), RoleType.ANALYST_READ.getName()));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category2/sub1/sub2"), RoleType.ANALYST.getName()));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category2/sub1/sub2"), null));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category4"), "navigate"));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category1"), "navigate"));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category2"), "navigate"));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category1/sub1"), "navigate"));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category2/sub1"), "navigate"));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category1/sub1/sub2"), "navigate"));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category3"), "navigate"));
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPackageBasedPermissionAdmin() throws Exception {
        String package1Name = "testPackageBasedPermissionAdminPackageName1";
        String package2Name = "testPackageBasedPermissionAdminPackageName2";
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ADMIN.getName(), package1Name, null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_READONLY.getName(), package2Name, null));
        this.roleBasedPermissionManager.create();
        try {
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new ModuleNameType(package1Name), RoleType.ADMIN.getName()));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new ModuleNameType(package2Name), RoleType.ADMIN.getName()));
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPackageBasedPermissionPackageAdmin() throws Exception {
        String packageName = "testPackageBasedPermissionPackageAdminPackageName";
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_ADMIN.getName(), packageName, null));
        this.roleBasedPermissionManager.create();
        try {
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new ModuleNameType(packageName), RoleType.PACKAGE_ADMIN.getName()));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new ModuleNameType(packageName), RoleType.PACKAGE_DEVELOPER.getName()));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new ModuleNameType(packageName), RoleType.PACKAGE_READONLY.getName()));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)"47982482-7912-4881-97ec-e852494383d7", RoleType.PACKAGE_READONLY.getName()));
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPackageBasedWebDavPermissionPackageAdmin() throws Exception {
        String packageName = "testPackageBasedWebDavPermissionPackageAdmin";
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission("analyst", RoleType.ANALYST.getName(), packageName, null));
        this.roleBasedPermissionManager.create();
        try {
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new WebDavPackageNameType(packageName), RoleType.ANALYST.getName()));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new WebDavPackageNameType(packageName), RoleType.ANALYST_READ.getName()));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)"47982482-7912-4881-97ec-e852494383d7", RoleType.PACKAGE_READONLY.getName()));
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPackageBasedPermissionPackageDeveloper() throws Exception {
        String package1Name = "testPackageBasedPermissionPackageDeveloperPackageName1";
        String package2Name = "testPackageBasedPermissionPackageDeveloperPackageName2";
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_DEVELOPER.getName(), package1Name, null));
        this.roleBasedPermissionManager.create();
        try {
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new ModuleNameType(package1Name), RoleType.PACKAGE_ADMIN.getName()));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new ModuleNameType(package1Name), RoleType.PACKAGE_DEVELOPER.getName()));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new ModuleNameType(package1Name), RoleType.PACKAGE_READONLY.getName()));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)package2Name, RoleType.PACKAGE_READONLY.getName()));
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPackageBasedPermissionPackageReadOnly() throws Exception {
        String package1Name = "testPackageBasedPermissionPackageReadOnlyPackageName1";
        String package2Name = "testPackageBasedPermissionPackageReadOnlyPackageName2";
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_READONLY.getName(), package1Name, null));
        this.roleBasedPermissionManager.create();
        try {
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new ModuleNameType(package1Name), RoleType.PACKAGE_DEVELOPER.getName()));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new ModuleNameType(package1Name), RoleType.PACKAGE_DEVELOPER.getName()));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new ModuleNameType(package1Name), RoleType.PACKAGE_READONLY.getName()));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)package2Name, RoleType.PACKAGE_READONLY.getName()));
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPackageBasedPermissionAnalyst() throws Exception {
        String package1Name = "testPackageBasedPermissionAnalystPackageName1";
        String package2Name = "testPackageBasedPermissionAnalystPackageName2";
        this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(true);
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.PACKAGE_READONLY.getName(), package1Name, null));
        this.roleBasedPermissionStore.addRoleBasedPermissionForTesting(USER_NAME, new RoleBasedPermission(USER_NAME, RoleType.ANALYST.getName(), null, "category1"));
        this.roleBasedPermissionManager.create();
        try {
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new ModuleNameType(package1Name), RoleType.ANALYST.getName()));
            Assert.assertFalse((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new ModuleNameType(package2Name), RoleType.ANALYST.getName()));
            Assert.assertTrue((boolean)this.roleBasedPermissionResolver.hasPermission((Object)new CategoryPathType("category1"), RoleType.ANALYST.getName()));
        }
        finally {
            this.roleBasedPermissionStore.clearAllRoleBasedPermissionsForTesting(USER_NAME);
            this.roleBasedPermissionResolver.setEnableRoleBasedAuthorization(false);
        }
    }
}

