/*
 * Copyright 2005 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.guvnor.server.repository;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNotSame;

import javax.inject.Inject;

import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.junit.Test;

public class RepositoryStartupServiceIntegrationTest extends GuvnorIntegrationTest {

    @Inject
    private RepositoryStartupService repositoryStartupService;

    @Test
    public void testConfiguration() throws Exception {

        assertNotNull( repositoryStartupService.newSession( "foo",
                                          "foo" ) );
        assertNotSame( repositoryStartupService.newSession( "foo",
                                          "foo" ),
                repositoryStartupService.newSession( "foo",
                                          "foo" ) );
    }

}
