/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.server.SuggestionCompletionEngineServiceImplementation;
import org.drools.guvnor.server.files.FileManagerService;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.junit.Assert;
import org.junit.Test;

public class PopulateDataIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    private FileManagerService fileManagerService;
    @Inject
    private SuggestionCompletionEngineServiceImplementation suggestionCompletionEngineService;

    @Test
    public void testPopulate() throws Exception {
        this.createCategories();
        this.createStates();
        this.createPackages();
        this.createModel();
        this.createSomeRules();
        this.createPackageSnapshots();
        this.createPermissions();
        ModuleItem pkg = this.rulesRepository.loadModule("com.billasurf.manufacturing.plant");
        this.repositoryPackageService.buildPackage(pkg.getUUID(), true);
    }

    private void createPermissions() {
        HashMap perms = new HashMap();
        perms.put(RoleType.ADMIN.getName(), new ArrayList());
        this.serviceImplementation.updateUserPermissions("woozle1", perms);
        perms = new HashMap();
        ArrayList<String> targets = new ArrayList<String>();
        targets.add("category=/foo/bar");
        targets.add("category=/whee");
        perms.put(RoleType.ANALYST.getName(), targets);
        this.serviceImplementation.updateUserPermissions("woozle2", perms);
    }

    private void createModel() throws Exception {
        String uuid = this.serviceImplementation.createNewRule("DomainModel", "This is the business object model", null, "com.billasurf.manufacturing.plant", "jar");
        InputStream file = this.getClass().getResourceAsStream("/billasurf.jar");
        Assert.assertNotNull((Object)file);
        this.fileManagerService.attachFileToAsset(uuid, file, "billasurf.jar");
        AssetItem item = this.rulesRepository.loadAssetByUUID(uuid);
        Assert.assertNotNull((Object)item.getBinaryContentAsBytes());
        Assert.assertEquals((Object)item.getBinaryContentAttachmentFileName(), (Object)"billasurf.jar");
        ModuleItem pkg = this.rulesRepository.loadModule("com.billasurf.manufacturing.plant");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Board\nimport com.billasurf.Person\n\nglobal com.billasurf.Person prs", (ModuleItem)pkg);
        pkg.checkin("added imports");
        SuggestionCompletionEngine eng = this.suggestionCompletionEngineService.loadSuggestionCompletionEngine("com.billasurf.manufacturing.plant");
        Assert.assertNotNull((Object)eng);
        Assert.assertTrue((eng.getFactTypes().length >= 2 ? 1 : 0) != 0);
        String[] fields = eng.getModelFields("Board");
        Assert.assertTrue((fields.length >= 3 ? 1 : 0) != 0);
        String[] globalVars = eng.getGlobalVariables();
        Assert.assertEquals((long)1L, (long)globalVars.length);
        Assert.assertEquals((Object)"prs", (Object)globalVars[0]);
        Assert.assertTrue((eng.getFieldCompletionsForGlobalVariable("prs").length >= 2 ? 1 : 0) != 0);
        fields = eng.getModelFields("Person");
        Assert.assertTrue((fields.length >= 2 ? 1 : 0) != 0);
    }

    private void createPackageSnapshots() throws SerializationException {
        this.repositoryPackageService.createModuleSnapshot("com.billasurf.manufacturing", "TEST", false, "The testing region.", false, "", "", "", false, "", "", false, "");
        this.repositoryPackageService.createModuleSnapshot("com.billasurf.manufacturing", "PRODUCTION", false, "The testing region.", false, "", "", "", false, "", "", false, "");
        this.repositoryPackageService.createModuleSnapshot("com.billasurf.manufacturing", "PRODUCTION ROLLBACK", false, "The testing region.", false, "", "", "", false, "", "", false, "");
    }

    private void createSomeRules() throws SerializationException {
        String uuid = this.serviceImplementation.createNewRule("Surfboard_Colour_Combination", "allowable combinations for basic boards.", "Manufacturing/Boards", "com.billasurf.manufacturing", "brl");
        this.repositoryAssetService.changeState(uuid, "Pending");
        uuid = this.serviceImplementation.createNewRule("Premium_Colour_Combinations", "This defines XXX.", "Manufacturing/Boards", "com.billasurf.manufacturing", "brl");
        this.repositoryAssetService.changeState(uuid, "Approved");
        uuid = this.serviceImplementation.createNewRule("Fibreglass supplier selection", "This defines XXX.", "Manufacturing/Boards", "com.billasurf.manufacturing", "brl");
        uuid = this.serviceImplementation.createNewRule("Recommended wax", "This defines XXX.", "Manufacturing/Boards", "com.billasurf.manufacturing", "brl");
        uuid = this.serviceImplementation.createNewRule("SomeDSL", "Ignore me.", "Manufacturing/Boards", "com.billasurf.manufacturing", "dsl");
    }

    private void createPackages() throws SerializationException {
        String uuid = this.repositoryPackageService.createModule("com.billasurf.manufacturing", "Rules for manufacturing.", "package");
        Module conf = this.repositoryPackageService.loadModule(uuid);
        conf.setHeader("import com.billasurf.manuf.materials.*");
        this.repositoryPackageService.saveModule(conf);
        this.repositoryPackageService.createModule("com.billasurf.manufacturing.plant", "Rules for manufacturing plants.", "package");
        this.repositoryPackageService.createModule("com.billasurf.finance", "All financial rules.", "package");
        this.repositoryPackageService.createModule("com.billasurf.hrman", "Rules for in house HR application.", "package");
        this.repositoryPackageService.createModule("com.billasurf.sales", "Rules exposed as a service for pricing, and discounting.", "package");
    }

    private void createStates() throws SerializationException {
        this.serviceImplementation.createState("Approved");
        this.serviceImplementation.createState("Pending");
    }

    private void createCategories() {
        this.repositoryCategoryService.createCategory("/", "HR", "");
        this.repositoryCategoryService.createCategory("/", "Sales", "");
        this.repositoryCategoryService.createCategory("/", "Manufacturing", "");
        this.repositoryCategoryService.createCategory("/", "Finance", "");
        this.repositoryCategoryService.createCategory("HR", "Leave", "");
        this.repositoryCategoryService.createCategory("HR", "Training", "");
        this.repositoryCategoryService.createCategory("Sales", "Promotions", "");
        this.repositoryCategoryService.createCategory("Sales", "Old promotions", "");
        this.repositoryCategoryService.createCategory("Sales", "Boogie boards", "");
        this.repositoryCategoryService.createCategory("Sales", "Surf boards", "");
        this.repositoryCategoryService.createCategory("Sales", "Surf wear", "");
        this.repositoryCategoryService.createCategory("Manufacturing", "Surf wear", "");
        this.repositoryCategoryService.createCategory("Manufacturing", "Boards", "");
        this.repositoryCategoryService.createCategory("Finance", "Employees", "");
        this.repositoryCategoryService.createCategory("Finance", "Payables", "");
        this.repositoryCategoryService.createCategory("Finance", "Receivables", "");
    }
}

