/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;
import org.drools.guvnor.server.cache.RuleBaseCache;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.junit.Assert;
import org.junit.Test;

public class RepositoryAssetServiceIntegrationTest
extends GuvnorIntegrationTest {
    @Test
    public void testCreateLinkedAssetItem() throws Exception {
        ModuleItem testCreateNewRuleAsLinkPackage1 = this.rulesRepository.createModule("testCreateNewRuleAsLinkPackage1", "desc");
        this.repositoryCategoryService.createCategory("", "testCreateNewRuleAsLinkCat1", "this is a cat");
        this.repositoryCategoryService.createCategory("", "testCreateNewRuleAsLinkCat2", "this is a cat");
        String uuid = this.serviceImplementation.createNewRule("testCreateLinkedAssetItemRule", "an initial desc", "testCreateNewRuleAsLinkCat1", "globalArea", "dslr");
        Assert.assertNotNull((Object)uuid);
        Assert.assertFalse((boolean)"".equals(uuid));
        AssetItem dtItem = this.rulesRepository.loadAssetByUUID(uuid);
        Assert.assertEquals((Object)dtItem.getDescription(), (Object)"an initial desc");
        String uuidLink = this.serviceImplementation.createNewImportedRule("testCreateLinkedAssetItemRule", "testCreateNewRuleAsLinkPackage1");
        Assert.assertNotNull((Object)uuidLink);
        Assert.assertFalse((boolean)"".equals(uuidLink));
        Assert.assertTrue((boolean)uuidLink.equals(uuid));
        AssetItem itemLink = this.rulesRepository.loadAssetByUUID(uuidLink);
        Assert.assertEquals((Object)itemLink.getName(), (Object)"testCreateLinkedAssetItemRule");
        Assert.assertEquals((Object)itemLink.getDescription(), (Object)"an initial desc");
        Assert.assertEquals((Object)itemLink.getFormat(), (Object)"dslr");
        Assert.assertEquals((Object)itemLink.getModule().getName(), (Object)"globalArea");
        Assert.assertEquals((Object)itemLink.getModuleName(), (Object)"globalArea");
        Assert.assertTrue((itemLink.getCategories().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)itemLink.getCategorySummary().contains("testCreateNewRuleAsLinkCat1"));
        AssetItem referredItem = this.rulesRepository.loadAssetByUUID(uuid);
        Assert.assertEquals((Object)referredItem.getName(), (Object)"testCreateLinkedAssetItemRule");
        Assert.assertEquals((Object)referredItem.getDescription(), (Object)"an initial desc");
        Assert.assertEquals((Object)referredItem.getFormat(), (Object)"dslr");
        Assert.assertEquals((Object)referredItem.getModule().getName(), (Object)"globalArea");
        Assert.assertTrue((referredItem.getCategories().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)referredItem.getCategorySummary().contains("testCreateNewRuleAsLinkCat1"));
        AssetItemIterator it = this.rulesRepository.findAssetsByName("testCreateLinkedAssetItemRule%", true);
        int size = 0;
        while (it.hasNext()) {
            ++size;
            AssetItem ai = it.next();
            if (ai.getUUID().equals(uuid)) {
                Assert.assertEquals((Object)ai.getModule().getName(), (Object)"globalArea");
                Assert.assertEquals((Object)ai.getDescription(), (Object)"an initial desc");
                continue;
            }
            Assert.fail((String)("unexptected asset found: " + ai.getModule().getName()));
        }
        Assert.assertEquals((long)1L, (long)size);
    }

    @Test
    public void testLinkedAssetItemHistoryRelated() throws Exception {
        ModuleItem testCreateNewRuleAsLinkPackage1 = this.rulesRepository.createModule("testLinkedAssetItemHistoryRelatedPack", "desc");
        this.repositoryCategoryService.createCategory("", "testLinkedAssetItemHistoryRelatedCat", "this is a cat");
        String uuid = this.serviceImplementation.createNewRule("testLinkedAssetItemHistoryRelatedRule", "an initial desc", "testLinkedAssetItemHistoryRelatedCat", "globalArea", "dslr");
        String uuidLink = this.serviceImplementation.createNewImportedRule("testLinkedAssetItemHistoryRelatedRule", "testLinkedAssetItemHistoryRelatedPack");
        Assert.assertTrue((boolean)uuidLink.equals(uuid));
        Asset assetWrapper = this.repositoryAssetService.loadRuleAsset(uuidLink);
        Assert.assertEquals((Object)assetWrapper.getDescription(), (Object)"an initial desc");
        assetWrapper.setDescription("version 1");
        String uuidLink1 = this.repositoryAssetService.checkinVersion(assetWrapper);
        Asset assetWrapper2 = this.repositoryAssetService.loadRuleAsset(uuidLink);
        assetWrapper2.setDescription("version 2");
        String uuidLink2 = this.repositoryAssetService.checkinVersion(assetWrapper2);
        Asset assetWrapper3 = this.repositoryAssetService.loadRuleAsset(uuidLink);
        assetWrapper3.setDescription("version head");
        String uuidLink3 = this.repositoryAssetService.checkinVersion(assetWrapper3);
        Assert.assertEquals((Object)uuidLink, (Object)uuidLink1);
        Assert.assertEquals((Object)uuidLink, (Object)uuidLink2);
        TableDataResult result = this.repositoryAssetService.loadItemHistory(uuidLink);
        Assert.assertNotNull((Object)result);
        TableDataRow[] rows = result.data;
        Assert.assertEquals((long)4L, (long)rows.length);
        Assert.assertFalse((boolean)rows[0].id.equals(uuidLink));
        Assert.assertFalse((boolean)rows[1].id.equals(uuidLink));
        Assert.assertFalse((boolean)rows[2].id.equals(uuidLink));
        Asset version1 = this.repositoryAssetService.loadRuleAsset(rows[0].id);
        Asset version2 = this.repositoryAssetService.loadRuleAsset(rows[1].id);
        Asset version3 = this.repositoryAssetService.loadRuleAsset(rows[2].id);
        Asset versionHead = this.repositoryAssetService.loadRuleAsset(uuidLink);
        Assert.assertFalse((version1.getVersionNumber() == version2.getVersionNumber() ? 1 : 0) != 0);
        Assert.assertFalse((version1.getVersionNumber() == versionHead.getVersionNumber() ? 1 : 0) != 0);
        Assert.assertEquals((Object)version1.getDescription(), (Object)"an initial desc");
        Assert.assertEquals((Object)version2.getDescription(), (Object)"version 1");
        Assert.assertEquals((Object)version3.getDescription(), (Object)"version 2");
        Assert.assertEquals((Object)versionHead.getDescription(), (Object)"version head");
        result = this.repositoryAssetService.loadItemHistory(uuid);
        Assert.assertNotNull((Object)result);
        rows = result.data;
        Assert.assertEquals((long)4L, (long)rows.length);
        Assert.assertFalse((boolean)rows[0].id.equals(uuid));
        Assert.assertFalse((boolean)rows[1].id.equals(uuid));
        version1 = this.repositoryAssetService.loadRuleAsset(rows[0].id);
        version2 = this.repositoryAssetService.loadRuleAsset(rows[1].id);
        versionHead = this.repositoryAssetService.loadRuleAsset(uuid);
        Assert.assertFalse((version1.getVersionNumber() == version2.getVersionNumber() ? 1 : 0) != 0);
        Assert.assertFalse((version1.getVersionNumber() == versionHead.getVersionNumber() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)version1.getDescription().equals("an initial desc"));
        Assert.assertTrue((boolean)version2.getDescription().equals("version 1"));
        Assert.assertTrue((boolean)versionHead.getDescription().equals("version head"));
        this.repositoryAssetService.restoreVersion(version1.getUuid(), versionHead.getUuid(), "this was cause of a mistake");
        Asset newHead = this.repositoryAssetService.loadRuleAsset(uuid);
        Assert.assertEquals((Object)"this was cause of a mistake", (Object)newHead.getCheckinComment());
    }

    @Test
    @Deprecated
    public void testLoadRuleAsset() throws Exception {
        this.rulesRepository.createModule("testLoadRuleAsset", "desc");
        this.repositoryCategoryService.createCategory("", "testLoadRuleAsset", "this is a cat");
        this.serviceImplementation.createNewRule("testLoadRuleAsset", "description", "testLoadRuleAsset", "testLoadRuleAsset", "drl");
        TableDataResult res = this.repositoryCategoryService.loadRuleListForCategories("testLoadRuleAsset", 0, -1, "rulelist");
        Assert.assertEquals((long)1L, (long)res.data.length);
        Assert.assertEquals((long)-1L, (long)res.total);
        Assert.assertTrue((res.currentPosition > 0L ? 1 : 0) != 0);
        Assert.assertFalse((boolean)res.hasNext);
        TableDataRow row = res.data[0];
        String uuid = row.id;
        Asset asset = this.repositoryAssetService.loadRuleAsset(uuid);
        Assert.assertNotNull((Object)asset);
        Assert.assertEquals((Object)uuid, (Object)asset.getUuid());
        Assert.assertEquals((Object)"description", (Object)asset.getDescription());
        Assert.assertNotNull((Object)asset.getContent());
        Assert.assertTrue((boolean)(asset.getContent() instanceof RuleContentText));
        Assert.assertEquals((Object)"testLoadRuleAsset", (Object)asset.getName());
        Assert.assertEquals((Object)"testLoadRuleAsset", (Object)asset.getMetaData().getTitle());
        Assert.assertEquals((Object)"testLoadRuleAsset", (Object)asset.getMetaData().getModuleName());
        Assert.assertEquals((Object)"drl", (Object)asset.getFormat());
        Assert.assertNotNull((Object)asset.getDateCreated());
        Assert.assertEquals((long)1L, (long)asset.getMetaData().getCategories().length);
        Assert.assertEquals((Object)"testLoadRuleAsset", (Object)asset.getMetaData().getCategories()[0]);
        AssetItem rule = this.rulesRepository.loadModule("testLoadRuleAsset").loadAsset("testLoadRuleAsset");
        this.rulesRepository.createState("whee");
        rule.updateState("whee");
        rule.checkin("changed state");
        asset = this.repositoryAssetService.loadRuleAsset(uuid);
        Assert.assertEquals((Object)"whee", (Object)asset.getState());
        Assert.assertEquals((Object)"changed state", (Object)asset.getCheckinComment());
        uuid = this.serviceImplementation.createNewRule("testBRLFormatSugComp", "description", "testLoadRuleAsset", "testLoadRuleAsset", "brl");
        asset = this.repositoryAssetService.loadRuleAsset(uuid);
        Assert.assertTrue((boolean)(asset.getContent() instanceof RuleModel));
        uuid = this.serviceImplementation.createNewRule("testLoadRuleAssetBRL", "description", "testLoadRuleAsset", "testLoadRuleAsset", "dslr");
        asset = this.repositoryAssetService.loadRuleAsset(uuid);
        Assert.assertTrue((boolean)(asset.getContent() instanceof RuleContentText));
    }

    @Test
    @Deprecated
    public void testListAssets() throws Exception {
        ModuleItem pacakgeItem = this.rulesRepository.createModule("testListAssetsPackage", "desc");
        this.repositoryCategoryService.createCategory("", "testListAssetsCat", "this is a cat");
        this.serviceImplementation.createNewRule("testLoadArchivedAssets1", "description", "testListAssetsCat", "testListAssetsPackage", "brl");
        this.serviceImplementation.createNewRule("testLoadArchivedAssets2", "description", "testListAssetsCat", "testListAssetsPackage", "brl");
        this.serviceImplementation.createNewRule("testLoadArchivedAssets3", "description", "testListAssetsCat", "testListAssetsPackage", "brl");
        this.serviceImplementation.createNewRule("testLoadArchivedAssets4", "description", "testListAssetsCat", "testListAssetsPackage", "brl");
        this.serviceImplementation.createNewRule("testLoadArchivedAssets5", "description", "testListAssetsCat", "testListAssetsPackage", "brl");
        TableDataResult res = this.repositoryAssetService.listAssets(pacakgeItem.getUUID(), new String[]{"brl"}, 0, 2, "packageviewlist");
        Assert.assertEquals((long)2L, (long)res.data.length);
        Assert.assertTrue((5L == res.total ? 1 : 0) != 0);
        Assert.assertTrue((res.currentPosition == 2L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)res.hasNext);
        res = this.repositoryAssetService.listAssets(pacakgeItem.getUUID(), new String[]{"brl"}, 2, 2, "packageviewlist");
        Assert.assertEquals((long)2L, (long)res.data.length);
        Assert.assertTrue((5L == res.total ? 1 : 0) != 0);
        Assert.assertTrue((res.currentPosition == 4L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)res.hasNext);
    }

    @Test
    public void testLoadArchivedAssets() throws Exception {
        this.rulesRepository.createModule("testLoadArchivedAssetsPackage", "desc");
        this.repositoryCategoryService.createCategory("", "testLoadArchivedAssetsCat", "this is a cat");
        String uuid1 = this.serviceImplementation.createNewRule("testLoadArchivedAssets1", "description", "testLoadArchivedAssetsCat", "testLoadArchivedAssetsPackage", "drl");
        this.repositoryAssetService.archiveAsset(uuid1);
        String uuid2 = this.serviceImplementation.createNewRule("testLoadArchivedAssets2", "description", "testLoadArchivedAssetsCat", "testLoadArchivedAssetsPackage", "drl");
        this.repositoryAssetService.archiveAsset(uuid2);
        String uuid3 = this.serviceImplementation.createNewRule("testLoadArchivedAssets3", "description", "testLoadArchivedAssetsCat", "testLoadArchivedAssetsPackage", "drl");
        this.repositoryAssetService.archiveAsset(uuid3);
        String uuid4 = this.serviceImplementation.createNewRule("testLoadArchivedAssets4", "description", "testLoadArchivedAssetsCat", "testLoadArchivedAssetsPackage", "drl");
        this.repositoryAssetService.archiveAsset(uuid4);
        String uuid5 = this.serviceImplementation.createNewRule("testLoadArchivedAssets5", "description", "testLoadArchivedAssetsCat", "testLoadArchivedAssetsPackage", "drl");
        this.repositoryAssetService.archiveAsset(uuid5);
        TableDataResult res = this.repositoryAssetService.loadArchivedAssets(0, 2);
        Assert.assertEquals((long)2L, (long)res.data.length);
        Assert.assertTrue((res.currentPosition == 2L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)res.hasNext);
        res = this.repositoryAssetService.loadArchivedAssets(2, 2);
        Assert.assertEquals((long)2L, (long)res.data.length);
        Assert.assertEquals((long)res.currentPosition, (long)4L);
        Assert.assertTrue((boolean)res.hasNext);
    }

    @Test
    @Deprecated
    public void testListUnregisteredAssetFormats() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testListUnregisteredAssetFormats", "");
        AssetItem as = pkg.addAsset("whee", "");
        as.updateFormat("drl");
        as.checkin("");
        as = pkg.addAsset("whee2", "");
        as.updateFormat("something_silly");
        as.checkin("");
        TableDataResult res = this.repositoryAssetService.listAssets(pkg.getUUID(), new String[0], 0, 40, "rulelist");
        Assert.assertEquals((long)1L, (long)res.data.length);
    }

    @Test
    public void testLoadAssetHistoryAndRestore() throws Exception {
        long startTime = System.currentTimeMillis();
        this.rulesRepository.createModule("testLoadAssetHistory", "desc");
        long nowTime1 = System.currentTimeMillis();
        System.out.println("CreatePackage: " + (nowTime1 - startTime));
        this.repositoryCategoryService.createCategory("", "testLoadAssetHistory", "this is a cat");
        long nowTime2 = System.currentTimeMillis();
        System.out.println("CreateCategory: " + (nowTime2 - nowTime1));
        String uuid = this.serviceImplementation.createNewRule("testLoadAssetHistory", "description", "testLoadAssetHistory", "testLoadAssetHistory", "drl");
        long nowTime3 = System.currentTimeMillis();
        System.out.println("CreateNewRule: " + (nowTime3 - nowTime2));
        Asset asset = this.repositoryAssetService.loadRuleAsset(uuid);
        this.repositoryAssetService.checkinVersion(asset);
        long nowTime4 = System.currentTimeMillis();
        System.out.println("Checkin 1: " + (nowTime4 - nowTime3));
        asset = this.repositoryAssetService.loadRuleAsset(uuid);
        long nowTime5 = System.currentTimeMillis();
        System.out.println("load ruleasset: " + (nowTime5 - nowTime4));
        this.repositoryAssetService.checkinVersion(asset);
        long nowTime6 = System.currentTimeMillis();
        System.out.println("Checkin 2: " + (nowTime6 - nowTime5));
        asset = this.repositoryAssetService.loadRuleAsset(uuid);
        this.repositoryAssetService.checkinVersion(asset);
        TableDataResult result = this.repositoryAssetService.loadItemHistory(uuid);
        Assert.assertNotNull((Object)result);
        TableDataRow[] rows = result.data;
        Assert.assertEquals((long)3L, (long)rows.length);
        Assert.assertFalse((boolean)rows[0].id.equals(uuid));
        Assert.assertFalse((boolean)rows[1].id.equals(uuid));
        Asset old = this.repositoryAssetService.loadRuleAsset(rows[0].id);
        Asset newer = this.repositoryAssetService.loadRuleAsset(rows[1].id);
        Assert.assertFalse((old.getVersionNumber() == newer.getVersionNumber() ? 1 : 0) != 0);
        Asset head = this.repositoryAssetService.loadRuleAsset(uuid);
        long oldVersion = old.getVersionNumber();
        Assert.assertFalse((oldVersion == head.getVersionNumber() ? 1 : 0) != 0);
        this.repositoryAssetService.restoreVersion(old.getUuid(), head.getUuid(), "this was cause of a mistake");
        Asset newHead = this.repositoryAssetService.loadRuleAsset(uuid);
        Assert.assertEquals((Object)"this was cause of a mistake", (Object)newHead.getCheckinComment());
    }

    @Test
    public void testCopyAsset() throws Exception {
        this.repositoryCategoryService.createCategory("/", "templates", "ya");
        String uuid = this.serviceImplementation.createNewRule("testCopyAsset", "", "templates", "defaultPackage", "drl");
        String uuid2 = this.repositoryAssetService.copyAsset(uuid, "defaultPackage", "testCopyAsset2");
        Assert.assertNotSame((Object)uuid, (Object)uuid2);
        Asset asset = this.repositoryAssetService.loadRuleAsset(uuid2);
        Assert.assertNotNull((Object)asset);
        Assert.assertEquals((Object)"defaultPackage", (Object)asset.getMetaData().getModuleName());
        Assert.assertEquals((Object)"testCopyAsset2", (Object)asset.getName());
    }

    @Test
    public void testRemoveAsset() throws Exception {
        String cat = "testRemoveAsset";
        this.repositoryCategoryService.createCategory("/", cat, "ya");
        String pkgUUID = this.repositoryPackageService.createModule("testRemoveAsset", "", "package");
        String uuid = this.serviceImplementation.createNewRule("testRemoveAsset", "x", cat, "testRemoveAsset", "testRemoveAsset");
        String uuid2 = this.serviceImplementation.createNewRule("testRemoveAsset2", "x", cat, "testRemoveAsset", "testRemoveAsset");
        String uuid3 = this.serviceImplementation.createNewRule("testRemoveAsset3", "x", cat, "testRemoveAsset", "testRemoveAsset");
        String uuid4 = this.serviceImplementation.createNewRule("testRemoveAsset4", "x", cat, "testRemoveAsset", "testRemoveAsset");
        TableDataResult res = this.repositoryAssetService.listAssets(pkgUUID, this.arr("testRemoveAsset"), 0, -1, "rulelist");
        Assert.assertEquals((long)4L, (long)res.data.length);
        this.repositoryAssetService.removeAsset(uuid4);
        res = this.repositoryAssetService.listAssets(pkgUUID, this.arr("testRemoveAsset"), 0, -1, "rulelist");
        Assert.assertEquals((long)3L, (long)res.data.length);
    }

    @Test
    public void testArchiveAsset() throws Exception {
        long originalAchivedAssetsTotal = this.repositoryAssetService.loadArchivedAssets((int)0, (int)1000).total;
        String cat = "testArchiveAsset";
        this.repositoryCategoryService.createCategory("/", cat, "ya");
        String pkgUUID = this.repositoryPackageService.createModule("testArchiveAsset", "", "package");
        String uuid = this.serviceImplementation.createNewRule("testArchiveAsset", "x", cat, "testArchiveAsset", "testArchiveAsset");
        String uuid2 = this.serviceImplementation.createNewRule("testArchiveAsset2", "x", cat, "testArchiveAsset", "testArchiveAsset");
        String uuid3 = this.serviceImplementation.createNewRule("testArchiveAsset3", "x", cat, "testArchiveAsset", "testArchiveAsset");
        String uuid4 = this.serviceImplementation.createNewRule("testArchiveAsset4", "x", cat, "testArchiveAsset", "testArchiveAsset");
        TableDataResult res = this.repositoryAssetService.listAssets(pkgUUID, this.arr("testArchiveAsset"), 0, -1, "rulelist");
        Assert.assertEquals((long)4L, (long)res.data.length);
        Assert.assertEquals((long)4L, (long)res.total);
        Assert.assertFalse((boolean)res.hasNext);
        TableDataResult td = this.repositoryAssetService.loadArchivedAssets(0, 1000);
        Assert.assertEquals((long)originalAchivedAssetsTotal, (long)td.total);
        this.repositoryAssetService.archiveAsset(uuid4);
        TableDataResult td2 = this.repositoryAssetService.loadArchivedAssets(0, 1000);
        Assert.assertTrue((td2.data.length == td.data.length + 1 ? 1 : 0) != 0);
        res = this.repositoryAssetService.listAssets(pkgUUID, this.arr("testArchiveAsset"), 0, -1, "rulelist");
        Assert.assertEquals((long)3L, (long)res.data.length);
        this.repositoryAssetService.unArchiveAsset(uuid4);
        res = this.repositoryAssetService.listAssets(pkgUUID, this.arr("testArchiveAsset"), 0, -1, "rulelist");
        Assert.assertEquals((long)4L, (long)res.data.length);
    }

    @Test
    public void testArchiveAssetWhenParentPackageArchived() throws Exception {
        String packageName;
        long originalAchivedAssetsTotal = this.repositoryAssetService.loadArchivedAssets((int)0, (int)1000).total;
        String cat = packageName = "testArchiveAssetWhenParentPackageArchived";
        this.repositoryCategoryService.createCategory("/", cat, "ya");
        String pkgUUID = this.repositoryPackageService.createModule(packageName, "", "package");
        String uuid = this.serviceImplementation.createNewRule(packageName, "x", cat, packageName, packageName);
        String uuid2 = this.serviceImplementation.createNewRule("testArchiveAssetWhenParentPackageArchived2", "x", cat, packageName, packageName);
        String uuid3 = this.serviceImplementation.createNewRule("testArchiveAssetWhenParentPackageArchived3", "x", cat, packageName, packageName);
        String uuid4 = this.serviceImplementation.createNewRule("testArchiveAssetWhenParentPackageArchived4", "x", cat, packageName, packageName);
        TableDataResult res = this.repositoryAssetService.listAssets(pkgUUID, this.arr(packageName), 0, -1, "rulelist");
        Assert.assertEquals((long)4L, (long)res.data.length);
        Assert.assertEquals((long)4L, (long)res.total);
        Assert.assertFalse((boolean)res.hasNext);
        TableDataResult td = this.repositoryAssetService.loadArchivedAssets(0, 1000);
        Assert.assertEquals((long)originalAchivedAssetsTotal, (long)td.total);
        this.repositoryAssetService.archiveAsset(uuid4);
        ModuleItem packageItem = this.rulesRepository.loadModule(packageName);
        packageItem.archiveItem(true);
        packageItem.checkin("");
        TableDataResult td2 = this.repositoryAssetService.loadArchivedAssets(0, 1000);
        Assert.assertTrue((td2.data.length == td.data.length + 1 ? 1 : 0) != 0);
        res = this.repositoryAssetService.listAssets(pkgUUID, this.arr(packageName), 0, -1, "rulelist");
        Assert.assertEquals((long)3L, (long)res.data.length);
        try {
            this.repositoryAssetService.unArchiveAsset(uuid4);
            Assert.fail((String)"Should throw an exception");
        }
        catch (RulesRepositoryException e) {
            // empty catch block
        }
        res = this.repositoryAssetService.listAssets(pkgUUID, this.arr(packageName), 0, -1, "rulelist");
        Assert.assertEquals((long)3L, (long)res.data.length);
    }

    public String[] arr(String s) {
        return new String[]{s};
    }

    @Test
    public void testBuildAssetWithError() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testBuildAssetWithError", "");
        AssetItem model = pkg.addAsset("MyModel", "");
        model.updateFormat("jar");
        model.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/billasurf.jar"));
        model.checkin("");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Person", (ModuleItem)pkg);
        AssetItem asset = pkg.addAsset("testRule", "");
        asset.updateFormat("drl");
        asset.updateContent("rule 'MyGoodRule' \n when Personx() then System.err.println(42); \n end");
        asset.checkin("");
        repo.save();
        Asset rule = this.repositoryAssetService.loadRuleAsset(asset.getUUID());
        BuilderResult result = this.repositoryAssetService.validateAsset(rule);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)-1L, (long)((BuilderResultLine)result.getLines().get(0)).getMessage().indexOf("Check log for"));
        Assert.assertTrue((((BuilderResultLine)result.getLines().get(0)).getMessage().indexOf("Unable to resolve") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testBuildAsset() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testBuildAsset", "");
        AssetItem model = pkg.addAsset("MyModel", "");
        model.updateFormat("jar");
        model.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/billasurf.jar"));
        model.checkin("");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Person", (ModuleItem)pkg);
        AssetItem asset = pkg.addAsset("testRule", "");
        asset.updateFormat("drl");
        asset.updateContent("rule 'MyGoodRule' \n when Person() then System.err.println(42); \n end");
        asset.checkin("");
        repo.save();
        Asset rule = this.repositoryAssetService.loadRuleAsset(asset.getUUID());
        BuilderResult result = this.repositoryAssetService.validateAsset(rule);
        Assert.assertTrue((boolean)result.getLines().isEmpty());
        RuleBaseCache.getInstance().clearCache();
        RuleContentText text = new RuleContentText();
        text.content = "rule 'MyBadRule' \n when Personx() then System.err.println(42); \n end";
        rule.setContent((PortableObject)text);
        result = this.repositoryAssetService.validateAsset(rule);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)((BuilderResultLine)result.getLines().get(0)).getMessage());
        Assert.assertEquals((Object)"drl", (Object)((BuilderResultLine)result.getLines().get(0)).getAssetFormat());
        AssetItem dsl = pkg.addAsset("MyDSL", "");
        dsl.updateFormat("dsl");
        dsl.updateContent("[when]There is a person=Person()\n[then]print out 42=System.err.println(42);");
        dsl.checkin("");
        AssetItem dslRule = pkg.addAsset("dslRule", "");
        dslRule.updateFormat("dslr");
        dslRule.updateContent("when \n There is a person \n then \n print out 42");
        dslRule.checkin("");
        rule = this.repositoryAssetService.loadRuleAsset(dslRule.getUUID());
        result = this.repositoryAssetService.validateAsset(rule);
        Assert.assertTrue((boolean)result.getLines().isEmpty());
        asset = pkg.addAsset("someEnumThing", "");
        asset.updateFormat("enumeration");
        asset.updateContent("goober boy");
        asset.checkin("");
        result = this.repositoryAssetService.validateAsset(this.repositoryAssetService.loadRuleAsset(asset.getUUID()));
        Assert.assertFalse((result.getLines().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBuildAssetMultipleFunctionsCallingEachOther() throws Exception {
        this.repositoryPackageService.createModule("testBuildAssetMultipleFunctionsCallingEachOther", "", "package");
        this.repositoryCategoryService.createCategory("/", "funkytest", "");
        String uuidt1 = this.serviceImplementation.createNewRule("t1", "", "funkytest", "testBuildAssetMultipleFunctionsCallingEachOther", "function");
        Asset t1 = this.repositoryAssetService.loadRuleAsset(uuidt1);
        RuleContentText t1Content = new RuleContentText();
        t1Content.content = "function void t1(){\n";
        t1Content.content = t1Content.content + " t2();\n";
        t1Content.content = t1Content.content + "}\n";
        t1.setContent((PortableObject)t1Content);
        this.repositoryAssetService.checkinVersion(t1);
        String uuidt2 = this.serviceImplementation.createNewRule("t2", "", "funkytest", "testBuildAssetMultipleFunctionsCallingEachOther", "function");
        Asset t2 = this.repositoryAssetService.loadRuleAsset(uuidt2);
        RuleContentText t2Content = new RuleContentText();
        t2Content.content = "function void t2(){\n";
        t2Content.content = t2Content.content + " t1();\n";
        t2Content.content = t2Content.content + "}\n";
        t2.setContent((PortableObject)t2Content);
        this.repositoryAssetService.checkinVersion(t2);
        BuilderResult result = this.repositoryAssetService.validateAsset(t1);
        Assert.assertTrue((boolean)result.getLines().isEmpty());
    }

    @Test
    public void testBuildAssetBRXMLAndCopy() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testBuildAssetBRL", "");
        AssetItem model = pkg.addAsset("MyModel", "");
        model.updateFormat("jar");
        model.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/billasurf.jar"));
        model.checkin("");
        DroolsHeader.updateDroolsHeader((String)"import com.billasurf.Person", (ModuleItem)pkg);
        this.repositoryCategoryService.createCategory("/", "brl", "");
        String uuid = this.serviceImplementation.createNewRule("testBRL", "", "brl", "testBuildAssetBRL", "brl");
        Asset rule = this.repositoryAssetService.loadRuleAsset(uuid);
        RuleModel m = (RuleModel)rule.getContent();
        Assert.assertNotNull((Object)m);
        m.name = "testBRL";
        FactPattern p = new FactPattern("Person");
        p.setBoundName("p");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("name");
        con.setValue("mark");
        con.setOperator("==");
        con.setConstraintValueType(1);
        con.setFieldType("String");
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionSetField set = new ActionSetField("p");
        ActionFieldValue f = new ActionFieldValue("name", "42-ngoo", "String");
        set.addFieldValue(f);
        m.addRhsItem((IAction)set);
        this.repositoryAssetService.checkinVersion(rule);
        BuilderResult result = this.repositoryAssetService.validateAsset(rule);
        Assert.assertTrue((boolean)result.getLines().isEmpty());
        List<AssetItem> assets = this.iteratorToList(pkg.getAssets());
        Assert.assertEquals((long)3L, (long)assets.size());
        String newUUID = this.repositoryAssetService.copyAsset(rule.getUuid(), rule.getMetaData().getModuleName(), "ruleName2");
        assets = this.iteratorToList(pkg.getAssets());
        Assert.assertEquals((long)4L, (long)assets.size());
        Asset asset = this.repositoryAssetService.loadRuleAsset(newUUID);
        String pkgSource = this.repositoryPackageService.buildModuleSource(pkg.getUUID());
        Assert.assertTrue((pkgSource.indexOf("ruleName2") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.repositoryAssetService.buildAssetSource(asset).indexOf("ruleName2") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.repositoryAssetService.buildAssetSource(asset).indexOf("testBRL") == -1 ? 1 : 0) != 0);
    }

    private List<AssetItem> iteratorToList(Iterator<AssetItem> assets) {
        ArrayList<AssetItem> result = new ArrayList<AssetItem>();
        while (assets.hasNext()) {
            result.add(assets.next());
        }
        return result;
    }

    @Test
    public void testAssetSource() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testAssetSource", "");
        AssetItem asset = pkg.addAsset("testRule", "");
        asset.updateFormat("drl");
        asset.updateContent("rule 'n' \n when Foo() then bar(); \n end");
        asset.checkin("");
        repo.save();
        Asset rule = this.repositoryAssetService.loadRuleAsset(asset.getUUID());
        String drl = this.repositoryAssetService.buildAssetSource(rule);
        Assert.assertEquals((Object)"rule 'n' \n when Foo() then bar(); \n end", (Object)drl);
        asset = pkg.addAsset("DT", "");
        asset.updateFormat("xls");
        asset.updateBinaryContentAttachment(this.getClass().getResourceAsStream("/SampleDecisionTable.xls"));
        asset.checkin("");
        rule = this.repositoryAssetService.loadRuleAsset(asset.getUUID());
        drl = this.repositoryAssetService.buildAssetSource(rule);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("rule") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("policy: Policy") > -1 ? 1 : 0) != 0);
        AssetItem dsl = pkg.addAsset("MyDSL", "");
        dsl.updateFormat("dsl");
        dsl.updateContent("[when]This is foo=bar()\n[then]do something=yeahMan();");
        dsl.checkin("");
        asset = pkg.addAsset("MyDSLRule", "");
        asset.updateFormat("dslr");
        asset.updateContent("when \n This is foo \n then \n do something");
        asset.checkin("");
        rule = this.repositoryAssetService.loadRuleAsset(asset.getUUID());
        drl = this.repositoryAssetService.buildAssetSource(rule);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("This is foo") == -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("do something") == -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("bar()") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("yeahMan();") > -1 ? 1 : 0) != 0);
        rule = this.repositoryAssetService.loadRuleAsset(repo.copyAsset(asset.getUUID(), "testAssetSource", "newRuleName"));
        drl = this.repositoryAssetService.buildAssetSource(rule);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("newRuleName") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBuildAssetWithPackageConfigError() throws Exception {
        RulesRepository repo = this.rulesRepository;
        ModuleItem pkg = repo.createModule("testBuildAssetWithPackageConfigError", "");
        AssetItem asset = pkg.addAsset("testRule", "");
        asset.updateFormat("drl");
        asset.updateContent("rule 'MyGoodRule' \n when \n then \n end");
        asset.checkin("");
        repo.save();
        Asset rule = this.repositoryAssetService.loadRuleAsset(asset.getUUID());
        BuilderResult result = this.repositoryAssetService.validateAsset(rule);
        Assert.assertTrue((boolean)result.getLines().isEmpty());
        DroolsHeader.updateDroolsHeader((String)"importxxxx", (ModuleItem)pkg);
        repo.save();
        result = this.repositoryAssetService.validateAsset(rule);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.getLines().size());
        Assert.assertEquals((Object)"package", (Object)((BuilderResultLine)result.getLines().get(0)).getAssetFormat());
        Assert.assertNotNull((Object)((BuilderResultLine)result.getLines().get(0)).getMessage());
        Assert.assertEquals((Object)"package", (Object)((BuilderResultLine)result.getLines().get(1)).getAssetFormat());
        Assert.assertNotNull((Object)((BuilderResultLine)result.getLines().get(1)).getMessage());
    }

    @Test
    public void testLoadArchivedAssetsPagedResults() throws Exception {
        int PAGE_SIZE = 2;
        this.rulesRepository.createModule("testLoadArchivedAssetsPagedResultsPackage", "desc");
        this.repositoryCategoryService.createCategory("", "testLoadArchivedAssetsPagedResultsCat", "this is a cat");
        String uuid1 = this.serviceImplementation.createNewRule("testLoadArchivedAssetsPagedResults1", "description", "testLoadArchivedAssetsPagedResultsCat", "testLoadArchivedAssetsPagedResultsPackage", "drl");
        this.repositoryAssetService.archiveAsset(uuid1);
        String uuid2 = this.serviceImplementation.createNewRule("testLoadArchivedAssetsPagedResults2", "description", "testLoadArchivedAssetsPagedResultsCat", "testLoadArchivedAssetsPagedResultsPackage", "drl");
        this.repositoryAssetService.archiveAsset(uuid2);
        String uuid3 = this.serviceImplementation.createNewRule("testLoadArchivedAssetsPagedResults3", "description", "testLoadArchivedAssetsPagedResultsCat", "testLoadArchivedAssetsPagedResultsPackage", "drl");
        this.repositoryAssetService.archiveAsset(uuid3);
        PageRequest request = new PageRequest(0, Integer.valueOf(2));
        PageResponse response = this.repositoryAssetService.loadArchivedAssets(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertEquals((long)2L, (long)response.getPageRowList().size());
        Assert.assertFalse((boolean)response.isLastPage());
        request.setStartRowIndex(2);
        response = this.repositoryAssetService.loadArchivedAssets(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)2L, (long)response.getStartRowIndex());
    }

    @Test
    public void testLoadArchivedAssetsFullResults() throws Exception {
        this.rulesRepository.createModule("testLoadArchivedAssetsFullResultsPackage", "desc");
        this.repositoryCategoryService.createCategory("", "testLoadArchivedAssetsFullResultsCat", "this is a cat");
        String uuid1 = this.serviceImplementation.createNewRule("testLoadArchivedAssetsFullResults1", "description", "testLoadArchivedAssetsFullResultsCat", "testLoadArchivedAssetsFullResultsPackage", "drl");
        this.repositoryAssetService.archiveAsset(uuid1);
        String uuid2 = this.serviceImplementation.createNewRule("testLoadArchivedAssetsFullResults2", "description", "testLoadArchivedAssetsFullResultsCat", "testLoadArchivedAssetsFullResultsPackage", "drl");
        this.repositoryAssetService.archiveAsset(uuid2);
        String uuid3 = this.serviceImplementation.createNewRule("testLoadArchivedAssetsFullResults3", "description", "testLoadArchivedAssetsFullResultsCat", "testLoadArchivedAssetsFullResultsPackage", "drl");
        this.repositoryAssetService.archiveAsset(uuid3);
        PageRequest request = new PageRequest(0, null);
        PageResponse response = this.repositoryAssetService.loadArchivedAssets(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPageRowList());
        Assert.assertEquals((long)0L, (long)response.getStartRowIndex());
        Assert.assertTrue((boolean)response.isLastPage());
    }
}

