/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import javax.inject.Inject;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.server.VerificationServiceImplementation;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.server.util.IO;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.junit.Assert;
import org.junit.Test;

public class VerificationServiceImplementationIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    private VerificationServiceImplementation verificationService;

    @Test
    public void testVerifierCauseTrace() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testVerifierCauseTrace", "");
        AssetItem asset = pkg.addAsset("SomeDRL", "");
        asset.updateFormat("drl");
        asset.updateContent(IO.read(this.getClass().getResourceAsStream("VerifierCauseTrace.drl")));
        asset.checkin("");
        AnalysisReport report = this.verificationService.analysePackage(pkg.getUUID());
        Assert.assertNotNull((Object)report);
        Assert.assertEquals((long)0L, (long)report.warnings.length);
    }

    @Test
    public void testVerifier() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testVerifier", "");
        AssetItem asset = pkg.addAsset("SomeDRL", "");
        asset.updateFormat("drl");
        asset.updateContent(IO.read(this.getClass().getResourceAsStream("AnalysisSample.drl")));
        asset.checkin("");
        AnalysisReport report = this.verificationService.analysePackage(pkg.getUUID());
        Assert.assertNotNull((Object)report);
        Assert.assertEquals((long)0L, (long)report.errors.length);
        Assert.assertEquals((long)7L, (long)report.warnings.length);
        Assert.assertEquals((long)1L, (long)report.notes.length);
        Assert.assertEquals((long)3L, (long)report.factUsages.length);
        Assert.assertNotNull((Object)report.notes[0].description);
        Assert.assertNull((Object)report.notes[0].reason);
        Assert.assertEquals((long)2L, (long)report.notes[0].causes.length);
        Assert.assertNotNull((Object)report.notes[0].causes[0]);
        Assert.assertNotNull((Object)report.notes[0].causes[1]);
        Assert.assertEquals((Object)"Message", (Object)report.factUsages[0].name);
        Assert.assertEquals((Object)"RedundancyPattern", (Object)report.factUsages[1].name);
        Assert.assertEquals((Object)"RedundancyPattern2", (Object)report.factUsages[2].name);
        Assert.assertEquals((long)0L, (long)report.factUsages[0].fields.length);
        Assert.assertEquals((long)0L, (long)report.factUsages[1].fields.length);
        Assert.assertEquals((long)0L, (long)report.factUsages[2].fields.length);
    }
}

