/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.server.files.FeedServlet;
import org.drools.guvnor.server.files.MockHTTPRequest;
import org.drools.guvnor.server.files.MockHTTPResponse;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.util.codec.Base64;
import org.junit.Assert;
import org.junit.Test;

public class FeedServletIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    private FeedServlet feedServlet;

    public FeedServletIntegrationTest() {
        this.autoLoginAsAdmin = false;
    }

    @Test
    public void testPackageFeedNoLogin() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testPackageFeedNoLogin", "");
        AssetItem asset = pkg.addAsset("asset1", "desc");
        asset.updateFormat("drl");
        asset.checkin("");
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Irrelevant", "garbage");
            }
        };
        MockHTTPRequest req = new MockHTTPRequest("/org.foo/feed/package", (Map<String, String>)headers, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("name", "testPackageFeedNoLogin");
                this.put("viewUrl", "http://foo.bar");
            }
        });
        MockHTTPResponse res = new MockHTTPResponse();
        this.feedServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        Assert.assertEquals((long)401L, (long)res.errorCode);
    }

    @Test
    public void testPackageFeed() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testPackageFeed", "");
        AssetItem asset = pkg.addAsset("asset1", "desc");
        asset.updateFormat("drl");
        asset.checkin("");
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Authorization", "BASIC " + new String(Base64.encodeBase64((byte[])"admin:admin".getBytes())));
            }
        };
        MockHTTPRequest req = new MockHTTPRequest("/org.foo/feed/package", (Map<String, String>)headers, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("name", "testPackageFeed");
                this.put("viewUrl", "http://foo.bar");
            }
        });
        MockHTTPResponse res = new MockHTTPResponse();
        this.feedServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        String r = res.extractContent();
        Assert.assertNotNull((Object)r);
        Assert.assertTrue((r.indexOf("asset1") > -1 ? 1 : 0) != 0);
        req = new MockHTTPRequest("/org.foo/feed/package", (Map<String, String>)headers, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("name", "testPackageFeed");
                this.put("viewUrl", "http://foo.bar");
                this.put("status", "Foo");
            }
        });
        res = new MockHTTPResponse();
        this.feedServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        r = res.extractContent();
        Assert.assertNotNull((Object)r);
        Assert.assertFalse((r.indexOf("asset1.drl") > -1 ? 1 : 0) != 0);
        req = new MockHTTPRequest("/org.foo/feed/package", (Map<String, String>)headers, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("name", "testPackageFeed");
                this.put("viewUrl", "http://foo.bar");
                this.put("status", "Draft");
            }
        });
        res = new MockHTTPResponse();
        this.feedServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        r = res.extractContent();
        Assert.assertNotNull((Object)r);
        Assert.assertTrue((r.indexOf("asset1") > -1 ? 1 : 0) != 0);
        this.identity.logout();
        this.credentials.clear();
    }

    @Test
    public void testCategoryFeed() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testCategoryFeed", "");
        this.rulesRepository.loadCategory("/").addCategory("testCategoryFeedCat", "");
        AssetItem asset = pkg.addAsset("asset1", "desc");
        asset.updateFormat("drl");
        asset.updateCategoryList(new String[]{"testCategoryFeedCat"});
        asset.checkin("");
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Authorization", "BASIC " + new String(Base64.encodeBase64((byte[])"admin:admin".getBytes())));
            }
        };
        MockHTTPRequest req = new MockHTTPRequest("/org.foo/feed/category", (Map<String, String>)headers, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("name", "testCategoryFeedCat");
                this.put("viewUrl", "http://foo.bar");
            }
        });
        MockHTTPResponse res = new MockHTTPResponse();
        this.feedServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        String r = res.extractContent();
        Assert.assertNotNull((Object)r);
        Assert.assertTrue((r.indexOf("asset1") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((r.indexOf("http://foo.bar") > -1 ? 1 : 0) != 0);
        req = new MockHTTPRequest("/org.foo/feed/category", (Map<String, String>)headers, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("name", "testCategoryFeedCat");
                this.put("viewUrl", "http://foo.bar");
                this.put("status", "*");
            }
        });
        res = new MockHTTPResponse();
        this.feedServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        r = res.extractContent();
        Assert.assertNotNull((Object)r);
        Assert.assertTrue((r.indexOf("asset1") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((r.indexOf("http://foo.bar") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testDiscussionFeedNoLogin() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testDiscussionFeedNoLogin", "");
        AssetItem asset = pkg.addAsset("asset1", "desc");
        asset.updateFormat("drl");
        asset.checkin("");
        this.repositoryAssetService.addToDiscussionForAsset(asset.getUUID(), "This is a comment");
        this.repositoryAssetService.addToDiscussionForAsset(asset.getUUID(), "This is another comment");
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Irrelevant", "garbage");
            }
        };
        MockHTTPRequest req = new MockHTTPRequest("/org.foo/feed/discussion", (Map<String, String>)headers, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("package", "testDiscussionFeedNoLogin");
                this.put("assetName", "asset1");
            }
        });
        MockHTTPResponse res = new MockHTTPResponse();
        this.feedServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        Assert.assertEquals((long)401L, (long)res.errorCode);
    }

    @Test
    public void testDiscussionFeed() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testDiscussionFeed", "");
        AssetItem asset = pkg.addAsset("asset1", "desc");
        asset.updateFormat("drl");
        asset.checkin("");
        this.repositoryAssetService.addToDiscussionForAsset(asset.getUUID(), "This is a comment");
        this.repositoryAssetService.addToDiscussionForAsset(asset.getUUID(), "This is another comment");
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Authorization", "BASIC " + new String(Base64.encodeBase64((byte[])"admin:admin".getBytes())));
            }
        };
        MockHTTPRequest req = new MockHTTPRequest("/org.foo/feed/discussion", (Map<String, String>)headers, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("package", "testDiscussionFeed");
                this.put("assetName", "asset1");
            }
        });
        MockHTTPResponse res = new MockHTTPResponse();
        this.feedServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        String r = res.extractContent();
        Assert.assertNotNull((Object)r);
        Assert.assertTrue((r.indexOf("This is a comment") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((r.indexOf("This is another comment") > r.indexOf("This is a comment") ? 1 : 0) != 0);
    }
}

