/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.server.files.MockHTTPRequest;
import org.drools.guvnor.server.files.MockHTTPResponse;
import org.drools.guvnor.server.files.PackageDeploymentServlet;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.util.codec.Base64;
import org.junit.Assert;
import org.junit.Test;

public class PackageDeploymentServletIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    private PackageDeploymentServlet packageDeploymentServlet;

    @Test
    public void testScenariosAndChangeSet() throws Exception {
        this.rulesRepository.createModule("testScenariosURL", "");
        this.repositoryPackageService.createModuleSnapshot("testScenariosURL", "SNAP1", false, "", false, "", "", "", false, "", "", false, "");
        Base64 enc = new Base64();
        final String encodedAuthorization = enc.encodeToString("admin:admin".getBytes());
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Authorization", "BASIC " + encodedAuthorization);
            }
        };
        MockHTTPRequest req = new MockHTTPRequest("/package/testScenariosURL/LATEST/SCENARIOS", (Map<String, String>)headers);
        MockHTTPResponse res = new MockHTTPResponse();
        this.packageDeploymentServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        String testResult = res.extractContent();
        Assert.assertNotNull((Object)testResult);
        Assert.assertEquals((Object)"No test scenarios found.", (Object)testResult);
        req = new MockHTTPRequest("/package/testScenariosURL/SNAP1/SCENARIOS", (Map<String, String>)headers);
        res = new MockHTTPResponse();
        this.packageDeploymentServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        testResult = res.extractContent();
        Assert.assertNotNull((Object)testResult);
        Assert.assertEquals((Object)"No test scenarios found.", (Object)testResult);
        req = new MockHTTPRequest("/package/testScenariosURL/SNAP1/ChangeSet.xml", (Map<String, String>)headers);
        req.url = new StringBuffer("http://foo/ChangeSet.xml");
        res = new MockHTTPResponse();
        this.packageDeploymentServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        testResult = res.extractContent();
        Assert.assertNotNull((Object)testResult);
        Assert.assertTrue((testResult.indexOf("<resource source='http://foo' type='PKG' />") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPNG() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testPNGPackage", "");
        AssetItem asset = pkg.addAsset("myprocess", "");
        asset.updateFormat("pgn");
        asset.updateBinaryContentAttachment(this.getClass().getResource("resources/myprocess.png").openStream());
        asset.updateContent("import org.drools.guvnor.server.files.SampleFact\n global org.drools.guvnor.server.files.SampleFact sf");
        asset.checkin("");
        AssetItem assetnew = this.rulesRepository.loadAssetByUUID(asset.getUUID());
        Assert.assertEquals((Object)"myprocess", (Object)assetnew.getName());
        Base64 enc = new Base64();
        final String encodedAuthorization = enc.encodeToString("admin:admin".getBytes());
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("Authorization", "BASIC " + encodedAuthorization);
            }
        };
        MockHTTPRequest req = new MockHTTPRequest("/package/testPNGPackage/LATEST/myprocess.png", (Map<String, String>)headers);
        MockHTTPResponse res = new MockHTTPResponse();
        this.packageDeploymentServlet.doGet((HttpServletRequest)req, (HttpServletResponse)res);
        Assert.assertNotNull((Object)res.extractContentBytes());
        byte[] bin = res.extractContentBytes();
        Assert.assertTrue((bin.length > 0 ? 1 : 0) != 0);
    }
}

