/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.Response;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.RequestOptions;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.drools.guvnor.server.jaxrs.Translator;
import org.drools.guvnor.server.jaxrs.jaxb.Category;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.util.codec.Base64;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CategoryResourceIntegrationTest
extends GuvnorIntegrationTest {
    private Abdera abdera = new Abdera();

    public CategoryResourceIntegrationTest() {
        this.autoLoginAsAdmin = false;
    }

    @Test
    @InSequence(value=-1)
    public void startServers() throws Exception {
        this.repositoryCategoryService.createCategory(null, "Category 1", "Category 1 description");
        this.repositoryCategoryService.createCategory(null, "Category 2", "Category 2 description");
        this.repositoryCategoryService.createCategory("Category 1", "Category 1.1", "Category 1.1 description");
        this.repositoryCategoryService.createCategory("Category 1", "Category 1.2", "Category 1.2 description");
        this.repositoryCategoryService.createCategory("Category 1/Category 1.1", "Category 1.1.1", "Category 1.1.1 description");
        this.repositoryCategoryService.createCategory(null, "testCreateSubCategory", "desc");
        ModuleItem pkg = this.rulesRepository.createModule("categoriesPackage1", "this is package categoriesPackage1");
        AssetItem rule = pkg.addAsset("rule1", "");
        rule.updateFormat("drl");
        rule.updateContent("rule 'foo' when Goo1() then end");
        rule.updateCategoryList(new String[]{"Category 1"});
        rule.checkin("version 1");
        rule = pkg.addAsset("rule2", "");
        rule.updateFormat("drl");
        rule.updateContent("rule 'foo' when Goo1() then end");
        rule.updateCategoryList(new String[]{"Category 2"});
        rule.checkin("version 1");
        rule = pkg.addAsset("rule3", "");
        rule.updateFormat("drl");
        rule.updateContent("rule 'foo' when Goo1() then end");
        rule.updateCategoryList(new String[]{"Category 1", "Category 2"});
        rule.checkin("version 1");
    }

    @Test
    @RunAsClient
    public void getCategoriesAsJAXB(@ArquillianResource URL baseURL) throws Exception {
        AbderaClient client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        ClientResponse resp = client.get(new URL(baseURL, "rest/categories").toExternalForm());
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        Assert.assertEquals((Object)"application/xml", (Object)resp.getContentType().toString());
        Document document = resp.getDocument();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        document.writeTo((OutputStream)outputStream);
        outputStream.close();
        Map<String, Category> existingCategories = this.fromXMLToCategoriesMap(outputStream.toString("UTF-8"));
        resp = client.put(new URL(baseURL, "rest/categories/getCategoriesAsJAXBCategory1").toExternalForm(), (InputStream)new ByteArrayInputStream(new String("getCategoriesAsJAXBCategory1").getBytes()));
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        resp = client.put(new URL(baseURL, "rest/categories/getCategoriesAsJAXBCategory2").toExternalForm(), (InputStream)new ByteArrayInputStream(new String("getCategoriesAsJAXBCategory2").getBytes()));
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        resp = client.put(new URL(baseURL, "rest/categories/getCategoriesAsJAXBCategory3").toExternalForm(), (InputStream)new ByteArrayInputStream(new String("getCategoriesAsJAXBCategory3").getBytes()));
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        client.getCache().clear();
        resp = client.get(new URL(baseURL, "rest/categories").toExternalForm());
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        Assert.assertEquals((Object)"application/xml", (Object)resp.getContentType().toString());
        document = resp.getDocument();
        outputStream = new ByteArrayOutputStream();
        document.writeTo((OutputStream)outputStream);
        outputStream.close();
        Map<String, Category> allCategories = this.fromXMLToCategoriesMap(outputStream.toString("UTF-8"));
        Assert.assertEquals((long)(3 + existingCategories.size()), (long)allCategories.size());
        Assert.assertTrue((boolean)allCategories.containsKey("getCategoriesAsJAXBCategory1"));
        Assert.assertTrue((boolean)allCategories.containsKey("getCategoriesAsJAXBCategory2"));
        Assert.assertTrue((boolean)allCategories.containsKey("getCategoriesAsJAXBCategory3"));
        Assert.assertTrue((boolean)allCategories.containsKey("Category 1"));
        Assert.assertTrue((boolean)allCategories.containsKey("Category 2"));
        Assert.assertTrue((boolean)allCategories.containsKey("Category 1/Category 1.1"));
        Assert.assertTrue((boolean)allCategories.containsKey("Category 1/Category 1.2"));
        Assert.assertTrue((boolean)allCategories.containsKey("Category 1/Category 1.1/Category 1.1.1"));
        for (Category category : allCategories.values()) {
            Assert.assertNotNull((Object)category.getRefLink());
        }
    }

    @Test
    @RunAsClient
    public void getCategoryAsJAXB(@ArquillianResource URL baseURL) throws Exception {
        AbderaClient client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        ClientResponse resp = client.get(new URL(baseURL, "rest/categories/Category%201").toExternalForm());
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        Assert.assertEquals((Object)"application/xml", (Object)resp.getContentType().toString());
        Document document = resp.getDocument();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        document.writeTo((OutputStream)outputStream);
        outputStream.close();
        Map<String, Category> categories = this.fromXMLToCategoriesMap(outputStream.toString("UTF-8"));
        Assert.assertEquals((long)1L, (long)categories.size());
        Category category = categories.values().iterator().next();
        Assert.assertEquals((Object)"Category 1", (Object)category.getPath());
        client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        resp = client.get(new URL(baseURL, "rest/categories/Category%201/Category%201.1/Category%201.1.1").toExternalForm());
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        Assert.assertEquals((Object)"application/xml", (Object)resp.getContentType().toString());
        document = resp.getDocument();
        outputStream = new ByteArrayOutputStream();
        document.writeTo((OutputStream)outputStream);
        outputStream.close();
        categories = this.fromXMLToCategoriesMap(outputStream.toString("UTF-8"));
        Assert.assertEquals((long)1L, (long)categories.size());
        category = categories.values().iterator().next();
        Assert.assertEquals((Object)"Category 1/Category 1.1/Category 1.1.1", (Object)category.getPath());
    }

    @Test
    @RunAsClient
    public void getCategoryChildrenAsJAXB(@ArquillianResource URL baseURL) throws Exception {
        AbderaClient client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        ClientResponse resp = client.get(new URL(baseURL, "rest/categories/Category%201/children").toExternalForm());
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        Assert.assertEquals((Object)"application/xml", (Object)resp.getContentType().toString());
        Document document = resp.getDocument();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        document.writeTo((OutputStream)outputStream);
        outputStream.close();
        Map<String, Category> categories = this.fromXMLToCategoriesMap(outputStream.toString("UTF-8"));
        Assert.assertEquals((long)2L, (long)categories.size());
        Assert.assertTrue((boolean)categories.containsKey("Category 1/Category 1.1"));
        Assert.assertTrue((boolean)categories.containsKey("Category 1/Category 1.2"));
        client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        resp = client.get(new URL(baseURL, "rest/categories/Category%201/Category%201.1/children").toExternalForm());
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        Assert.assertEquals((Object)"application/xml", (Object)resp.getContentType().toString());
        document = resp.getDocument();
        outputStream = new ByteArrayOutputStream();
        document.writeTo((OutputStream)outputStream);
        outputStream.close();
        categories = this.fromXMLToCategoriesMap(outputStream.toString("UTF-8"));
        Assert.assertEquals((long)1L, (long)categories.size());
        Assert.assertTrue((boolean)categories.containsKey("Category 1/Category 1.1/Category 1.1.1"));
        client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        resp = client.get(new URL(baseURL, "rest/categories/Category%202/children").toExternalForm());
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        Assert.assertEquals((Object)"application/xml", (Object)resp.getContentType().toString());
        document = resp.getDocument();
        outputStream = new ByteArrayOutputStream();
        document.writeTo((OutputStream)outputStream);
        outputStream.close();
        categories = this.fromXMLToCategoriesMap(outputStream.toString("UTF-8"));
        Assert.assertTrue((boolean)categories.isEmpty());
    }

    @Test
    @RunAsClient
    public void createCategory(@ArquillianResource URL baseURL) throws Exception {
        AbderaClient client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        ClientResponse resp = client.put(new URL(baseURL, "rest/categories/createCategory").toExternalForm(), (InputStream)new ByteArrayInputStream(new byte[0]));
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
    }

    @Test
    @RunAsClient
    public void testCreateSubCategory(@ArquillianResource URL baseURL) throws Exception {
        AbderaClient client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        ClientResponse resp = client.put(new URL(baseURL, "rest/categories/testCreateSubCategory/subCat1").toExternalForm(), (InputStream)new ByteArrayInputStream(new byte[0]));
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        resp = client.put(new URL(baseURL, "rest/categories/testCreateSubCategory/subCat1/subCat2").toExternalForm(), (InputStream)new ByteArrayInputStream(new byte[0]));
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
    }

    @Test
    @RunAsClient
    public void deleteCategory(@ArquillianResource URL baseURL) throws Exception {
        AbderaClient client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        ClientResponse resp = client.put(new URL(baseURL, "rest/categories/deleteCategory").toExternalForm(), (InputStream)new ByteArrayInputStream(new byte[0]));
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
        resp = client.delete(new URL(baseURL, "rest/categories/deleteCategory").toExternalForm());
        Assert.assertEquals((Object)Response.ResponseType.SUCCESS, (Object)resp.getType());
    }

    @Test
    @RunAsClient
    public void testGetAssetsByCategoryAsAtom(@ArquillianResource URL baseURL) throws Exception {
        AbderaClient client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        RequestOptions options = client.getDefaultRequestOptions();
        options.setAccept("application/atom+xml");
        ClientResponse resp = client.get(new URL(baseURL, "rest/categories/Category%201/assets").toExternalForm());
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)"Error getting assets from 'Category 1'");
        }
        Document document = resp.getDocument();
        Assert.assertEquals((long)2L, (long)((Feed)document.getRoot()).getEntries().size());
        ArrayList<String> assetNames = new ArrayList<String>();
        for (Entry entry : ((Feed)document.getRoot()).getEntries()) {
            assetNames.add(entry.getTitle());
        }
        Assert.assertTrue((boolean)assetNames.contains("rule1"));
        Assert.assertTrue((boolean)assetNames.contains("rule3"));
        client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        options = client.getDefaultRequestOptions();
        options.setAccept("application/atom+xml");
        resp = client.get(new URL(baseURL, "rest/categories/Category%202/assets").toExternalForm());
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)"Error getting assets from 'Category 1'");
        }
        document = resp.getDocument();
        Assert.assertEquals((long)2L, (long)((Feed)document.getRoot()).getEntries().size());
        assetNames = new ArrayList();
        for (Entry entry : ((Feed)document.getRoot()).getEntries()) {
            assetNames.add(entry.getTitle());
        }
        Assert.assertTrue((boolean)assetNames.contains("rule2"));
        Assert.assertTrue((boolean)assetNames.contains("rule3"));
    }

    @Test
    @RunAsClient
    public void testGetAssetsCreatedByAtomByCategoryAsAtom(@ArquillianResource URL baseURL) throws Exception {
        AbderaClient client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        Entry processEntry = this.createProcessEntry("Process1", "Some test process", (List<String>)new ArrayList<String>(){
            {
                this.add("Category 1");
            }
        });
        RequestOptions options = client.getDefaultRequestOptions();
        options.setContentType("application/atom+xml");
        ClientResponse resp = client.post(new URL(baseURL, "rest/packages/categoriesPackage1/assets").toExternalForm(), (Base)processEntry, options);
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)("Error creating process asset: " + resp.getStatusText()));
        }
        client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        processEntry = this.createProcessEntry("Process2", "Some other test process", (List<String>)new ArrayList<String>(){
            {
                this.add("Category 2");
            }
        });
        options = client.getDefaultRequestOptions();
        options.setContentType("application/atom+xml");
        resp = client.post(new URL(baseURL, "rest/packages/categoriesPackage1/assets").toExternalForm(), (Base)processEntry, options);
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)("Error creating process asset: " + resp.getStatusText()));
        }
        client = new AbderaClient(this.abdera);
        client.addCredentials(baseURL.toExternalForm(), null, null, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        options = client.getDefaultRequestOptions();
        options.setAccept("application/atom+xml");
        resp = client.get(new URL(baseURL, "rest/categories/Category%201/assets").toExternalForm());
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)"Error getting assets from 'Category 1'");
        }
        Document document = resp.getDocument();
        Assert.assertEquals((long)3L, (long)((Feed)document.getRoot()).getEntries().size());
        ArrayList<String> assetNames = new ArrayList<String>();
        for (Entry entry : ((Feed)document.getRoot()).getEntries()) {
            assetNames.add(entry.getTitle());
        }
        Assert.assertTrue((boolean)assetNames.contains("rule1"));
        Assert.assertTrue((boolean)assetNames.contains("rule3"));
        Assert.assertTrue((boolean)assetNames.contains("Process1"));
        resp = client.delete(new URL(baseURL, "rest/packages/categoriesPackage1/assets/Process1").toExternalForm());
        if (resp.getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)"Error deleting 'Process1'");
        }
        if ((resp = client.delete(new URL(baseURL, "rest/packages/categoriesPackage1/assets/Process2").toExternalForm())).getType() != Response.ResponseType.SUCCESS) {
            Assert.fail((String)"Error deleting 'Process2'");
        }
    }

    @Test
    @RunAsClient
    @Ignore
    public void testGetAssetsByCategoryAsJson(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/categories/Home%20Mortgage/assets");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/json", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    @Ignore
    public void testGetAssetsByCategoryAsJaxb(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/categories/Home%20Mortgage/assets");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/xml", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    @Ignore
    public void testGetAssetsByCategoryAndPageAsAtom(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/categories/Home%20Mortgage/assets//page/0");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/atom+xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/atom+xml", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    @Ignore
    public void testGetAssetsByCategoryAndPageAsJson(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/categories/Home%20Mortgage/assets//page/0");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/json", (Object)connection.getContentType());
    }

    @Test
    @RunAsClient
    @Ignore
    public void testGetAssetsByCategoryAndPageAsJaxb(@ArquillianResource URL baseURL) throws Exception {
        URL url = new URL(baseURL, "rest/categories/Home%20Mortgage/assets//page/0");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + new Base64().encodeToString("admin:admin".getBytes()));
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        connection.connect();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertEquals((Object)"application/xml", (Object)connection.getContentType());
    }

    private Entry createProcessEntry(String title, String summary, List<String> categories) {
        Entry processEntry = this.abdera.newEntry();
        processEntry.setTitle(title);
        processEntry.setSummary(summary);
        ExtensibleElement metadataExtension = (ExtensibleElement)processEntry.addExtension(new QName("", "metadata"));
        ExtensibleElement formatExtension = (ExtensibleElement)metadataExtension.addExtension(new QName("", "format"));
        formatExtension.addSimpleExtension(new QName("", "value"), "bpmn2");
        ExtensibleElement categoriesExtension = (ExtensibleElement)metadataExtension.addExtension(new QName("", "categories"));
        categoriesExtension.addSimpleExtension(new QName("", "value"), categories.get(0));
        return processEntry;
    }

    public Map<String, Category> fromXMLToCategoriesMap(String xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            final ArrayList errors = new ArrayList();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    Logger.getLogger(Translator.class.getName()).log(Level.WARNING, "Warning parsing categories from Guvnor", exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    Logger.getLogger(Translator.class.getName()).log(Level.SEVERE, "Error parsing categories from Guvnor", exception);
                    errors.add(exception.getMessage());
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    Logger.getLogger(Translator.class.getName()).log(Level.SEVERE, "Error parsing categories from Guvnor", exception);
                    errors.add(exception.getMessage());
                }
            });
            org.w3c.dom.Document doc = builder.parse(new ByteArrayInputStream(xml.getBytes()));
            if (!errors.isEmpty()) {
                throw new IllegalStateException("Error parsing categories from guvnor. Check the log for errors' details.");
            }
            HashMap<String, Category> categories = new HashMap<String, Category>();
            NodeList categoriesList = doc.getElementsByTagName("category");
            for (int i = 0; i < categoriesList.getLength(); ++i) {
                Element element = (Element)categoriesList.item(i);
                Category category = new Category();
                NodeList pathNodes = element.getElementsByTagName("path");
                if (pathNodes.getLength() != 1) {
                    throw new IllegalStateException("Malformed category. Expected 1 <path> tag, but found " + pathNodes.getLength());
                }
                Node pathNode = pathNodes.item(0);
                category.setPath(pathNode.getTextContent());
                NodeList refLinkNodes = element.getElementsByTagName("refLink");
                if (refLinkNodes.getLength() != 1) {
                    throw new IllegalStateException("Malformed category. Expected 1 <refLink> tag, but found " + refLinkNodes.getLength());
                }
                Node refLinkNode = refLinkNodes.item(0);
                try {
                    category.setRefLink(new URI(refLinkNode.getTextContent()));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Error parsing categories xml", e);
                }
                categories.put(category.getPath(), category);
            }
            return categories;
        }
        catch (SAXException ex) {
            throw new RuntimeException("Error parsing categories xml", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error parsing categories xml", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Error parsing categories xml", ex);
        }
    }
}

