/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.fileupload.FileItem;
import org.drools.guvnor.server.files.FileManagerService;
import org.drools.guvnor.server.test.GuvnorIntegrationTest;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.guvnor.server.util.FormData;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.junit.Assert;
import org.junit.Test;

public class FileManagerServiceIntegrationTest
extends GuvnorIntegrationTest {
    @Inject
    private FileManagerService fileManagerService;

    @Test
    public void testAttachFile() throws Exception {
        AssetItem item = this.rulesRepository.loadDefaultModule().addAsset("testUploadFile", "description");
        item.updateFormat("drl");
        FormData upload = new FormData();
        upload.setFile((FileItem)new MockFile());
        upload.setUuid(item.getUUID());
        this.fileManagerService.attachFile(upload);
        AssetItem item2 = this.rulesRepository.loadDefaultModule().loadAsset("testUploadFile");
        byte[] data = item2.getBinaryContentAsBytes();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((Object)"foo bar", (Object)new String(data));
        Assert.assertEquals((Object)"foo.bar", (Object)item2.getBinaryContentAttachmentFileName());
    }

    @Test
    public void testAttachModel() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testAttachModelImports", "heh");
        AssetItem asset = pkg.addAsset("MyModel", "");
        asset.updateFormat("jar");
        asset.checkin("");
        pkg.updateBinaryUpToDate(true);
        this.rulesRepository.save();
        Assert.assertTrue((boolean)pkg.isBinaryUpToDate());
        Assert.assertEquals((Object)"", (Object)DroolsHeader.getDroolsHeader((ModuleItem)pkg));
        this.fileManagerService.attachFileToAsset(asset.getUUID(), this.getClass().getResourceAsStream("/billasurf.jar"), "billasurf.jar");
        pkg = this.rulesRepository.loadModule("testAttachModelImports");
        Assert.assertFalse((boolean)pkg.isBinaryUpToDate());
        Assert.assertNotNull((Object)DroolsHeader.getDroolsHeader((ModuleItem)pkg));
        Assert.assertTrue((DroolsHeader.getDroolsHeader((ModuleItem)pkg).indexOf("import com.billasurf.Board") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((DroolsHeader.getDroolsHeader((ModuleItem)pkg).indexOf("import com.billasurf.Person") > -1 ? 1 : 0) != 0);
        DroolsHeader.updateDroolsHeader((String)"goo wee", (ModuleItem)pkg);
        pkg.checkin("");
        this.fileManagerService.attachFileToAsset(asset.getUUID(), this.getClass().getResourceAsStream("/billasurf.jar"), "billasurf.jar");
        pkg = this.rulesRepository.loadModule("testAttachModelImports");
        Assert.assertEquals((Object)"goo wee\nimport com.billasurf.Board\nimport com.billasurf.Person\n", (Object)DroolsHeader.getDroolsHeader((ModuleItem)pkg));
    }

    @Test
    public void testGetFilebyUUID() throws Exception {
        AssetItem item = this.rulesRepository.loadDefaultModule().addAsset("testGetFilebyUUID", "description");
        item.updateFormat("drl");
        this.rulesRepository.save();
        FormData upload = new FormData();
        MockFile file = new MockFile("testGetFilebyUUID.drl");
        upload.setFile((FileItem)file);
        upload.setUuid(item.getUUID());
        this.fileManagerService.attachFile(upload);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String filename = this.fileManagerService.loadFileAttachmentByUUID(item.getUUID(), (OutputStream)out);
        Assert.assertNotNull((Object)out.toByteArray());
        Assert.assertEquals((Object)"foo bar", (Object)new String(out.toByteArray()));
        Assert.assertEquals((Object)"testGetFilebyUUID.drl", (Object)filename);
    }

    @Test
    public void testGetPackageBinaryAndSource() throws Exception {
        long before = System.currentTimeMillis();
        Thread.sleep(20L);
        ModuleItem pkg = this.rulesRepository.createModule("testGetBinaryPackageServlet", "");
        DroolsHeader.updateDroolsHeader((String)"import java.util.List", (ModuleItem)pkg);
        pkg.updateCompiledBinary((InputStream)new ByteArrayInputStream("foo".getBytes()));
        pkg.checkin("");
        Assert.assertTrue((before < this.fileManagerService.getLastModified(pkg.getName(), "LATEST") ? 1 : 0) != 0);
        this.repositoryPackageService.createModuleSnapshot(pkg.getName(), "SNAPPY 1", false, "", false, "", "", "", false, "", "", false, "");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String fileName = this.fileManagerService.loadBinaryPackage(pkg.getName(), "LATEST", true, (OutputStream)out);
        Assert.assertEquals((Object)"testGetBinaryPackageServlet.pkg", (Object)fileName);
        byte[] file = out.toByteArray();
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((Object)"foo", (Object)new String(file));
        out = new ByteArrayOutputStream();
        String drlName = this.fileManagerService.loadSourcePackage(pkg.getName(), "LATEST", true, (OutputStream)out);
        String drl = new String(out.toByteArray());
        Assert.assertEquals((Object)(pkg.getName() + ".drl"), (Object)drlName);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("import java.util.List") > -1 ? 1 : 0) != 0);
        out = new ByteArrayOutputStream();
        fileName = this.fileManagerService.loadBinaryPackage(pkg.getName(), "SNAPPY 1", false, (OutputStream)out);
        Assert.assertEquals((Object)"testGetBinaryPackageServlet_SNAPPY+1.pkg", (Object)fileName);
        file = out.toByteArray();
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((Object)"foo", (Object)new String(file));
        out = new ByteArrayOutputStream();
        fileName = this.fileManagerService.loadSourcePackage(pkg.getName(), "SNAPPY 1", false, (OutputStream)out);
        Assert.assertEquals((Object)"testGetBinaryPackageServlet_SNAPPY+1.drl", (Object)fileName);
        drl = new String(out.toByteArray());
        Assert.assertTrue((drl.indexOf("import java.util.List") > -1 ? 1 : 0) != 0);
        Thread.sleep(100L);
        this.repositoryPackageService.createModuleSnapshot(pkg.getName(), "SNAPX", false, "", false, "", "", "", false, "", "", false, "");
        long lastMod = this.fileManagerService.getLastModified(pkg.getName(), "SNAPPY 1");
        Assert.assertTrue((pkg.getLastModified().getTimeInMillis() < lastMod ? 1 : 0) != 0);
        Thread.sleep(100L);
        this.repositoryPackageService.createModuleSnapshot(pkg.getName(), "SNAPX", true, "yeah", false, "", "", "", false, "", "", false, "");
        long lastMod2 = this.fileManagerService.getLastModified(pkg.getName(), "SNAPX");
        Assert.assertTrue((lastMod < lastMod2 ? 1 : 0) != 0);
    }

    @Test
    public void testImportArchivedPackage() throws Exception {
        String drl = "package testImportArchivedPackage\n import blah \n rule 'ola' \n when \n then \n end \n rule 'hola' \n when \n then \n end";
        ByteArrayInputStream in = new ByteArrayInputStream(drl.getBytes());
        this.fileManagerService.importClassicDRL((InputStream)in, null);
        ModuleItem pkg = this.rulesRepository.loadModule("testImportArchivedPackage");
        Assert.assertNotNull((Object)pkg);
        Assert.assertFalse((boolean)pkg.isArchived());
        pkg.archiveItem(true);
        this.rulesRepository.save();
        pkg = this.rulesRepository.loadModule("testImportArchivedPackage");
        Assert.assertNotNull((Object)pkg);
        Assert.assertTrue((boolean)pkg.isArchived());
        ByteArrayInputStream in2 = new ByteArrayInputStream(drl.getBytes());
        this.fileManagerService.importClassicDRL((InputStream)in2, null);
        pkg = this.rulesRepository.loadModule("testImportArchivedPackage");
        Assert.assertNotNull((Object)pkg);
        Assert.assertFalse((boolean)pkg.isArchived());
    }

    @Test
    public void testClassicDRLImport() throws Exception {
        String drl = "package testClassicDRLImport\n import blah \n rule 'ola' \n when \n then \n end \n rule 'hola' \n when \n then \n end";
        ByteArrayInputStream in = new ByteArrayInputStream(drl.getBytes());
        this.fileManagerService.importClassicDRL((InputStream)in, null);
        ModuleItem pkg = this.rulesRepository.loadModule("testClassicDRLImport");
        Assert.assertNotNull((Object)pkg);
        List<AssetItem> rules = this.iteratorToList(pkg.getAssets());
        Assert.assertEquals((long)3L, (long)rules.size());
        AssetItem pkgConf = rules.get(0);
        Assert.assertEquals((Object)"drools", (Object)pkgConf.getName());
        rules.remove(0);
        AssetItem rule1 = rules.get(0);
        Assert.assertEquals((Object)"ola", (Object)rule1.getName());
        Assert.assertNotNull((Object)rule1.getContent());
        Assert.assertEquals((Object)"drl", (Object)rule1.getFormat());
        Assert.assertTrue((rule1.getContent().indexOf("when") > -1 ? 1 : 0) != 0);
        AssetItem rule2 = rules.get(1);
        Assert.assertEquals((Object)"hola", (Object)rule2.getName());
        Assert.assertNotNull((Object)rule2.getContent());
        Assert.assertEquals((Object)"drl", (Object)rule2.getFormat());
        Assert.assertTrue((rule2.getContent().indexOf("when") > -1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)DroolsHeader.getDroolsHeader((ModuleItem)pkg));
        Assert.assertTrue((DroolsHeader.getDroolsHeader((ModuleItem)pkg).indexOf("import") > -1 ? 1 : 0) != 0);
        drl = "package testClassicDRLImport\n import should not see \n rule 'ola2' \n when \n then \n end \n rule 'hola' \n when \n then \n end";
        in = new ByteArrayInputStream(drl.getBytes());
        this.fileManagerService.importClassicDRL((InputStream)in, null);
        pkg = this.rulesRepository.loadModule("testClassicDRLImport");
        Assert.assertNotNull((Object)pkg);
        String hdr = DroolsHeader.getDroolsHeader((ModuleItem)pkg);
        Assert.assertTrue((hdr.indexOf("import should not see") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((hdr.indexOf("import blah") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((hdr.indexOf("import should not see") > hdr.indexOf("import blah") ? 1 : 0) != 0);
        rules = this.iteratorToList(pkg.getAssets());
        Assert.assertEquals((long)4L, (long)rules.size());
        AssetItem assetOriginal = this.rulesRepository.loadModule("testClassicDRLImport").loadAsset("ola");
        long ver = assetOriginal.getVersionNumber();
        drl = "package testClassicDRLImport\n import blah \n rule 'ola' \n when CHANGED\n then \n end \n rule 'hola' \n when \n then \n end";
        in = new ByteArrayInputStream(drl.getBytes());
        this.fileManagerService.importClassicDRL((InputStream)in, null);
        pkg = this.rulesRepository.loadModule("testClassicDRLImport");
        AssetItem asset = pkg.loadAsset("ola");
        Assert.assertTrue((asset.getContent().indexOf("CHANGED") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)(ver + 1L), (long)asset.getVersionNumber());
    }

    @Test
    public void testDRLImportWithoutPackageName() throws Exception {
        String drl = "import blah \n rule 'ola' \n when \n then \n end \n rule 'hola' \n when \n then \n end";
        ByteArrayInputStream in = new ByteArrayInputStream(drl.getBytes());
        try {
            this.fileManagerService.importClassicDRL((InputStream)in, null);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Missing package name.", (Object)e.getMessage());
        }
        in = new ByteArrayInputStream(drl.getBytes());
        this.fileManagerService.importClassicDRL((InputStream)in, "testDRLImportWithoutPackageName");
        ModuleItem pkg = this.rulesRepository.loadModule("testDRLImportWithoutPackageName");
        Assert.assertNotNull((Object)pkg);
        List<AssetItem> rules = this.iteratorToList(pkg.getAssets());
        Assert.assertEquals((long)3L, (long)rules.size());
        AssetItem pkgConf = rules.get(0);
        Assert.assertEquals((Object)"drools", (Object)pkgConf.getName());
        rules.remove(0);
        AssetItem rule1 = rules.get(0);
        Assert.assertEquals((Object)"ola", (Object)rule1.getName());
        Assert.assertNotNull((Object)rule1.getContent());
        Assert.assertEquals((Object)"drl", (Object)rule1.getFormat());
        Assert.assertTrue((rule1.getContent().indexOf("when") > -1 ? 1 : 0) != 0);
        AssetItem rule2 = rules.get(1);
        Assert.assertEquals((Object)"hola", (Object)rule2.getName());
        Assert.assertNotNull((Object)rule2.getContent());
        Assert.assertEquals((Object)"drl", (Object)rule2.getFormat());
        Assert.assertTrue((rule2.getContent().indexOf("when") > -1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)DroolsHeader.getDroolsHeader((ModuleItem)pkg));
        Assert.assertTrue((DroolsHeader.getDroolsHeader((ModuleItem)pkg).indexOf("import") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testDRLImportOverrideExistingPackageName() throws Exception {
        String drl = "package thisIsNeverUsed \n import blah \n rule 'ola' \n when \n then \n end \n rule 'hola' \n when \n then \n end";
        ByteArrayInputStream in = new ByteArrayInputStream(drl.getBytes());
        in = new ByteArrayInputStream(drl.getBytes());
        this.fileManagerService.importClassicDRL((InputStream)in, "testDRLImportOverrideExistingPackageName");
        ModuleItem pkg = this.rulesRepository.loadModule("testDRLImportOverrideExistingPackageName");
        Assert.assertNotNull((Object)pkg);
        List<AssetItem> rules = this.iteratorToList(pkg.getAssets());
        Assert.assertEquals((long)3L, (long)rules.size());
        AssetItem pkgConf = rules.get(0);
        Assert.assertEquals((Object)"drools", (Object)pkgConf.getName());
        rules.remove(0);
        AssetItem rule1 = rules.get(0);
        Assert.assertEquals((Object)"ola", (Object)rule1.getName());
        Assert.assertNotNull((Object)rule1.getContent());
        Assert.assertEquals((Object)"drl", (Object)rule1.getFormat());
        Assert.assertTrue((rule1.getContent().indexOf("when") > -1 ? 1 : 0) != 0);
        AssetItem rule2 = rules.get(1);
        Assert.assertEquals((Object)"hola", (Object)rule2.getName());
        Assert.assertNotNull((Object)rule2.getContent());
        Assert.assertEquals((Object)"drl", (Object)rule2.getFormat());
        Assert.assertTrue((rule2.getContent().indexOf("when") > -1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)DroolsHeader.getDroolsHeader((ModuleItem)pkg));
        Assert.assertTrue((DroolsHeader.getDroolsHeader((ModuleItem)pkg).indexOf("import") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testClassicDRLImportWithDSL() throws Exception {
        String drl = "package testClassicDRLImportWithDSL\n import blah \n expander goo \n rule 'ola' \n when \n then \n end \n rule 'hola' \n when \n then \n end";
        ByteArrayInputStream in = new ByteArrayInputStream(drl.getBytes());
        this.fileManagerService.importClassicDRL((InputStream)in, null);
        ModuleItem pkg = this.rulesRepository.loadModule("testClassicDRLImportWithDSL");
        Assert.assertNotNull((Object)pkg);
        List<AssetItem> rules = this.iteratorToList(pkg.getAssets());
        Assert.assertEquals((long)3L, (long)rules.size());
        AssetItem pkgConf = rules.get(0);
        Assert.assertEquals((Object)"drools", (Object)pkgConf.getName());
        Assert.assertEquals((Object)"package", (Object)pkgConf.getFormat());
        rules.remove(0);
        AssetItem rule1 = rules.get(0);
        Assert.assertEquals((Object)"ola", (Object)rule1.getName());
        Assert.assertNotNull((Object)rule1.getContent());
        Assert.assertEquals((Object)"dslr", (Object)rule1.getFormat());
        Assert.assertTrue((rule1.getContent().indexOf("when") > -1 ? 1 : 0) != 0);
        AssetItem rule2 = rules.get(1);
        Assert.assertEquals((Object)"hola", (Object)rule2.getName());
        Assert.assertNotNull((Object)rule2.getContent());
        Assert.assertEquals((Object)"dslr", (Object)rule2.getFormat());
        Assert.assertTrue((rule2.getContent().indexOf("when") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((DroolsHeader.getDroolsHeader((ModuleItem)pkg).indexOf("import") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testHeadOOME() throws Exception {
        ModuleItem pkg = this.rulesRepository.createModule("testHeadOOME", "");
        DroolsHeader.updateDroolsHeader((String)"import java.util.List", (ModuleItem)pkg);
        pkg.updateCompiledBinary((InputStream)new ByteArrayInputStream("foo".getBytes()));
        pkg.checkin("");
        int iterations = 0;
        int maxIteration = 1;
        while (iterations < maxIteration) {
            if (++iterations % 50 == 0) {
                ModuleItem pkg1 = this.rulesRepository.loadModule("testHeadOOME");
                pkg1.updateDescription(System.currentTimeMillis() + "");
                pkg1.checkin("a change");
            }
            this.fileManagerService.getLastModified("testHeadOOME", "LATEST");
            System.err.println("Number " + iterations + " free mem : " + Runtime.getRuntime().freeMemory());
        }
    }

    private List<AssetItem> iteratorToList(Iterator<AssetItem> assets) {
        ArrayList<AssetItem> list = new ArrayList<AssetItem>();
        Iterator<AssetItem> iter = assets;
        while (iter.hasNext()) {
            AssetItem rule = iter.next();
            list.add(rule);
        }
        return list;
    }

    private static class MockFile
    implements FileItem {
        private static final long serialVersionUID = 510L;
        private final String fileName;
        InputStream stream = new ByteArrayInputStream("foo bar".getBytes());

        public MockFile() {
            this.fileName = "foo.bar";
        }

        public MockFile(String fileName) {
            this.fileName = fileName;
        }

        public void setInputStream(InputStream is) throws IOException {
            this.stream.close();
            this.stream = is;
        }

        public void delete() {
        }

        public byte[] get() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public String getFieldName() {
            return null;
        }

        public InputStream getInputStream() throws IOException {
            return this.stream;
        }

        public String getName() {
            return this.fileName;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public long getSize() {
            return 0L;
        }

        public String getString() {
            return null;
        }

        public String getString(String arg0) throws UnsupportedEncodingException {
            return null;
        }

        public boolean isFormField() {
            return false;
        }

        public boolean isInMemory() {
            return false;
        }

        public void setFieldName(String arg0) {
        }

        public void setFormField(boolean arg0) {
        }

        public void write(File arg0) throws Exception {
        }
    }
}

