/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client;

import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceHistoryHandler;
import com.google.gwt.user.client.ui.IsWidget;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.FindPlace;
import org.drools.guvnor.client.explorer.LoadPerspectives;
import org.drools.guvnor.client.explorer.MultiActivityManager;
import org.drools.guvnor.client.explorer.PerspectiveLoader;
import org.drools.guvnor.client.explorer.PerspectivesPanel;
import org.drools.guvnor.client.rpc.ConfigurationServiceAsync;

public class AppController {
    private final ClientFactory clientFactory;
    private final PerspectivesPanel perspectivesPanel;

    public AppController(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        this.perspectivesPanel = this.createPerspectivesPanel();
        this.loadPerspectives();
        this.setUpActivityMapper();
        this.setUpHistoryMapper();
    }

    private void setUpHistoryMapper() {
        PlaceHistoryHandler historyHandler = this.clientFactory.getPlaceHistoryHandler();
        historyHandler.register(this.clientFactory.getPlaceController(), this.clientFactory.getEventBus(), (Place)new FindPlace());
        historyHandler.handleCurrentHistory();
    }

    private PerspectivesPanel createPerspectivesPanel() {
        return new PerspectivesPanel(this.clientFactory.getPerspectivesPanelView(), this.clientFactory.getPlaceController());
    }

    private void setUpActivityMapper() {
        MultiActivityManager activityManager = this.clientFactory.getActivityManager();
        activityManager.setTabbedPanel(this.perspectivesPanel.getTabbedPanel());
    }

    public IsWidget getMainPanel() {
        return this.perspectivesPanel.getView();
    }

    private void loadPerspectives() {
        ConfigurationServiceAsync configurationServiceAsync = this.clientFactory.getConfigurationService();
        PerspectiveLoader perspectiveLoader = new PerspectiveLoader(configurationServiceAsync);
        perspectiveLoader.loadPerspectives((LoadPerspectives)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setUserName(String userName) {
        this.perspectivesPanel.setUserName(userName);
    }

    static /* synthetic */ PerspectivesPanel access$000(AppController x0) {
        return x0.perspectivesPanel;
    }
}

