/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.admin;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.SerializationException;
import java.util.Collection;
import org.drools.guvnor.client.admin.PerspectivesManagerView;
import org.drools.guvnor.client.rpc.ConfigurationServiceAsync;
import org.drools.guvnor.client.rpc.IFramePerspectiveConfiguration;
import org.drools.guvnor.client.util.SaveCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectivesManager
implements PerspectivesManagerView.Presenter {
    private final ConfigurationServiceAsync configurationServiceAsync;
    private final PerspectivesManagerView view;

    public PerspectivesManager(ConfigurationServiceAsync configurationServiceAsync, PerspectivesManagerView view) {
        this.view = view;
        this.view.setPresenter((PerspectivesManagerView.Presenter)this);
        this.configurationServiceAsync = configurationServiceAsync;
        this.loadPerspectives();
    }

    private void loadPerspectives() {
        this.configurationServiceAsync.loadPerspectiveConfigurations((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addPerspectives(Collection<IFramePerspectiveConfiguration> iFramePerspectiveConfigurations) {
        for (IFramePerspectiveConfiguration iFramePerspectiveConfiguration : iFramePerspectiveConfigurations) {
            this.view.addPerspective(iFramePerspectiveConfiguration.getUuid(), iFramePerspectiveConfiguration.getName());
        }
    }

    public void onAddNewPerspective() {
        this.view.openPopUp(this.getSaveCommand());
    }

    public void onEditPerspective() throws SerializationException {
        String selectedPerspectiveUuid = this.view.getSelectedPerspectiveUuid();
        if (selectedPerspectiveUuid == null) {
            this.view.showNoSelectedPerspectiveError();
        } else {
            this.loadPerspective(selectedPerspectiveUuid);
        }
    }

    public void onRemovePerspective() {
        String selectedPerspectiveUuid = this.view.getSelectedPerspectiveUuid();
        if (selectedPerspectiveUuid == null) {
            this.view.showNoSelectedPerspectiveError();
        } else {
            this.deletePerspective(selectedPerspectiveUuid);
        }
    }

    private void savePerspective(IFramePerspectiveConfiguration iFramePerspectiveConfiguration) {
        this.configurationServiceAsync.save(iFramePerspectiveConfiguration, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isAnUpdate(IFramePerspectiveConfiguration iFramePerspectiveConfiguration) {
        return iFramePerspectiveConfiguration.getUuid() != null;
    }

    private void loadPerspective(String selectedPerspectiveUuid) throws SerializationException {
        this.configurationServiceAsync.load(selectedPerspectiveUuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void deletePerspective(String selectedPerspectiveUuid) {
        this.configurationServiceAsync.remove(selectedPerspectiveUuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private SaveCommand<IFramePerspectiveConfiguration> getSaveCommand() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private boolean perspectivesListContainsName(String name) {
        return this.view.getListOfPerspectiveNames().contains(name);
    }

    static /* synthetic */ void access$000(PerspectivesManager x0, Collection x1) {
        x0.addPerspectives(x1);
    }

    static /* synthetic */ boolean access$100(PerspectivesManager x0, IFramePerspectiveConfiguration x1) {
        return x0.isAnUpdate(x1);
    }

    static /* synthetic */ PerspectivesManagerView access$200(PerspectivesManager x0) {
        return x0.view;
    }

    static /* synthetic */ SaveCommand access$300(PerspectivesManager x0) {
        return x0.getSaveCommand();
    }

    static /* synthetic */ boolean access$400(PerspectivesManager x0, String x1) {
        return x0.perspectivesListContainsName(x1);
    }

    static /* synthetic */ void access$500(PerspectivesManager x0, IFramePerspectiveConfiguration x1) {
        x0.savePerspective(x1);
    }
}

