/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.ClosableLabel;
import org.drools.guvnor.client.explorer.ExplorerViewCenterPanel;
import org.drools.guvnor.client.packages.PackageEditorWrapper;
import org.drools.guvnor.client.util.ScrollTabLayoutPanel;
import org.drools.guvnor.client.util.TabbedPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplorerViewCenterPanel
extends Composite
implements TabbedPanel {
    private final ScrollTabLayoutPanel tabLayoutPanel;
    private PanelMap openedTabs = new PanelMap(this, null);
    private Map<String, PackageEditorWrapper> openedPackageEditors = new HashMap();
    private ClientFactory clientFactory;

    public ExplorerViewCenterPanel(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        this.tabLayoutPanel = new ScrollTabLayoutPanel();
        this.addBeforeSelectionHandler();
        this.initWidget((Widget)this.tabLayoutPanel);
    }

    private void addBeforeSelectionHandler() {
        this.tabLayoutPanel.addBeforeSelectionHandler((BeforeSelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean contains(Place key) {
        return this.openedTabs.contains(key);
    }

    public void show(Place key) {
        if (this.openedTabs.contains(key)) {
            LoadingPopup.close();
            this.tabLayoutPanel.selectTab((Widget)this.openedTabs.get(key));
        }
    }

    public void addTab(String tabname, IsWidget widget, Place place) {
        ScrollPanel localTP = new ScrollPanel();
        localTP.add(widget);
        this.tabLayoutPanel.add((Widget)localTP, this.newClosableLabel(tabname, place));
        this.tabLayoutPanel.selectTab((Widget)localTP);
        if (widget instanceof PackageEditorWrapper) {
            this.getOpenedPackageEditors().put(tabname, (PackageEditorWrapper)widget);
        }
        this.openedTabs.put(place, (Panel)localTP);
    }

    private Widget newClosableLabel(String title, Place place) {
        ClosableLabel closableLabel = new ClosableLabel(title);
        closableLabel.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
        return closableLabel;
    }

    public void close(Place key) {
        int widgetIndex = this.openedTabs.getIndex(key);
        Place nextPlace = this.getPlace(widgetIndex);
        this.tabLayoutPanel.remove((Widget)this.openedTabs.get(key));
        this.openedTabs.remove(key);
        if (nextPlace != null) {
            this.goTo(nextPlace);
        }
    }

    private Place getPlace(int widgetIndex) {
        if (this.isOnlyOneTabLeft()) {
            return Place.NOWHERE;
        }
        if (this.isSelectedTabIndex(widgetIndex)) {
            return this.getNeighbour(widgetIndex);
        }
        return null;
    }

    private void goTo(Place place) {
        this.clientFactory.getPlaceController().goTo(place);
    }

    private Place getNeighbour(int widgetIndex) {
        if (this.isLeftMost(widgetIndex)) {
            return this.getNextPlace();
        }
        return this.getPreviousPlace();
    }

    private boolean isLeftMost(int widgetIndex) {
        return widgetIndex == 0;
    }

    private boolean isSelectedTabIndex(int widgetIndex) {
        return this.tabLayoutPanel.getSelectedIndex() == widgetIndex;
    }

    private Place getPreviousPlace() {
        return this.openedTabs.getKey(this.tabLayoutPanel.getSelectedIndex() - 1);
    }

    private Place getNextPlace() {
        return this.openedTabs.getKey(this.tabLayoutPanel.getSelectedIndex() + 1);
    }

    private boolean isOnlyOneTabLeft() {
        return this.tabLayoutPanel.getWidgetCount() == 1;
    }

    public Map<String, PackageEditorWrapper> getOpenedPackageEditors() {
        return this.openedPackageEditors;
    }

    static /* synthetic */ ScrollTabLayoutPanel access$100(ExplorerViewCenterPanel x0) {
        return x0.tabLayoutPanel;
    }

    static /* synthetic */ PanelMap access$200(ExplorerViewCenterPanel x0) {
        return x0.openedTabs;
    }

    static /* synthetic */ ClientFactory access$300(ExplorerViewCenterPanel x0) {
        return x0.clientFactory;
    }
}

